/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.experimental;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rR\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u000f*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/experimental/EmptyRangeChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "<init>", "()V", "check", "", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)V", "rangeLeft", "", "getRangeLeft", "(Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)Ljava/lang/Long;", "rangeRight", "getRangeRight", "checkers"})
public final class EmptyRangeChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final EmptyRangeChecker INSTANCE = new EmptyRangeChecker();

    private EmptyRangeChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirFunctionCall expression2) {
        boolean needReport;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        KtSourceElement ktSourceElement = expression2.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
            return;
        }
        Long l2 = this.getRangeLeft(expression2);
        if (l2 == null) {
            return;
        }
        long left = l2;
        Long l3 = this.getRangeRight(expression2);
        if (l3 == null) {
            return;
        }
        long right = l3;
        switch (expression2.getCalleeReference().getName().asString()) {
            case "rangeTo": {
                boolean bl2;
                if (left > right) {
                    bl2 = true;
                    break;
                }
                bl2 = false;
                break;
            }
            case "downTo": {
                boolean bl2;
                if (right > left) {
                    bl2 = true;
                    break;
                }
                bl2 = false;
                break;
            }
            case "until": {
                boolean bl2;
                if (left >= right) {
                    bl2 = true;
                    break;
                }
                bl2 = false;
                break;
            }
            default: {
                boolean bl2 = needReport = false;
            }
        }
        if (needReport) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getEMPTY_RANGE(), null, 8, null);
        }
    }

    private final Long getRangeLeft(FirFunctionCall $this$rangeLeft) {
        FirExpression firExpression = $this$rangeLeft.getExplicitReceiver();
        FirLiteralExpression firLiteralExpression = firExpression instanceof FirLiteralExpression ? (FirLiteralExpression)firExpression : null;
        Object object = firLiteralExpression != null ? firLiteralExpression.getValue() : null;
        return object instanceof Long ? (Long)object : null;
    }

    private final Long getRangeRight(FirFunctionCall $this$rangeRight) {
        FirLiteralExpression arg;
        Object object = CollectionsKt.getOrNull($this$rangeRight.getArgumentList().getArguments(), (int)0);
        FirLiteralExpression firLiteralExpression = arg = object instanceof FirLiteralExpression ? (FirLiteralExpression)object : null;
        object = firLiteralExpression != null ? firLiteralExpression.getValue() : null;
        return object instanceof Long ? (Long)object : null;
    }
}

