/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import ksp.com.intellij.openapi.application.PathManager;
import ksp.com.intellij.openapi.util.NlsSafe;
import ksp.com.intellij.openapi.util.SystemInfoRt;
import ksp.com.intellij.openapi.util.registry.EarlyAccessRegistryManager;
import ksp.com.intellij.util.concurrency.SynchronizedClearableLazy;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.Contract;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class BuildNumber
implements Comparable<BuildNumber> {
    private static final String STAR = "*";
    private static final String SNAPSHOT = "SNAPSHOT";
    private static final String FALLBACK_VERSION = "999.SNAPSHOT";
    public static final int SNAPSHOT_VALUE = Integer.MAX_VALUE;
    @NotNull
    private final String myProductCode;
    private final int @NotNull [] myComponents;
    private static final Supplier<BuildNumber> CURRENT_VERSION = new SynchronizedClearableLazy<BuildNumber>(BuildNumber::fromFile);

    public BuildNumber(@NotNull String productCode, int baselineVersion, int buildNumber) {
        if (productCode == null) {
            BuildNumber.$$$reportNull$$$0(0);
        }
        this(productCode, new int[]{baselineVersion, buildNumber});
    }

    public BuildNumber(@NotNull String productCode, int ... components) {
        if (productCode == null) {
            BuildNumber.$$$reportNull$$$0(1);
        }
        if (components == null) {
            BuildNumber.$$$reportNull$$$0(2);
        }
        this.myProductCode = productCode;
        this.myComponents = components;
    }

    private static boolean isPlaceholder(String value2) {
        return "__BUILD_NUMBER__".equals(value2) || "__BUILD__".equals(value2);
    }

    @NotNull
    public String getProductCode() {
        String string = this.myProductCode;
        if (string == null) {
            BuildNumber.$$$reportNull$$$0(3);
        }
        return string;
    }

    public int getBaselineVersion() {
        return this.myComponents[0];
    }

    public int @NotNull [] getComponents() {
        int[] nArray = (int[])this.myComponents.clone();
        if (nArray == null) {
            BuildNumber.$$$reportNull$$$0(4);
        }
        return nArray;
    }

    public boolean isSnapshot() {
        int result2 = -1;
        for (int i2 = 0; i2 < this.myComponents.length; ++i2) {
            if (this.myComponents[i2] != Integer.MAX_VALUE) continue;
            result2 = i2;
            break;
        }
        return result2 != -1;
    }

    @Contract(pure=true)
    @NotNull
    public BuildNumber withoutProductCode() {
        return this.myProductCode.isEmpty() ? this : new BuildNumber("", this.myComponents);
    }

    @NotNull
    @NlsSafe
    public String asString() {
        return this.asString(true, true);
    }

    @NotNull
    @NlsSafe
    public String asStringWithoutProductCode() {
        return this.asString(false, true);
    }

    @NotNull
    public String asStringWithoutProductCodeAndSnapshot() {
        return this.asString(false, false);
    }

    @NotNull
    private String asString(boolean includeProductCode, boolean withSnapshotMarker) {
        StringBuilder builder2 = new StringBuilder();
        if (includeProductCode && !this.myProductCode.isEmpty()) {
            builder2.append(this.myProductCode).append('-');
        }
        for (int each : this.myComponents) {
            if (each != Integer.MAX_VALUE) {
                builder2.append(each);
            } else if (withSnapshotMarker) {
                builder2.append(SNAPSHOT);
            }
            builder2.append('.');
        }
        if (builder2.charAt(builder2.length() - 1) == '.') {
            builder2.setLength(builder2.length() - 1);
        }
        String string = builder2.toString();
        if (string == null) {
            BuildNumber.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public static BuildNumber fromPluginCompatibleBuild() {
        return BuildNumber.fromString(BuildNumber.getPluginCompatibleBuild());
    }

    @Nullable
    public static BuildNumber fromStringOrNull(@NotNull String version) {
        if (version == null) {
            BuildNumber.$$$reportNull$$$0(6);
        }
        try {
            return BuildNumber.fromString(version);
        }
        catch (RuntimeException ignored) {
            return null;
        }
    }

    @Nullable
    public static BuildNumber fromString(@Nullable String version) {
        if (version == null) {
            return null;
        }
        version = version.trim();
        return BuildNumber.fromString(version, null, null);
    }

    @Nullable
    public static BuildNumber fromStringWithProductCode(@NotNull String version, @NotNull String productCode) {
        if (version == null) {
            BuildNumber.$$$reportNull$$$0(7);
        }
        if (productCode == null) {
            BuildNumber.$$$reportNull$$$0(8);
        }
        return BuildNumber.fromString(version, null, productCode);
    }

    @Nullable
    public static BuildNumber fromString(@NotNull String version, @Nullable String pluginName, @Nullable String productCodeIfAbsentInVersion) {
        String productCode;
        if (version == null) {
            BuildNumber.$$$reportNull$$$0(9);
        }
        if (version.isEmpty()) {
            return null;
        }
        String code = version;
        int productSeparator = code.indexOf(45);
        if (productSeparator > 0) {
            productCode = code.substring(0, productSeparator);
            code = code.substring(productSeparator + 1);
        } else {
            String string = productCode = productCodeIfAbsentInVersion == null ? "" : productCodeIfAbsentInVersion;
        }
        if (SNAPSHOT.equals(code) || BuildNumber.isPlaceholder(code)) {
            return new BuildNumber(productCode, BuildNumber.currentVersion().myComponents);
        }
        int baselineVersionSeparator = code.indexOf(46);
        if (baselineVersionSeparator > 0) {
            String baselineVersionString = code.substring(0, baselineVersionSeparator);
            if (baselineVersionString.trim().isEmpty()) {
                return null;
            }
            String[] stringComponents = code.split("\\.");
            int[] intComponentList = new int[stringComponents.length];
            int n2 = stringComponents.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                int component;
                String stringComponent = stringComponents[i2];
                intComponentList[i2] = component = BuildNumber.parseBuildNumber(version, stringComponent, pluginName);
                if (component != Integer.MAX_VALUE || i2 + 1 == n2) continue;
                intComponentList = Arrays.copyOf(intComponentList, i2 + 1);
                break;
            }
            return new BuildNumber(productCode, intComponentList);
        }
        int buildNumber = BuildNumber.parseBuildNumber(version, code, pluginName);
        if (buildNumber <= 2000) {
            return new BuildNumber(productCode, buildNumber, 0);
        }
        int baselineVersion = BuildNumber.getBaseLineForHistoricBuilds(buildNumber);
        return new BuildNumber(productCode, baselineVersion, buildNumber);
    }

    private static int parseBuildNumber(String version, @NotNull String code, String pluginName) {
        if (code == null) {
            BuildNumber.$$$reportNull$$$0(10);
        }
        if (SNAPSHOT.equals(code) || BuildNumber.isPlaceholder(code) || STAR.equals(code)) {
            return Integer.MAX_VALUE;
        }
        try {
            return Integer.parseInt(code);
        }
        catch (NumberFormatException e2) {
            throw new RuntimeException("Invalid version number: " + version + "; plugin name: " + pluginName);
        }
    }

    @Override
    public int compareTo(@NotNull BuildNumber o2) {
        if (o2 == null) {
            BuildNumber.$$$reportNull$$$0(11);
        }
        int[] c1 = this.myComponents;
        int[] c2 = o2.myComponents;
        for (int i2 = 0; i2 < Math.min(c1.length, c2.length); ++i2) {
            if (c1[i2] == c2[i2] && c1[i2] == Integer.MAX_VALUE) {
                return 0;
            }
            if (c1[i2] == Integer.MAX_VALUE) {
                return 1;
            }
            if (c2[i2] == Integer.MAX_VALUE) {
                return -1;
            }
            int result2 = c1[i2] - c2[i2];
            if (result2 == 0) continue;
            return result2;
        }
        return c1.length - c2.length;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        BuildNumber that = (BuildNumber)o2;
        if (!this.myProductCode.equals(that.myProductCode)) {
            return false;
        }
        return Arrays.equals(this.myComponents, that.myComponents);
    }

    public int hashCode() {
        int result2 = this.myProductCode.hashCode();
        result2 = 31 * result2 + Arrays.hashCode(this.myComponents);
        return result2;
    }

    public String toString() {
        return this.asString();
    }

    private static int getBaseLineForHistoricBuilds(int bn) {
        if (bn >= 10000) {
            return 88;
        }
        if (bn >= 9500) {
            return 85;
        }
        if (bn >= 9100) {
            return 81;
        }
        if (bn >= 8000) {
            return 80;
        }
        if (bn >= 7500) {
            return 75;
        }
        if (bn >= 7200) {
            return 72;
        }
        if (bn >= 6900) {
            return 69;
        }
        if (bn >= 6500) {
            return 65;
        }
        if (bn >= 6000) {
            return 60;
        }
        if (bn >= 5000) {
            return 55;
        }
        if (bn >= 4000) {
            return 50;
        }
        return 40;
    }

    @NotNull
    private static BuildNumber fromFile() {
        String homePath = PathManager.getHomePath();
        Path home = Paths.get(homePath, new String[0]);
        BuildNumber result2 = BuildNumber.readFile(home.resolve("build.txt"));
        if (result2 != null) {
            BuildNumber buildNumber = result2;
            if (buildNumber == null) {
                BuildNumber.$$$reportNull$$$0(12);
            }
            return buildNumber;
        }
        if (SystemInfoRt.isMac && (result2 = BuildNumber.readFile(home.resolve("Resources/build.txt"))) != null) {
            BuildNumber buildNumber = result2;
            if (buildNumber == null) {
                BuildNumber.$$$reportNull$$$0(13);
            }
            return buildNumber;
        }
        String communityHomePath = PathManager.getCommunityHomePath();
        if (!communityHomePath.equals(homePath) && (result2 = BuildNumber.readFile(Paths.get(communityHomePath, "build.txt"))) != null) {
            BuildNumber buildNumber = result2;
            if (buildNumber == null) {
                BuildNumber.$$$reportNull$$$0(14);
            }
            return buildNumber;
        }
        BuildNumber buildNumber = Objects.requireNonNull(BuildNumber.fromString(FALLBACK_VERSION));
        if (buildNumber == null) {
            BuildNumber.$$$reportNull$$$0(15);
        }
        return buildNumber;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static BuildNumber readFile(@NotNull Path path) {
        if (path == null) {
            BuildNumber.$$$reportNull$$$0(16);
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            String text = reader.readLine();
            if (text == null) return null;
            BuildNumber buildNumber = BuildNumber.fromString(text);
            return buildNumber;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @ApiStatus.Internal
    @NotNull
    public static BuildNumber currentVersion() {
        BuildNumber buildNumber = CURRENT_VERSION.get();
        if (buildNumber == null) {
            BuildNumber.$$$reportNull$$$0(17);
        }
        return buildNumber;
    }

    @Nullable
    private static String getPluginCompatibleBuild() {
        return EarlyAccessRegistryManager.INSTANCE.getString("idea.plugins.compatible.build");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "productCode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/openapi/util/BuildNumber";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "code";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/openapi/util/BuildNumber";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProductCode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "asString";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "fromFile";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "currentVersion";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fromStringOrNull";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fromStringWithProductCode";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseBuildNumber";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "readFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

