/*
 * Copyright 2010-2018 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.psi.stubs.impl

import ksp.com.intellij.psi.PsiElement
import ksp.com.intellij.psi.stubs.StubElement
import ksp.org.jetbrains.kotlin.psi.KtValueArgument
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinValueArgumentStub
import ksp.org.jetbrains.kotlin.psi.stubs.elements.KtValueArgumentElementType

class KotlinValueArgumentStubImpl<T : KtValueArgument>(
    parent: StubElement<out PsiElement>?,
    elementType: KtValueArgumentElementType<T>,
    private val isSpread: Boolean
) : KotlinPlaceHolderStubImpl<T>(parent, elementType), KotlinValueArgumentStub<T> {
    override fun isSpread(): Boolean = isSpread
}