/*
 * Copyright 2010-2025 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.psi.stubs.impl

import ksp.com.intellij.psi.PsiElement
import ksp.com.intellij.psi.stubs.StubElement
import ksp.com.intellij.util.io.StringRef
import ksp.org.jetbrains.kotlin.psi.KtContextReceiver
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinContextReceiverStub
import ksp.org.jetbrains.kotlin.psi.stubs.elements.KtContextReceiverElementType

class KotlinContextReceiverStubImpl(
    parent: StubElement<out PsiElement>?,
    elementType: KtContextReceiverElementType,
    private val label: StringRef?,
) : KotlinStubBaseImpl<KtContextReceiver>(parent, elementType), KotlinContextReceiverStub {
    override fun getLabel(): String? = label?.string
}
