/*
 * Copyright 2010-2018 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.psi.stubs.impl

import ksp.com.intellij.psi.PsiElement
import ksp.com.intellij.psi.stubs.StubElement
import ksp.com.intellij.util.io.StringRef
import ksp.org.jetbrains.kotlin.psi.KtConstantExpression
import ksp.org.jetbrains.kotlin.psi.stubs.ConstantValueKind
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinConstantExpressionStub
import ksp.org.jetbrains.kotlin.psi.stubs.elements.KtConstantExpressionElementType

class KotlinConstantExpressionStubImpl(
    parent: StubElement<out PsiElement>?,
    elementType: KtConstantExpressionElementType,
    private val kind: ConstantValueKind,
    private val value: StringRef
) : KotlinStubBaseImpl<KtConstantExpression>(parent, elementType), KotlinConstantExpressionStub {
    override fun kind(): ConstantValueKind = kind
    override fun value(): String = StringRef.toString(value)
}