/*
 * Copyright 2010-2023 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir.analysis.js.checkers.expression

import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirGetClassCallChecker
import ksp.org.jetbrains.kotlin.fir.analysis.js.checkers.checkJsModuleUsage
import ksp.org.jetbrains.kotlin.fir.expressions.FirGetClassCall
import ksp.org.jetbrains.kotlin.fir.types.resolvedType
import ksp.org.jetbrains.kotlin.fir.resolve.toSymbol


object FirJsModuleGetClassCallChecker : FirGetClassCallChecker(MppCheckerKind.Common) {
    context(context: CheckerContext, reporter: DiagnosticReporter)
    override fun check(expression: FirGetClassCall) {
        val callee = expression.argument.resolvedType.toSymbol(context.session) ?: return
        checkJsModuleUsage(callee, context, reporter, expression.source)
    }
}
