/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.analysis.api.fir.modification

import ksp.com.intellij.openapi.project.Project
import ksp.com.intellij.psi.PsiElement
import ksp.org.jetbrains.kotlin.analysis.api.platform.modification.KaElementModificationType
import ksp.org.jetbrains.kotlin.analysis.api.platform.modification.KaSourceModificationService
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.LLFirInternals
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.LLFirDeclarationModificationService

@OptIn(LLFirInternals::class)
internal class KaFirSourceModificationService(private val project: Project) : KaSourceModificationService {
    override fun handleElementModification(
        element: PsiElement,
        modificationType: KaElementModificationType,
    ) {
        LLFirDeclarationModificationService.getInstance(project).elementModified(element, modificationType)
    }

    override fun ancestorAffectedByInBlockModification(element: PsiElement): PsiElement? =
        LLFirDeclarationModificationService.getInstance(project).ancestorAffectedByInBlockModification(element)
}
