// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.psi.impl.java.stubs;

import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.lang.LighterAST;
import ksp.com.intellij.lang.LighterASTNode;
import ksp.com.intellij.psi.PsiImportList;
import ksp.com.intellij.psi.impl.java.stubs.impl.PsiImportListStubImpl;
import ksp.com.intellij.psi.impl.source.BasicJavaElementType;
import ksp.com.intellij.psi.impl.source.PsiImportListImpl;
import ksp.com.intellij.psi.impl.source.tree.java.ImportListElement;
import ksp.com.intellij.psi.stubs.*;
import ksp.org.jetbrains.annotations.NotNull;

public final class JavaImportListElementType extends JavaStubElementType<PsiImportListStub, PsiImportList>
  implements EmptyStubSerializer<PsiImportListStub> {
  public JavaImportListElementType() {
    super("IMPORT_LIST", BasicJavaElementType.BASIC_IMPORT_LIST);
  }

  @NotNull
  @Override
  public ASTNode createCompositeNode() {
    return new ImportListElement();
  }

  @Override
  public PsiImportList createPsi(@NotNull final PsiImportListStub stub) {
    return getPsiFactory(stub).createImportList(stub);
  }

  @Override
  public PsiImportList createPsi(@NotNull final ASTNode node) {
    return new PsiImportListImpl(node);
  }

  @NotNull
  @Override
  public PsiImportListStub createStub(@NotNull final LighterAST tree, @NotNull final LighterASTNode node, final @NotNull StubElement<?> parentStub) {
    return new PsiImportListStubImpl(parentStub);
  }

  @NotNull
  @Override
  public PsiImportListStub instantiate(final StubElement parentStub) {
    return new PsiImportListStubImpl(parentStub);
  }

  @Override
  public void indexStub(@NotNull final PsiImportListStub stub, @NotNull final IndexSink sink) {
  }
}
