// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.diagnostic;

import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

interface PluginProblemReporter {
  static PluginProblemReporter getInstance() {
    if (ApplicationManager.getApplication() == null) {
      //if the application isn't initialized yet return silly implementation which reports all plugins problems as platform ones
      return new PluginProblemReporter() {
        @Override
        public @NotNull PluginException createPluginExceptionByClass(@NotNull String errorMessage,
                                                                     @Nullable Throwable cause,
                                                                     @NotNull Class pluginClass) {
          return new PluginException(errorMessage, cause, null);
        }
      };
    }

    return ApplicationManager.getApplication().getService(PluginProblemReporter.class);
  }

  @NotNull
  PluginException createPluginExceptionByClass(@NotNull String errorMessage, @Nullable Throwable cause, @NotNull Class<?> pluginClass);
}
