/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.library.impl;

import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.library.impl.LowLevelReadersKt;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0002\u0016\u0017J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\u00020\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\u0005\"\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0005\u0082\u0001\u0002\u0018\u0019\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001a\u00c0\u0006\u0001"}, d2={"Lksp/org/jetbrains/kotlin/library/impl/ReadBuffer;", "", "int", "", "getInt", "()I", "long", "", "getLong", "()J", "position", "getPosition", "setPosition", "(I)V", "size", "getSize", "get", "", "result", "", "offset", "length", "MemoryBuffer", "OnDemandMemoryBuffer", "Lksp/org/jetbrains/kotlin/library/impl/ReadBuffer$MemoryBuffer;", "Lksp/org/jetbrains/kotlin/library/impl/ReadBuffer$OnDemandMemoryBuffer;", "kotlin-util-klib"})
public interface ReadBuffer {
    public int getSize();

    public void get(@NotNull byte[] var1, int var2, int var3);

    public int getPosition();

    public void setPosition(int var1);

    public int getInt();

    public long getLong();

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR$\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\n\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\n\u00a8\u0006\u001b"}, d2={"Lksp/org/jetbrains/kotlin/library/impl/ReadBuffer$MemoryBuffer;", "Lksp/org/jetbrains/kotlin/library/impl/ReadBuffer;", "bytes", "", "([B)V", "buffer", "Ljava/nio/ByteBuffer;", "int", "", "getInt", "()I", "long", "", "getLong", "()J", "value", "position", "getPosition", "setPosition", "(I)V", "size", "getSize", "get", "", "result", "offset", "length", "kotlin-util-klib"})
    public static final class MemoryBuffer
    implements ReadBuffer {
        @NotNull
        private final ByteBuffer buffer;

        public MemoryBuffer(@NotNull byte[] bytes) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            this.buffer = LowLevelReadersKt.getBuffer(bytes);
        }

        @Override
        public int getSize() {
            return this.buffer.limit();
        }

        @Override
        public void get(@NotNull byte[] result2, int offset, int length) {
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            this.buffer.get(result2, offset, length);
        }

        @Override
        public int getPosition() {
            return this.buffer.position();
        }

        @Override
        public void setPosition(int value2) {
            this.buffer.position(value2);
        }

        @Override
        public int getInt() {
            return this.buffer.getInt();
        }

        @Override
        public long getLong() {
            return this.buffer.getLong();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0019\u001a\u00020\bH\u0002J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\nH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\f\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\f\u00a8\u0006\u001f"}, d2={"Lksp/org/jetbrains/kotlin/library/impl/ReadBuffer$OnDemandMemoryBuffer;", "Lksp/org/jetbrains/kotlin/library/impl/ReadBuffer;", "loadBytes", "Lkotlin/Function0;", "", "(Lkotlin/jvm/functions/Function0;)V", "bufferRef", "Ljava/lang/ref/SoftReference;", "Ljava/nio/ByteBuffer;", "int", "", "getInt", "()I", "long", "", "getLong", "()J", "pos", "value", "position", "getPosition", "setPosition", "(I)V", "size", "getSize", "ensureBuffer", "get", "", "result", "offset", "length", "kotlin-util-klib"})
    @SourceDebugExtension(value={"SMAP\nReadBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReadBuffer.kt\norg/jetbrains/kotlin/library/impl/ReadBuffer$OnDemandMemoryBuffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n1#2:108\n*E\n"})
    public static final class OnDemandMemoryBuffer
    implements ReadBuffer {
        @NotNull
        private final Function0<byte[]> loadBytes;
        @NotNull
        private SoftReference<ByteBuffer> bufferRef;
        private int pos;

        public OnDemandMemoryBuffer(@NotNull Function0<byte[]> loadBytes) {
            Intrinsics.checkNotNullParameter(loadBytes, (String)"loadBytes");
            this.loadBytes = loadBytes;
            this.bufferRef = new SoftReference<Object>(null);
        }

        @Override
        public int getSize() {
            return this.ensureBuffer().limit();
        }

        @Override
        public void get(@NotNull byte[] result2, int offset, int length) {
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            ByteBuffer buf = this.ensureBuffer();
            this.pos += length;
            buf.get(result2, offset, length);
        }

        @Override
        public int getPosition() {
            boolean bl2;
            int n2;
            int it = n2 = this.pos;
            boolean bl3 = false;
            boolean bl4 = bl2 = it == this.ensureBuffer().position();
            if (_Assertions.ENABLED && !bl2) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            return n2;
        }

        @Override
        public void setPosition(int value2) {
            ByteBuffer buf = this.ensureBuffer();
            this.pos = value2;
            buf.position(value2);
        }

        @Override
        public int getInt() {
            ByteBuffer buf = this.ensureBuffer();
            this.pos += 4;
            return buf.getInt();
        }

        @Override
        public long getLong() {
            ByteBuffer buf = this.ensureBuffer();
            this.pos += 8;
            return buf.getLong();
        }

        private final ByteBuffer ensureBuffer() {
            ByteBuffer tmpBuffer = this.bufferRef.get();
            if (tmpBuffer == null) {
                tmpBuffer = LowLevelReadersKt.getBuffer((byte[])this.loadBytes.invoke());
                tmpBuffer.position(this.pos);
                this.bufferRef = new SoftReference<ByteBuffer>(tmpBuffer);
            }
            return tmpBuffer;
        }
    }
}

