/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.EnumValueArgumentInfo;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import ksp.org.jetbrains.kotlin.name.JvmStandardClassIds;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.name.StandardClassIds;
import ksp.org.jetbrains.kotlin.utils.KotlinToJavaAnnotationTargetsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J&\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012*\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirIncompatibleAnnotationsChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirClass;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reportIncompatibleTargets", "kotlinTarget", "Lksp/org/jetbrains/kotlin/fir/expressions/FirAnnotation;", "javaTarget", "extractArguments", "", "", "argumentName", "Lksp/org/jetbrains/kotlin/name/Name;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirIncompatibleAnnotationsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirIncompatibleAnnotationsChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirIncompatibleAnnotationsChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n1491#2:64\n1516#2,3:65\n1519#2,3:75\n1869#2,2:78\n1625#2:80\n1869#2:81\n1870#2:83\n1626#2:84\n384#3,7:68\n1#4:82\n*S KotlinDebug\n*F\n+ 1 FirIncompatibleAnnotationsChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirIncompatibleAnnotationsChecker\n*L\n41#1:64\n41#1:65,3\n41#1:75,3\n44#1:78,2\n60#1:80\n60#1:81\n60#1:83\n60#1:84\n41#1:68,7\n60#1:82\n*E\n"})
public final class FirIncompatibleAnnotationsChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirIncompatibleAnnotationsChecker INSTANCE = new FirIncompatibleAnnotationsChecker();

    private FirIncompatibleAnnotationsChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirAnnotation firAnnotation = FirAnnotationUtilsKt.getAnnotationByClassId(declaration2, JvmStandardClassIds.Annotations.Java.INSTANCE.getTarget(), context2.getSession());
        if (firAnnotation == null) {
            return;
        }
        FirAnnotation javaTarget = firAnnotation;
        FirAnnotation kotlinTarget = FirAnnotationHelpersKt.getTargetAnnotation(declaration2, context2.getSession());
        if (kotlinTarget == null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)javaTarget.getSource(), FirJvmErrors.INSTANCE.getANNOTATION_TARGETS_ONLY_IN_JAVA(), (DiagnosticContext)context2, null, 8, null);
        } else {
            this.reportIncompatibleTargets(kotlinTarget, javaTarget, context2, reporter);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void reportIncompatibleTargets(@NotNull FirAnnotation kotlinTarget, @NotNull FirAnnotation javaTarget, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Intrinsics.checkNotNullParameter((Object)kotlinTarget, (String)"kotlinTarget");
        Intrinsics.checkNotNullParameter((Object)javaTarget, (String)"javaTarget");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Iterable iterable = this.extractArguments(kotlinTarget, StandardClassIds.Annotations.ParameterNames.INSTANCE.getTargetAllowedTargets());
        boolean $i$f$groupBy = false;
        Iterator iterator2 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            String key$iv$iv = KotlinToJavaAnnotationTargetsKt.getKOTLIN_TO_JAVA_ANNOTATION_TARGETS().get(it);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map correspondingJavaTargets = MapsKt.toMutableMap((Map)destination$iv$iv);
        correspondingJavaTargets.remove(null);
        Iterable $this$forEach$iv = this.extractArguments(javaTarget, StandardClassIds.Annotations.ParameterNames.INSTANCE.getValue());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl4 = false;
            correspondingJavaTargets.remove(it);
        }
        if (!correspondingJavaTargets.isEmpty()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)javaTarget.getSource(), FirJvmErrors.INSTANCE.getINCOMPATIBLE_ANNOTATION_TARGETS(), (Object)CollectionsKt.filterNotNull((Iterable)correspondingJavaTargets.keySet()), (Object)CollectionsKt.flatten((Iterable)correspondingJavaTargets.values()), (DiagnosticContext)context2, null, 32, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> extractArguments(FirAnnotation $this$extractArguments, Name argumentName) {
        void destination$iv;
        void $this$mapNotNullTo$iv;
        FirExpression firExpression = FirAnnotationUtilsKt.findArgumentByName$default($this$extractArguments, argumentName, false, 2, null);
        List list = firExpression != null ? FirExpressionUtilKt.unwrapAndFlattenArgument(firExpression, true) : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        Iterable iterable = list;
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl2 = false;
            FirExpression argument = (FirExpression)element$iv;
            boolean bl3 = false;
            Object object = FirAnnotationUtilsKt.extractEnumValueArgumentInfo(argument);
            if ((object != null && (object = ((EnumValueArgumentInfo)object).getEnumEntryName()) != null ? ((Name)object).asString() : null) == null) continue;
            it$iv = it$iv;
            boolean bl4 = false;
            destination$iv.add(it$iv);
        }
        return (Set)destination$iv;
    }
}

