/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import ksp.org.jetbrains.kotlin.descriptors.RelationToType;
import ksp.org.jetbrains.kotlin.descriptors.Visibility;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory4;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.ClassMembersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirConstructor;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import ksp.org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import ksp.org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import ksp.org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import ksp.org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import ksp.org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import ksp.org.jetbrains.kotlin.fir.declarations.FirValueParameterKind;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import ksp.org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import ksp.org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import ksp.org.jetbrains.kotlin.fir.types.ConeStarProjection;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import ksp.org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.TypeComponentsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001/B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J(\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J$\u0010\u001a\u001a\u00020\u0007*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J,\u0010\u001d\u001a\u00020\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J8\u0010\"\u001a\u0004\u0018\u00010#*\u00020$2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u00132\b\b\u0002\u0010&\u001a\u00020'2\u000e\b\u0002\u0010(\u001a\b\u0012\u0004\u0012\u00020$0)H\u0002J$\u0010*\u001a\u00020#2\n\u0010+\u001a\u0006\u0012\u0002\b\u00030,2\u0006\u0010-\u001a\u00020\u00132\u0006\u0010.\u001a\u00020'H\u0002\u00a8\u00060"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExposedVisibilityDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkClass", "Lksp/org/jetbrains/kotlin/fir/declarations/FirRegularClass;", "checkSupertypes", "checkParameterBounds", "Lksp/org/jetbrains/kotlin/fir/declarations/FirTypeParameterRefsOwner;", "visibility", "Lksp/org/jetbrains/kotlin/descriptors/EffectiveVisibility;", "checkTypeAlias", "Lksp/org/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "checkFunction", "Lksp/org/jetbrains/kotlin/fir/declarations/FirFunction;", "checkProperty", "Lksp/org/jetbrains/kotlin/fir/declarations/FirProperty;", "checkExposure", "Lksp/org/jetbrains/kotlin/fir/declarations/FirValueParameter;", "declarationVisibility", "checkMemberReceiver", "typeRef", "Lksp/org/jetbrains/kotlin/fir/types/FirTypeRef;", "memberDeclaration", "Lksp/org/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "findVisibilityExposure", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExposedVisibilityDeclarationChecker$SymbolWithRelation;", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "base", "ignoreInternalExposure", "", "visitedTypes", "", "symbolWithRelation", "symbol", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "effectiveVisibility", "fromTypeArgument", "SymbolWithRelation", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirExposedVisibilityDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExposedVisibilityDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExposedVisibilityDeclarationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,379:1\n28#2:380\n28#2:381\n28#2:382\n28#2:383\n56#2:384\n28#2:385\n28#2:386\n28#2:387\n45#3:388\n45#3:389\n44#3:391\n44#3:392\n44#3:393\n1#4:390\n*S KotlinDebug\n*F\n+ 1 FirExposedVisibilityDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExposedVisibilityDeclarationChecker\n*L\n50#1:380\n54#1:381\n128#1:382\n149#1:383\n150#1:384\n191#1:385\n250#1:386\n276#1:387\n309#1:388\n310#1:389\n354#1:391\n358#1:392\n361#1:393\n*E\n"})
public final class FirExposedVisibilityDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirExposedVisibilityDeclarationChecker INSTANCE = new FirExposedVisibilityDeclarationChecker();

    private FirExposedVisibilityDeclarationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirDeclaration firDeclaration = declaration2;
        if (firDeclaration instanceof FirAnonymousFunction) {
            return;
        }
        if (firDeclaration instanceof FirTypeAlias) {
            this.checkTypeAlias((FirTypeAlias)declaration2, reporter, context2);
        } else if (firDeclaration instanceof FirProperty) {
            this.checkProperty((FirProperty)declaration2, reporter, context2);
        } else if (firDeclaration instanceof FirFunction) {
            this.checkFunction((FirFunction)declaration2, reporter, context2);
        } else if (firDeclaration instanceof FirRegularClass) {
            this.checkClass((FirRegularClass)declaration2, reporter, context2);
        }
    }

    private final void checkClass(FirRegularClass declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        this.checkSupertypes(declaration2, reporter, context2);
        FirTypeParameterRefsOwner firTypeParameterRefsOwner = declaration2;
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration2;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        this.checkParameterBounds(firTypeParameterRefsOwner, (EffectiveVisibility)object, reporter, context2);
    }

    private final void checkSupertypes(FirRegularClass declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        Object classVisibility;
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration2;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)(classVisibility = object), (Object)EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        List<FirTypeRef> supertypes = declaration2.getSuperTypeRefs();
        boolean isInterface = declaration2.getClassKind() == ClassKind.INTERFACE;
        for (FirTypeRef supertypeRef : supertypes) {
            SymbolWithRelation symbolWithRelation;
            FirRegularClassSymbol classSymbol;
            boolean superIsInterface;
            ConeKotlinType supertype;
            KtSourceElement ktSourceElement = supertypeRef.getSource();
            if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.EnumSuperTypeRef.INSTANCE) || ToSymbolUtilsKt.toRegularClassSymbol(supertype = FirTypeUtilsKt.getConeType(supertypeRef), context2.getSession()) == null || (superIsInterface = classSymbol.getClassKind() == ClassKind.INTERFACE) != isInterface || FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, supertype, context2, (EffectiveVisibility)classVisibility, false, null, 12, null) == null) continue;
            FirClassLikeSymbol<?> restricting = symbolWithRelation.component1();
            EffectiveVisibility restrictingVisibility = symbolWithRelation.component2();
            RelationToType relation = symbolWithRelation.component3();
            KtSourceElement ktSourceElement2 = supertypeRef.getSource();
            if (ktSourceElement2 == null) {
                ktSourceElement2 = declaration2.getSource();
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)ktSourceElement2, isInterface ? FirErrors.INSTANCE.getEXPOSED_SUPER_INTERFACE() : FirErrors.INSTANCE.getEXPOSED_SUPER_CLASS(), classVisibility, restricting, (Object)relation, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 128, null);
        }
    }

    private final void checkParameterBounds(FirTypeParameterRefsOwner declaration2, EffectiveVisibility visibility, DiagnosticReporter reporter, CheckerContext context2) {
        if (Intrinsics.areEqual((Object)visibility, (Object)EffectiveVisibility.Local.INSTANCE) || declaration2 instanceof FirConstructor) {
            return;
        }
        KtDiagnosticFactory4<EffectiveVisibility, FirClassLikeSymbol<?>, RelationToType, EffectiveVisibility> diagnosticForNonInternalBounds = FirExposedVisibilityDeclarationChecker.checkParameterBounds$getDiagnosticByFeature(context2, declaration2, LanguageFeature.ReportExposedTypeForMoreCasesOfTypeParameterBounds);
        KtDiagnosticFactory4<EffectiveVisibility, FirClassLikeSymbol<?>, RelationToType, EffectiveVisibility> diagnosticForInternalBounds = FirExposedVisibilityDeclarationChecker.checkParameterBounds$getDiagnosticByFeature(context2, declaration2, LanguageFeature.ReportExposedTypeForInternalTypeParameterBounds);
        for (FirTypeParameterRef parameter2 : declaration2.getTypeParameters()) {
            for (FirResolvedTypeRef bound : parameter2.getSymbol().getResolvedBounds()) {
                SymbolWithRelation symbolWithRelation = FirExposedVisibilityDeclarationChecker.checkParameterBounds$findVisibilityExposure(bound, context2, visibility, true);
                if (symbolWithRelation == null || (symbolWithRelation = TuplesKt.to((Object)symbolWithRelation, diagnosticForNonInternalBounds)) == null) {
                    SymbolWithRelation symbolWithRelation2 = FirExposedVisibilityDeclarationChecker.checkParameterBounds$findVisibilityExposure(bound, context2, visibility, false);
                    if (symbolWithRelation2 == null) continue;
                    symbolWithRelation = TuplesKt.to((Object)symbolWithRelation2, diagnosticForInternalBounds);
                }
                SymbolWithRelation symbolWithRelation3 = symbolWithRelation;
                SymbolWithRelation symbolWithRelation4 = (SymbolWithRelation)symbolWithRelation3.component1();
                KtDiagnosticFactory4 diagnostic = (KtDiagnosticFactory4)symbolWithRelation3.component2();
                FirClassLikeSymbol<?> restricting = symbolWithRelation4.component1();
                EffectiveVisibility restrictingVisibility = symbolWithRelation4.component2();
                RelationToType relation = symbolWithRelation4.component3();
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)bound.getSource(), diagnostic, (Object)visibility, restricting, (Object)relation, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 128, null);
            }
        }
    }

    private final void checkTypeAlias(FirTypeAlias declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        Object typeAliasVisibility;
        ConeClassLikeType expandedType = FirDeclarationUtilKt.getExpandedConeType(declaration2);
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration2;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)(typeAliasVisibility = object), (Object)EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        this.checkParameterBounds(declaration2, (EffectiveVisibility)typeAliasVisibility, reporter, context2);
        Object object2 = expandedType;
        if (object2 == null || (object2 = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, (ConeKotlinType)object2, context2, (EffectiveVisibility)typeAliasVisibility, false, null, 12, null)) == null) {
            return;
        }
        Object object3 = object2;
        FirClassLikeSymbol<?> restricting = ((SymbolWithRelation)object3).component1();
        EffectiveVisibility restrictingVisibility = ((SymbolWithRelation)object3).component2();
        RelationToType relation = ((SymbolWithRelation)object3).component3();
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getEXPOSED_TYPEALIAS_EXPANDED_TYPE(), typeAliasVisibility, restricting, (Object)relation, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 128, null);
    }

    private final void checkFunction(FirFunction declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        boolean isNonLocal;
        KtSourceElement ktSourceElement = declaration2.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
            return;
        }
        Object functionVisibility = null;
        Intrinsics.checkNotNull((Object)declaration2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration");
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration2;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = functionVisibility = (EffectiveVisibility)EffectiveVisibility.Local.INSTANCE;
        }
        if (declaration2 instanceof FirConstructor) {
            FirMemberDeclaration $this$isFromSealedClass$iv = declaration2;
            boolean $i$f$isFromSealedClass = false;
            if ($this$isFromSealedClass$iv.getStatus().isFromSealedClass()) {
                functionVisibility = EffectiveVisibility.PrivateInClass.INSTANCE;
            }
        }
        boolean bl2 = isNonLocal = !Intrinsics.areEqual((Object)functionVisibility, (Object)EffectiveVisibility.Local.INSTANCE);
        if (!(declaration2 instanceof FirPropertyAccessor)) {
            SymbolWithRelation symbolWithRelation;
            if (isNonLocal && !(declaration2 instanceof FirConstructor) && (symbolWithRelation = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, FirTypeUtilsKt.getConeType(declaration2.getReturnTypeRef()), context2, (EffectiveVisibility)functionVisibility, false, null, 12, null)) != null) {
                SymbolWithRelation symbolWithRelation2 = symbolWithRelation;
                boolean bl3 = false;
                FirClassLikeSymbol<?> restricting = symbolWithRelation2.component1();
                EffectiveVisibility restrictingVisibility = symbolWithRelation2.component2();
                RelationToType relation = symbolWithRelation2.component3();
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getEXPOSED_FUNCTION_RETURN_TYPE(), functionVisibility, restricting, (Object)relation, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 128, null);
            }
            for (FirValueParameter valueParameter2 : declaration2.getValueParameters()) {
                this.checkExposure(valueParameter2, (EffectiveVisibility)functionVisibility, reporter, context2);
            }
            for (FirValueParameter valueParameter2 : declaration2.getContextParameters()) {
                this.checkExposure(valueParameter2, (EffectiveVisibility)functionVisibility, reporter, context2);
            }
        }
        if (isNonLocal) {
            FirReceiverParameter firReceiverParameter = declaration2.getReceiverParameter();
            this.checkMemberReceiver(firReceiverParameter != null ? firReceiverParameter.getTypeRef() : null, declaration2 instanceof FirCallableDeclaration ? (FirCallableDeclaration)declaration2 : null, reporter, context2);
        }
        this.checkParameterBounds(declaration2, (EffectiveVisibility)functionVisibility, reporter, context2);
    }

    private final void checkProperty(FirProperty declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        Object propertyVisibility;
        if (Intrinsics.areEqual((Object)DeclarationAttributesKt.getFromPrimaryConstructor(declaration2), (Object)true)) {
            return;
        }
        if (declaration2.isLocal()) {
            return;
        }
        KtSourceElement ktSourceElement = declaration2.getSource();
        if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.EnumGeneratedDeclaration.INSTANCE)) {
            return;
        }
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration2;
        boolean $i$f$getEffectiveVisibility = false;
        Object object = $this$effectiveVisibility$iv.getStatus();
        Object object2 = object instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)object : null;
        if (object2 == null || (object2 = object2.getEffectiveVisibility()) == null) {
            object2 = EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)(propertyVisibility = object2), (Object)EffectiveVisibility.Local.INSTANCE) || Intrinsics.areEqual((Object)declaration2.getOrigin(), (Object)FirDeclarationOrigin.ScriptCustomization.ResultProperty.INSTANCE)) {
            return;
        }
        SymbolWithRelation symbolWithRelation = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, FirTypeUtilsKt.getConeType(declaration2.getReturnTypeRef()), context2, (EffectiveVisibility)propertyVisibility, false, null, 12, null);
        if (symbolWithRelation != null) {
            object = symbolWithRelation;
            boolean bl2 = false;
            FirClassLikeSymbol<?> restricting = ((SymbolWithRelation)object).component1();
            EffectiveVisibility restrictingVisibility = ((SymbolWithRelation)object).component2();
            RelationToType relation = ((SymbolWithRelation)object).component3();
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getEXPOSED_PROPERTY_TYPE(), propertyVisibility, restricting, (Object)relation, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 128, null);
        }
        FirReceiverParameter firReceiverParameter = declaration2.getReceiverParameter();
        this.checkMemberReceiver(firReceiverParameter != null ? firReceiverParameter.getTypeRef() : null, declaration2, reporter, context2);
        this.checkParameterBounds(declaration2, (EffectiveVisibility)propertyVisibility, reporter, context2);
        for (FirValueParameter parameter2 : declaration2.getContextParameters()) {
            this.checkExposure(parameter2, (EffectiveVisibility)propertyVisibility, reporter, context2);
        }
    }

    private final void checkExposure(FirValueParameter $this$checkExposure, EffectiveVisibility declarationVisibility, DiagnosticReporter reporter, CheckerContext context2) {
        block7: {
            Object propertyVisibility;
            SymbolWithRelation symbolWithRelation;
            if (!Intrinsics.areEqual((Object)declarationVisibility, (Object)EffectiveVisibility.Local.INSTANCE) && (symbolWithRelation = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, FirTypeUtilsKt.getConeType($this$checkExposure.getReturnTypeRef()), context2, declarationVisibility, false, null, 12, null)) != null) {
                SymbolWithRelation symbolWithRelation2 = symbolWithRelation;
                boolean bl2 = false;
                FirClassLikeSymbol<?> restricting = symbolWithRelation2.component1();
                EffectiveVisibility restrictingVisibility = symbolWithRelation2.component2();
                RelationToType relation = symbolWithRelation2.component3();
                if ($this$checkExposure.getValueParameterKind() == FirValueParameterKind.LegacyContextReceiver) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)$this$checkExposure.getSource(), FirErrors.INSTANCE.getEXPOSED_RECEIVER_TYPE(), (Object)declarationVisibility, restricting, (Object)relation, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 128, null);
                } else {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)$this$checkExposure.getSource(), FirErrors.INSTANCE.getEXPOSED_PARAMETER_TYPE(), (Object)declarationVisibility, restricting, (Object)relation, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 128, null);
                }
                return;
            }
            FirProperty firProperty = ClassMembersKt.getCorrespondingProperty($this$checkExposure);
            if (firProperty == null) {
                return;
            }
            FirProperty property2 = firProperty;
            if (property2.isLocal()) {
                return;
            }
            FirMemberDeclaration $this$effectiveVisibility$iv = property2;
            boolean $i$f$getEffectiveVisibility = false;
            Object object = $this$effectiveVisibility$iv.getStatus();
            Object object2 = object instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)object : null;
            if (object2 == null || (object2 = object2.getEffectiveVisibility()) == null) {
                object2 = EffectiveVisibility.Local.INSTANCE;
            }
            if (Intrinsics.areEqual((Object)(propertyVisibility = object2), (Object)EffectiveVisibility.Local.INSTANCE)) {
                return;
            }
            SymbolWithRelation symbolWithRelation3 = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, FirTypeUtilsKt.getConeType(property2.getReturnTypeRef()), context2, (EffectiveVisibility)propertyVisibility, false, null, 12, null);
            if (symbolWithRelation3 == null) break block7;
            object = symbolWithRelation3;
            boolean bl3 = false;
            FirClassLikeSymbol<?> restricting = ((SymbolWithRelation)object).component1();
            EffectiveVisibility restrictingVisibility = ((SymbolWithRelation)object).component2();
            RelationToType relation = ((SymbolWithRelation)object).component3();
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)$this$checkExposure.getSource(), FirErrors.INSTANCE.getEXPOSED_PROPERTY_TYPE_IN_CONSTRUCTOR(), propertyVisibility, restricting, (Object)relation, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 128, null);
        }
    }

    private final void checkMemberReceiver(FirTypeRef typeRef, FirCallableDeclaration memberDeclaration, DiagnosticReporter reporter, CheckerContext context2) {
        Object memberVisibility;
        if (typeRef == null || memberDeclaration == null) {
            return;
        }
        ConeKotlinType receiverParameterType = FirTypeUtilsKt.getConeType(typeRef);
        FirMemberDeclaration $this$effectiveVisibility$iv = memberDeclaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)(memberVisibility = object), (Object)EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        SymbolWithRelation symbolWithRelation = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, receiverParameterType, context2, (EffectiveVisibility)memberVisibility, false, null, 12, null);
        if (symbolWithRelation == null) {
            return;
        }
        SymbolWithRelation symbolWithRelation2 = symbolWithRelation;
        FirClassLikeSymbol<?> restricting = symbolWithRelation2.component1();
        EffectiveVisibility restrictingVisibility = symbolWithRelation2.component2();
        RelationToType relation = symbolWithRelation2.component3();
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)typeRef.getSource(), FirErrors.INSTANCE.getEXPOSED_RECEIVER_TYPE(), memberVisibility, restricting, (Object)relation, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 128, null);
    }

    private final SymbolWithRelation findVisibilityExposure(ConeKotlinType $this$findVisibilityExposure, CheckerContext context2, EffectiveVisibility base, boolean ignoreInternalExposure, Set<ConeKotlinType> visitedTypes) {
        EffectiveVisibility effectiveVisibility;
        EffectiveVisibility effectiveVisibility2;
        boolean $i$f$getEffectiveVisibility;
        FirClassLikeSymbol<?> $this$effectiveVisibility$iv;
        Object object;
        ConeClassLikeType coneClassLikeType;
        if (!visitedTypes.add($this$findVisibilityExposure)) {
            return null;
        }
        ConeKotlinType coneKotlinType = $this$findVisibilityExposure;
        if (coneKotlinType instanceof ConeClassLikeType) {
            coneClassLikeType = (ConeClassLikeType)$this$findVisibilityExposure;
        } else if (coneKotlinType instanceof ConeFlexibleType) {
            object = ((ConeFlexibleType)$this$findVisibilityExposure).getLowerBound();
            coneClassLikeType = object instanceof ConeClassLikeType ? (ConeClassLikeType)object : null;
            if (coneClassLikeType == null) {
                return null;
            }
        } else {
            return null;
        }
        ConeClassLikeType type2 = coneClassLikeType;
        FirClassLikeSymbol<?> firClassLikeSymbol = ToSymbolUtilsKt.toSymbol(TypeExpansionUtilsKt.fullyExpandedType$default(type2, context2.getSession(), null, 2, null).getLookupTag(), context2.getSession());
        if (firClassLikeSymbol == null) {
            return null;
        }
        FirClassLikeSymbol<?> classSymbol = firClassLikeSymbol;
        object = classSymbol;
        if (object instanceof FirRegularClassSymbol) {
            $this$effectiveVisibility$iv = classSymbol;
            $i$f$getEffectiveVisibility = false;
            effectiveVisibility2 = $this$effectiveVisibility$iv.getResolvedStatus().getEffectiveVisibility();
        } else if (object instanceof FirTypeAliasSymbol) {
            $this$effectiveVisibility$iv = classSymbol;
            $i$f$getEffectiveVisibility = false;
            effectiveVisibility2 = $this$effectiveVisibility$iv.getResolvedStatus().getEffectiveVisibility();
        } else {
            effectiveVisibility2 = effectiveVisibility = null;
        }
        if (ignoreInternalExposure && Intrinsics.areEqual((Object)effectiveVisibility, (Object)EffectiveVisibility.Internal.INSTANCE)) {
            return null;
        }
        if (effectiveVisibility != null) {
            switch (WhenMappings.$EnumSwitchMapping$0[effectiveVisibility.relation(base, TypeComponentsKt.getTypeContext(context2.getSession())).ordinal()]) {
                case 1: 
                case 2: {
                    return this.symbolWithRelation(classSymbol, effectiveVisibility, visitedTypes.size() > 1);
                }
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        object = type2.getTypeArguments();
        int n2 = ((ConeTypeProjection[])object).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object it;
            Object object2;
            int index2 = i2;
            ConeTypeProjection it2 = object[i2];
            ConeTypeProjection coneTypeProjection = it2;
            if (coneTypeProjection instanceof ConeClassLikeType) {
                object2 = this.findVisibilityExposure((ConeKotlinType)it2, context2, base, ignoreInternalExposure, visitedTypes);
                if (object2 == null) continue;
                it = object2;
                boolean bl2 = false;
                return it;
            }
            if (coneTypeProjection instanceof ConeKotlinTypeProjection) {
                object2 = this.findVisibilityExposure(((ConeKotlinTypeProjection)it2).getType(), context2, base, ignoreInternalExposure, visitedTypes);
                if (object2 == null) continue;
                it = object2;
                boolean bl3 = false;
                return it;
            }
            if (coneTypeProjection instanceof ConeStarProjection) {
                Object object3;
                block22: {
                    Object object4;
                    List<FirResolvedTypeRef> list;
                    FirTypeParameterSymbol firTypeParameterSymbol;
                    List<FirTypeParameterSymbol> list2;
                    object2 = ToSymbolUtilsKt.toRegularClassSymbol(type2, context2.getSession());
                    if (object2 == null || (list2 = ((FirClassLikeSymbol)object2).getTypeParameterSymbols()) == null || (firTypeParameterSymbol = (FirTypeParameterSymbol)CollectionsKt.getOrNull(list2, (int)index2)) == null || (list = firTypeParameterSymbol.getResolvedBounds()) == null) continue;
                    for (Object it3 : (Iterable)list) {
                        boolean bl4 = false;
                        if ((it3 = INSTANCE.findVisibilityExposure(((FirResolvedTypeRef)it3).getConeType(), context2, base, ignoreInternalExposure, visitedTypes)) == null) continue;
                        object4 = it3;
                        break block22;
                    }
                    object4 = object3 = null;
                }
                if (object3 == null) continue;
                Object it4 = object3;
                boolean bl5 = false;
                return it4;
            }
            throw new NoWhenBranchMatchedException();
        }
        return null;
    }

    static /* synthetic */ SymbolWithRelation findVisibilityExposure$default(FirExposedVisibilityDeclarationChecker firExposedVisibilityDeclarationChecker, ConeKotlinType coneKotlinType, CheckerContext checkerContext, EffectiveVisibility effectiveVisibility, boolean bl2, Set set, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl2 = false;
        }
        if ((n2 & 8) != 0) {
            set = new LinkedHashSet();
        }
        return firExposedVisibilityDeclarationChecker.findVisibilityExposure(coneKotlinType, checkerContext, effectiveVisibility, bl2, set);
    }

    private final SymbolWithRelation symbolWithRelation(FirClassLikeSymbol<?> symbol, EffectiveVisibility effectiveVisibility, boolean fromTypeArgument) {
        Visibility visibility = effectiveVisibility.toVisibility();
        FirClassLikeSymbol<?> $this$visibility$iv = symbol;
        boolean $i$f$getVisibility = false;
        Visibility lowestVisibility = $this$visibility$iv.getResolvedStatus().getVisibility();
        FirClassLikeSymbol<?> lowestRepresentative = symbol;
        FirClassLikeSymbol<?> currentSymbol = FirHelpersKt.getContainingClassSymbol((FirBasedSymbol)symbol);
        while (currentSymbol != null && !Intrinsics.areEqual((Object)lowestVisibility, (Object)visibility)) {
            Visibility visibility2;
            FirClassLikeSymbol<?> $this$visibility$iv2 = currentSymbol;
            boolean $i$f$getVisibility2 = false;
            Integer compareResult = $this$visibility$iv2.getResolvedStatus().getVisibility().compareTo(lowestVisibility);
            if (compareResult != null && compareResult < 0) {
                lowestRepresentative = currentSymbol;
                $this$visibility$iv2 = currentSymbol;
                $i$f$getVisibility2 = false;
                visibility2 = $this$visibility$iv2.getResolvedStatus().getVisibility();
            } else {
                visibility2 = lowestVisibility;
            }
            lowestVisibility = visibility2;
            currentSymbol = FirHelpersKt.getContainingClassSymbol((FirBasedSymbol)currentSymbol);
        }
        RelationToType defaultRelation = fromTypeArgument ? RelationToType.ARGUMENT : RelationToType.CONSTRUCTOR;
        return new SymbolWithRelation(lowestRepresentative, effectiveVisibility, lowestRepresentative != symbol ? defaultRelation.containerRelation() : defaultRelation);
    }

    private static final KtDiagnosticFactory4<EffectiveVisibility, FirClassLikeSymbol<?>, RelationToType, EffectiveVisibility> checkParameterBounds$getDiagnosticByFeature(CheckerContext $context, FirTypeParameterRefsOwner $declaration, LanguageFeature feature) {
        boolean reportProperError = $context.getLanguageVersionSettings().supportsFeature(feature);
        return reportProperError || $declaration instanceof FirRegularClass ? FirErrors.INSTANCE.getEXPOSED_TYPE_PARAMETER_BOUND() : FirErrors.INSTANCE.getEXPOSED_TYPE_PARAMETER_BOUND_DEPRECATION_WARNING();
    }

    private static final SymbolWithRelation checkParameterBounds$findVisibilityExposure(FirResolvedTypeRef $this$checkParameterBounds_u24findVisibilityExposure, CheckerContext $context, EffectiveVisibility $visibility, boolean ignoreInternalExposure) {
        return FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(INSTANCE, $this$checkParameterBounds_u24findVisibilityExposure.getConeType(), $context, $visibility, ignoreInternalExposure, null, 8, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J+\u0010\u0013\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExposedVisibilityDeclarationChecker$SymbolWithRelation;", "", "symbol", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "visibility", "Lksp/org/jetbrains/kotlin/descriptors/EffectiveVisibility;", "relation", "Lksp/org/jetbrains/kotlin/descriptors/RelationToType;", "<init>", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;Lorg/jetbrains/kotlin/descriptors/RelationToType;)V", "getSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "getVisibility", "()Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "getRelation", "()Lorg/jetbrains/kotlin/descriptors/RelationToType;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "checkers"})
    private static final class SymbolWithRelation {
        @NotNull
        private final FirClassLikeSymbol<?> symbol;
        @NotNull
        private final EffectiveVisibility visibility;
        @NotNull
        private final RelationToType relation;

        public SymbolWithRelation(@NotNull FirClassLikeSymbol<?> symbol, @NotNull EffectiveVisibility visibility, @NotNull RelationToType relation) {
            Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
            Intrinsics.checkNotNullParameter((Object)visibility, (String)"visibility");
            Intrinsics.checkNotNullParameter((Object)((Object)relation), (String)"relation");
            this.symbol = symbol;
            this.visibility = visibility;
            this.relation = relation;
        }

        @NotNull
        public final FirClassLikeSymbol<?> getSymbol() {
            return this.symbol;
        }

        @NotNull
        public final EffectiveVisibility getVisibility() {
            return this.visibility;
        }

        @NotNull
        public final RelationToType getRelation() {
            return this.relation;
        }

        @NotNull
        public final FirClassLikeSymbol<?> component1() {
            return this.symbol;
        }

        @NotNull
        public final EffectiveVisibility component2() {
            return this.visibility;
        }

        @NotNull
        public final RelationToType component3() {
            return this.relation;
        }

        @NotNull
        public final SymbolWithRelation copy(@NotNull FirClassLikeSymbol<?> symbol, @NotNull EffectiveVisibility visibility, @NotNull RelationToType relation) {
            Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
            Intrinsics.checkNotNullParameter((Object)visibility, (String)"visibility");
            Intrinsics.checkNotNullParameter((Object)((Object)relation), (String)"relation");
            return new SymbolWithRelation(symbol, visibility, relation);
        }

        public static /* synthetic */ SymbolWithRelation copy$default(SymbolWithRelation symbolWithRelation, FirClassLikeSymbol firClassLikeSymbol, EffectiveVisibility effectiveVisibility, RelationToType relationToType, int n2, Object object) {
            if ((n2 & 1) != 0) {
                firClassLikeSymbol = symbolWithRelation.symbol;
            }
            if ((n2 & 2) != 0) {
                effectiveVisibility = symbolWithRelation.visibility;
            }
            if ((n2 & 4) != 0) {
                relationToType = symbolWithRelation.relation;
            }
            return symbolWithRelation.copy(firClassLikeSymbol, effectiveVisibility, relationToType);
        }

        @NotNull
        public String toString() {
            return "SymbolWithRelation(symbol=" + this.symbol + ", visibility=" + this.visibility + ", relation=" + (Object)((Object)this.relation) + ')';
        }

        public int hashCode() {
            int result2 = this.symbol.hashCode();
            result2 = result2 * 31 + this.visibility.hashCode();
            result2 = result2 * 31 + this.relation.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SymbolWithRelation)) {
                return false;
            }
            SymbolWithRelation symbolWithRelation = (SymbolWithRelation)other;
            if (!Intrinsics.areEqual(this.symbol, symbolWithRelation.symbol)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.visibility, (Object)symbolWithRelation.visibility)) {
                return false;
            }
            return this.relation == symbolWithRelation.relation;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EffectiveVisibility.Permissiveness.values().length];
            try {
                nArray[EffectiveVisibility.Permissiveness.LESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffectiveVisibility.Permissiveness.UNKNOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffectiveVisibility.Permissiveness.SAME.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffectiveVisibility.Permissiveness.MORE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

