/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirUnderscoreHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirOuterClassTypeParameterRef;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import ksp.org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import ksp.org.jetbrains.kotlin.fir.types.ConeDynamicType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import ksp.org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypesKt;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J,\u0010\r\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J,\u0010\u0012\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0013"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnyTypeAliasChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeAliasChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkTypeAliasExpansionCapturesOuterTypeParameters", "fullyExpandedType", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "expandedTypeRef", "Lksp/org/jetbrains/kotlin/fir/types/FirTypeRef;", "checkTypealiasShouldExpandToClass", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirAnyTypeAliasChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirAnyTypeAliasChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnyTypeAliasChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,136:1\n61#2:137\n35#2:138\n61#2:139\n808#3,11:140\n1#4:151\n12637#5,2:152\n*S KotlinDebug\n*F\n+ 1 FirAnyTypeAliasChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnyTypeAliasChecker\n*L\n34#1:137\n68#1:138\n68#1:139\n79#1:140,11\n83#1:152,2\n*E\n"})
public final class FirAnyTypeAliasChecker
extends FirDeclarationChecker<FirTypeAlias> {
    @NotNull
    public static final FirAnyTypeAliasChecker INSTANCE = new FirAnyTypeAliasChecker();

    private FirAnyTypeAliasChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirTypeAlias declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!FirHelpersKt.isTopLevel(context2)) {
            FirClassLikeDeclaration $this$isLocal$iv = declaration2;
            boolean $i$f$isLocal = false;
            if ($this$isLocal$iv.getSymbol().getClassId().isLocal()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"Local type aliases are unsupported.", (DiagnosticContext)context2, null, 16, null);
            } else {
                FirHelpersKt.requireFeatureSupport$default(declaration2, LanguageFeature.NestedTypeAliases, context2, reporter, null, 8, null);
            }
        }
        FirTypeRef expandedTypeRef = declaration2.getExpandedTypeRef();
        ConeKotlinType fullyExpandedType2 = TypeExpansionUtilsKt.fullyExpandedType$default(FirTypeUtilsKt.getConeType(expandedTypeRef), context2.getSession(), null, 2, null);
        this.checkTypeAliasExpansionCapturesOuterTypeParameters(declaration2, fullyExpandedType2, expandedTypeRef, context2, reporter);
        this.checkTypealiasShouldExpandToClass(declaration2, fullyExpandedType2, expandedTypeRef, context2, reporter);
        FirUnderscoreHelpersKt.checkTypeRefForUnderscore(expandedTypeRef, context2, reporter);
        boolean allowNullableNothing = context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.NullableNothingInReifiedPosition);
        if (FirHelpersKt.isMalformedExpandedType(fullyExpandedType2, context2, allowNullableNothing)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getExpandedTypeRef().getSource(), FirErrors.INSTANCE.getTYPEALIAS_EXPANDS_TO_ARRAY_OF_NOTHINGS(), (Object)fullyExpandedType2, (DiagnosticContext)context2, null, 16, null);
        }
    }

    private final void checkTypeAliasExpansionCapturesOuterTypeParameters(FirTypeAlias $this$checkTypeAliasExpansionCapturesOuterTypeParameters, ConeKotlinType fullyExpandedType2, FirTypeRef expandedTypeRef, CheckerContext context2, DiagnosticReporter reporter) {
        block5: {
            block4: {
                if (FirHelpersKt.isTopLevel(context2)) break block4;
                FirMemberDeclaration $this$isInner$iv = $this$checkTypeAliasExpansionCapturesOuterTypeParameters;
                boolean $i$f$isInner = false;
                if ($this$isInner$iv.getStatus().isInner()) break block4;
                FirClassLikeDeclaration $this$isLocal$iv = $this$checkTypeAliasExpansionCapturesOuterTypeParameters;
                boolean $i$f$isLocal = false;
                if (!$this$isLocal$iv.getSymbol().getClassId().isLocal()) break block5;
            }
            return;
        }
        Set unsubstitutedOuterTypeParameters = new LinkedHashSet();
        FirAnyTypeAliasChecker.checkTypeAliasExpansionCapturesOuterTypeParameters$checkRecursively(fullyExpandedType2, context2, unsubstitutedOuterTypeParameters);
        if (!((Collection)unsubstitutedOuterTypeParameters).isEmpty()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expandedTypeRef.getSource(), FirErrors.INSTANCE.getTYPEALIAS_EXPANSION_CAPTURES_OUTER_TYPE_PARAMETERS(), (Object)unsubstitutedOuterTypeParameters, (DiagnosticContext)context2, null, 16, null);
        }
    }

    private final void checkTypealiasShouldExpandToClass(FirTypeAlias $this$checkTypealiasShouldExpandToClass, ConeKotlinType fullyExpandedType2, FirTypeRef expandedTypeRef, CheckerContext context2, DiagnosticReporter reporter) {
        if (FirAnyTypeAliasChecker.checkTypealiasShouldExpandToClass$containsTypeParameter(context2, fullyExpandedType2) || fullyExpandedType2 instanceof ConeDynamicType) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)$this$checkTypealiasShouldExpandToClass.getExpandedTypeRef().getSource(), FirErrors.INSTANCE.getTYPEALIAS_SHOULD_EXPAND_TO_CLASS(), (Object)FirTypeUtilsKt.getConeType(expandedTypeRef), (DiagnosticContext)context2, null, 16, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void checkTypeAliasExpansionCapturesOuterTypeParameters$checkRecursively(ConeKotlinType $this$checkTypeAliasExpansionCapturesOuterTypeParameters_u24checkRecursively, CheckerContext $context, Set<FirTypeParameterSymbol> unsubstitutedOuterTypeParameters) {
        void $this$filterIsInstanceTo$iv$iv;
        for (ConeTypeProjection typeArgument : $this$checkTypeAliasExpansionCapturesOuterTypeParameters_u24checkRecursively.getTypeArguments()) {
            ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType(typeArgument);
            if (coneKotlinType == null || (coneKotlinType = TypeExpansionUtilsKt.fullyExpandedType$default(coneKotlinType, $context.getSession(), null, 2, null)) == null) continue;
            FirAnyTypeAliasChecker.checkTypeAliasExpansionCapturesOuterTypeParameters$checkRecursively(coneKotlinType, $context, unsubstitutedOuterTypeParameters);
        }
        FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol($this$checkTypeAliasExpansionCapturesOuterTypeParameters_u24checkRecursively, $context.getSession());
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol regularClassSymbol = firRegularClassSymbol;
        Iterable $this$filterIsInstance$iv = ((FirRegularClass)regularClassSymbol.getFir()).getTypeParameters();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirOuterClassTypeParameterRef)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable it = $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean bl2 = false;
        Iterable iterable2 = !((Collection)it).isEmpty() ? $this$filterIsInstance$iv : null;
        if (iterable2 == null) {
            return;
        }
        Iterable outerTypeParameterRefs = iterable2;
        for (FirOuterClassTypeParameterRef outerTypeParameterRef : outerTypeParameterRefs) {
            boolean bl3;
            block6: {
                ConeTypeProjection[] $this$any$iv = $this$checkTypeAliasExpansionCapturesOuterTypeParameters_u24checkRecursively.getTypeArguments();
                boolean $i$f$any = false;
                int n2 = $this$any$iv.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    ConeTypeProjection element$iv;
                    ConeTypeProjection it2 = element$iv = $this$any$iv[i2];
                    boolean bl4 = false;
                    ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType(it2);
                    if (!Intrinsics.areEqual((Object)(coneKotlinType != null ? ToSymbolUtilsKt.toTypeParameterSymbol(coneKotlinType, $context.getSession()) : null), (Object)outerTypeParameterRef.getSymbol())) continue;
                    bl3 = true;
                    break block6;
                }
                bl3 = false;
            }
            if (!bl3) continue;
            unsubstitutedOuterTypeParameters.add(outerTypeParameterRef.getSymbol());
        }
    }

    private static final boolean checkTypealiasShouldExpandToClass$containsTypeParameter(CheckerContext $context, ConeKotlinType type2) {
        ConeSimpleKotlinType unwrapped = ConeTypesKt.unwrapToSimpleTypeUsingLowerBound(type2);
        if (unwrapped instanceof ConeTypeParameterType) {
            return true;
        }
        if (unwrapped instanceof ConeClassLikeType && ToSymbolUtilsKt.toSymbol(((ConeClassLikeType)unwrapped).getLookupTag(), $context.getSession()) instanceof FirTypeAliasSymbol) {
            for (ConeTypeProjection typeArgument : unwrapped.getTypeArguments()) {
                ConeKotlinType typeArgumentType;
                ConeKotlinType coneKotlinType = typeArgument instanceof ConeKotlinType ? (ConeKotlinType)typeArgument : null;
                if (coneKotlinType == null) {
                    ConeKotlinTypeProjection coneKotlinTypeProjection = typeArgument instanceof ConeKotlinTypeProjection ? (ConeKotlinTypeProjection)typeArgument : null;
                    coneKotlinType = coneKotlinTypeProjection != null ? coneKotlinTypeProjection.getType() : null;
                }
                if ((typeArgumentType = coneKotlinType) == null || !FirAnyTypeAliasChecker.checkTypealiasShouldExpandToClass$containsTypeParameter($context, typeArgumentType)) continue;
                return true;
            }
        }
        return false;
    }
}

