/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.common.serialization;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializer;
import ksp.org.jetbrains.kotlin.backend.common.serialization.encodings.BinarySymbolData;
import ksp.org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrEnumEntrySymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrTypeAliasSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import ksp.org.jetbrains.kotlin.ir.util.IdSignature;
import ksp.org.jetbrains.kotlin.library.KotlinLibrary;
import ksp.org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u001a\u0010\u0003\u001a\u00020\u0002*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001\u001a&\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\r0\f\u00a8\u0006\u000e"}, d2={"kind", "Lksp/org/jetbrains/kotlin/backend/common/serialization/encodings/BinarySymbolData$SymbolKind;", "Lksp/org/jetbrains/kotlin/ir/symbols/IrSymbol;", "deserializeIrSymbolOrFail", "Lksp/org/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;", "idSig", "Lksp/org/jetbrains/kotlin/ir/util/IdSignature;", "symbolKind", "sortDependencies", "", "Lksp/org/jetbrains/kotlin/library/KotlinLibrary;", "moduleDependencies", "", "", "ir.serialization.common"})
public final class IrModuleDeserializerKt {
    @NotNull
    public static final BinarySymbolData.SymbolKind kind(@NotNull IrSymbol $this$kind) {
        BinarySymbolData.SymbolKind symbolKind;
        Intrinsics.checkNotNullParameter((Object)$this$kind, (String)"<this>");
        IrSymbol irSymbol = $this$kind;
        if (irSymbol instanceof IrClassSymbol) {
            symbolKind = BinarySymbolData.SymbolKind.CLASS_SYMBOL;
        } else if (irSymbol instanceof IrConstructorSymbol) {
            symbolKind = BinarySymbolData.SymbolKind.CONSTRUCTOR_SYMBOL;
        } else if (irSymbol instanceof IrSimpleFunctionSymbol) {
            symbolKind = BinarySymbolData.SymbolKind.FUNCTION_SYMBOL;
        } else if (irSymbol instanceof IrPropertySymbol) {
            symbolKind = BinarySymbolData.SymbolKind.PROPERTY_SYMBOL;
        } else if (irSymbol instanceof IrFieldSymbol) {
            symbolKind = BinarySymbolData.SymbolKind.FIELD_SYMBOL;
        } else if (irSymbol instanceof IrEnumEntrySymbol) {
            symbolKind = BinarySymbolData.SymbolKind.ENUM_ENTRY_SYMBOL;
        } else if (irSymbol instanceof IrTypeAliasSymbol) {
            symbolKind = BinarySymbolData.SymbolKind.TYPEALIAS_SYMBOL;
        } else if (irSymbol instanceof IrTypeParameterSymbol) {
            symbolKind = BinarySymbolData.SymbolKind.TYPE_PARAMETER_SYMBOL;
        } else {
            throw new IllegalStateException(("Unexpected symbol kind " + $this$kind).toString());
        }
        return symbolKind;
    }

    @NotNull
    public static final IrSymbol deserializeIrSymbolOrFail(@NotNull IrModuleDeserializer $this$deserializeIrSymbolOrFail, @NotNull IdSignature idSig, @NotNull BinarySymbolData.SymbolKind symbolKind) {
        Intrinsics.checkNotNullParameter((Object)$this$deserializeIrSymbolOrFail, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)idSig, (String)"idSig");
        Intrinsics.checkNotNullParameter((Object)((Object)symbolKind), (String)"symbolKind");
        IrSymbol irSymbol = $this$deserializeIrSymbolOrFail.tryDeserializeIrSymbol(idSig, symbolKind);
        if (irSymbol == null) {
            $this$deserializeIrSymbolOrFail.deserializedSymbolNotFound(idSig);
            throw new KotlinNothingValueException();
        }
        return irSymbol;
    }

    @NotNull
    public static final Collection<KotlinLibrary> sortDependencies(@NotNull Map<KotlinLibrary, ? extends List<? extends KotlinLibrary>> moduleDependencies2) {
        Intrinsics.checkNotNullParameter(moduleDependencies2, (String)"moduleDependencies");
        List<KotlinLibrary> list = DFS.topologicalOrder((Iterable)moduleDependencies2.keySet(), arg_0 -> IrModuleDeserializerKt.sortDependencies$lambda$0(moduleDependencies2, arg_0));
        Intrinsics.checkNotNullExpressionValue(list, (String)"topologicalOrder(...)");
        return CollectionsKt.reversed((Iterable)list);
    }

    private static final Iterable sortDependencies$lambda$0(Map $moduleDependencies, KotlinLibrary m4) {
        return (Iterable)MapsKt.getValue((Map)$moduleDependencies, (Object)m4);
    }
}

