/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.common.serialization;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.backend.common.diagnostics.IdSignatureClashDetector;
import ksp.org.jetbrains.kotlin.backend.common.serialization.DeclarationTableKt;
import ksp.org.jetbrains.kotlin.backend.common.serialization.signature.PublicIdSignatureComputer;
import ksp.org.jetbrains.kotlin.ir.IrBuiltIns;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import ksp.org.jetbrains.kotlin.ir.symbols.IrSymbol;
import ksp.org.jetbrains.kotlin.ir.util.IdSignature;
import ksp.org.jetbrains.kotlin.ir.util.KotlinMangler;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0004J\u001e\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006 "}, d2={"Lksp/org/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable;", "", "mangler", "Lksp/org/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "reuseExistingSignaturesForSymbols", "", "<init>", "(Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;Z)V", "getMangler", "()Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "publicIdSignatureComputer", "Lksp/org/jetbrains/kotlin/backend/common/serialization/signature/PublicIdSignatureComputer;", "getPublicIdSignatureComputer", "()Lorg/jetbrains/kotlin/backend/common/serialization/signature/PublicIdSignatureComputer;", "clashDetector", "Lksp/org/jetbrains/kotlin/backend/common/diagnostics/IdSignatureClashDetector;", "getClashDetector$ir_serialization_common", "()Lorg/jetbrains/kotlin/backend/common/diagnostics/IdSignatureClashDetector;", "table", "", "Lksp/org/jetbrains/kotlin/ir/declarations/IrDeclaration;", "Lksp/org/jetbrains/kotlin/ir/util/IdSignature;", "getTable", "()Ljava/util/Map;", "loadKnownBuiltins", "", "builtIns", "Lksp/org/jetbrains/kotlin/ir/IrBuiltIns;", "computeSignatureByDeclaration", "declaration", "compatibleMode", "recordInSignatureClashDetector", "ir.serialization.common"})
@SourceDebugExtension(value={"SMAP\nDeclarationTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclarationTable.kt\norg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,91:1\n1869#2,2:92\n384#3,3:94\n387#3,4:98\n231#4:97\n*S KotlinDebug\n*F\n+ 1 DeclarationTable.kt\norg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable\n*L\n28#1:92,2\n45#1:94,3\n45#1:98,4\n46#1:97\n*E\n"})
public abstract class GlobalDeclarationTable {
    @NotNull
    private final KotlinMangler.IrMangler mangler;
    private final boolean reuseExistingSignaturesForSymbols;
    @NotNull
    private final PublicIdSignatureComputer publicIdSignatureComputer;
    @NotNull
    private final IdSignatureClashDetector clashDetector;
    @NotNull
    private final Map<IrDeclaration, IdSignature> table;

    public GlobalDeclarationTable(@NotNull KotlinMangler.IrMangler mangler, boolean reuseExistingSignaturesForSymbols) {
        Intrinsics.checkNotNullParameter((Object)mangler, (String)"mangler");
        this.mangler = mangler;
        this.reuseExistingSignaturesForSymbols = reuseExistingSignaturesForSymbols;
        this.publicIdSignatureComputer = new PublicIdSignatureComputer(this.mangler);
        this.clashDetector = new IdSignatureClashDetector();
        this.table = new Object2ObjectOpenHashMap();
    }

    @NotNull
    public final KotlinMangler.IrMangler getMangler() {
        return this.mangler;
    }

    @NotNull
    public final PublicIdSignatureComputer getPublicIdSignatureComputer() {
        return this.publicIdSignatureComputer;
    }

    @NotNull
    public final IdSignatureClashDetector getClashDetector$ir_serialization_common() {
        return this.clashDetector;
    }

    @NotNull
    protected final Map<IrDeclaration, IdSignature> getTable() {
        return this.table;
    }

    protected final void loadKnownBuiltins(@NotNull IrBuiltIns builtIns2) {
        Intrinsics.checkNotNullParameter((Object)builtIns2, (String)"builtIns");
        Iterable $this$forEach$iv = DeclarationTableKt.getKnownBuiltins(builtIns2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrDeclaration it = (IrDeclaration)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSymbolOwner");
            IrSymbol symbol = ((IrSymbolOwner)it).getSymbol();
            IdSignature signature = symbol.getSignature();
            if (signature == null) {
                this.computeSignatureByDeclaration(it, false, true);
                continue;
            }
            this.table.put(it, signature);
            this.clashDetector.trackDeclaration(it, signature);
        }
    }

    @NotNull
    public final IdSignature computeSignatureByDeclaration(@NotNull IrDeclaration declaration2, boolean compatibleMode, boolean recordInSignatureClashDetector) {
        IdSignature idSignature;
        IdSignature idSignature2;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Map<IrDeclaration, IdSignature> $this$getOrPut$iv = this.table;
        boolean $i$f$getOrPut = false;
        IdSignature value$iv = $this$getOrPut$iv.get(declaration2);
        if (value$iv == null) {
            IdSignature idSignature3;
            IdSignature idSignature4;
            boolean bl2 = false;
            boolean condition$iv = this.reuseExistingSignaturesForSymbols;
            boolean $i$f$runIf = false;
            if (condition$iv) {
                boolean bl3 = false;
                idSignature4 = declaration2.getSymbol().getSignature();
            } else {
                idSignature4 = idSignature3 = null;
            }
            if (idSignature4 == null) {
                idSignature3 = this.publicIdSignatureComputer.computePublicIdSignature(declaration2, compatibleMode);
            }
            IdSignature answer$iv = idSignature3;
            $this$getOrPut$iv.put(declaration2, answer$iv);
            idSignature2 = answer$iv;
        } else {
            idSignature2 = value$iv;
        }
        IdSignature it = idSignature = idSignature2;
        boolean bl4 = false;
        if (recordInSignatureClashDetector && it.isPubliclyVisible() && !it.isLocal()) {
            this.clashDetector.trackDeclaration(declaration2, it);
        }
        return idSignature;
    }
}

