/*
 * Decompiled with CFR 0.152.
 */
package ksp.io.opentelemetry.api.trace;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import ksp.io.opentelemetry.api.common.AttributeKey;
import ksp.io.opentelemetry.api.common.Attributes;
import ksp.io.opentelemetry.api.internal.ApiUsageLogger;
import ksp.io.opentelemetry.api.trace.PropagatedSpan;
import ksp.io.opentelemetry.api.trace.SpanContext;
import ksp.io.opentelemetry.api.trace.SpanContextKey;
import ksp.io.opentelemetry.api.trace.StatusCode;
import ksp.javax.annotation.Nullable;
import ksp.javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public interface Span
extends ImplicitContextKeyed {
    public static Span current() {
        Span span = (Span)Context.current().get(SpanContextKey.KEY);
        return span == null ? Span.getInvalid() : span;
    }

    public static Span fromContext(Context context2) {
        if (context2 == null) {
            ApiUsageLogger.log("context is null");
            return Span.getInvalid();
        }
        Span span = (Span)context2.get(SpanContextKey.KEY);
        return span == null ? Span.getInvalid() : span;
    }

    @Nullable
    public static Span fromContextOrNull(Context context2) {
        if (context2 == null) {
            ApiUsageLogger.log("context is null");
            return null;
        }
        return (Span)context2.get(SpanContextKey.KEY);
    }

    public static Span getInvalid() {
        return PropagatedSpan.INVALID;
    }

    public static Span wrap(SpanContext spanContext) {
        if (spanContext == null) {
            ApiUsageLogger.log("context is null");
            return Span.getInvalid();
        }
        return PropagatedSpan.create(spanContext);
    }

    default public Span setAttribute(String key, String value2) {
        return this.setAttribute(AttributeKey.stringKey(key), value2);
    }

    default public Span setAttribute(String key, long value2) {
        return this.setAttribute(AttributeKey.longKey(key), Long.valueOf(value2));
    }

    default public Span setAttribute(String key, double value2) {
        return this.setAttribute(AttributeKey.doubleKey(key), Double.valueOf(value2));
    }

    default public Span setAttribute(String key, boolean value2) {
        return this.setAttribute(AttributeKey.booleanKey(key), Boolean.valueOf(value2));
    }

    public <T> Span setAttribute(AttributeKey<T> var1, T var2);

    default public Span setAttribute(AttributeKey<Long> key, int value2) {
        return this.setAttribute(key, Long.valueOf(value2));
    }

    default public Span setAllAttributes(Attributes attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return this;
        }
        attributes.forEach((attributeKey, value2) -> this.setAttribute((AttributeKey)attributeKey, (Object)value2));
        return this;
    }

    default public Span addEvent(String name2) {
        return this.addEvent(name2, Attributes.empty());
    }

    default public Span addEvent(String name2, long timestamp, TimeUnit unit) {
        return this.addEvent(name2, Attributes.empty(), timestamp, unit);
    }

    default public Span addEvent(String name2, Instant timestamp) {
        if (timestamp == null) {
            return this.addEvent(name2);
        }
        return this.addEvent(name2, TimeUnit.SECONDS.toNanos(timestamp.getEpochSecond()) + (long)timestamp.getNano(), TimeUnit.NANOSECONDS);
    }

    public Span addEvent(String var1, Attributes var2);

    public Span addEvent(String var1, Attributes var2, long var3, TimeUnit var5);

    default public Span addEvent(String name2, Attributes attributes, Instant timestamp) {
        if (timestamp == null) {
            return this.addEvent(name2, attributes);
        }
        return this.addEvent(name2, attributes, TimeUnit.SECONDS.toNanos(timestamp.getEpochSecond()) + (long)timestamp.getNano(), TimeUnit.NANOSECONDS);
    }

    default public Span setStatus(StatusCode statusCode) {
        return this.setStatus(statusCode, "");
    }

    public Span setStatus(StatusCode var1, String var2);

    default public Span recordException(Throwable exception) {
        return this.recordException(exception, Attributes.empty());
    }

    public Span recordException(Throwable var1, Attributes var2);

    public Span updateName(String var1);

    public void end();

    public void end(long var1, TimeUnit var3);

    default public void end(Instant timestamp) {
        if (timestamp == null) {
            this.end();
            return;
        }
        this.end(TimeUnit.SECONDS.toNanos(timestamp.getEpochSecond()) + (long)timestamp.getNano(), TimeUnit.NANOSECONDS);
    }

    public SpanContext getSpanContext();

    public boolean isRecording();

    default public Context storeInContext(Context context2) {
        return context2.with(SpanContextKey.KEY, (Object)this);
    }
}

