/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij;

import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import ksp.com.intellij.BundleBaseKt;
import ksp.com.intellij.openapi.util.SystemInfoRt;
import ksp.com.intellij.util.text.OrdinalFormat;
import ksp.org.jetbrains.annotations.Contract;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\r\u001a\u00070\u0004\u00a2\u0006\u0002\b\b2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0007J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nJ)\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0016\"\u00020\u0001H\u0007\u00a2\u0006\u0002\u0010\u0017J\u0018\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0004H\u0007J6\u0010\u001c\u001a\u00070\u0004\u00a2\u0006\u0002\b\u001d2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00042\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0016\"\u00020\u0001H\u0007\u00a2\u0006\u0002\u0010\u001eJK\u0010\u001f\u001a\u00070\u0004\u00a2\u0006\u0002\b\u001d2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u00042\r\u0010 \u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u001d2\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0016\"\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010!J8\u0010\"\u001a\u00070\u0004\u00a2\u0006\u0002\b\u001d2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u0016H\u0007\u00a2\u0006\u0002\u0010%J?\u0010&\u001a\u00070\u0004\u00a2\u0006\u0002\b\u001d2\u0006\u0010\u0019\u001a\u00020\u001a2\u000b\u0010\u0014\u001a\u00070\u0004\u00a2\u0006\u0002\b\u001d2\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0016\"\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010\u001eJ\u001e\u0010'\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u001d2\r\u0010\u0014\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u001dH\u0007J\u001e\u0010(\u001a\u00020\u00112\u0014\u0010)\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010*H\u0007J.\u0010+\u001a\u00070\u0004\u00a2\u0006\u0002\b\u001d2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u00042\r\u0010 \u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u001dH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\u0004\u00a2\u0006\u0002\b\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lksp/com/intellij/BundleBase;", "", "()V", "L10N_MARKER", "", "MNEMONIC", "", "MNEMONIC_STRING", "Lksp/com/intellij/openapi/util/NlsSafe;", "SHOW_DEFAULT_MESSAGES", "", "SHOW_KEYS", "SHOW_LOCALIZED_MESSAGES", "appendLocalizationSuffix", "result", "suffixToAppend", "assertOnMissedKeys", "", "doAssert", "format", "value", "params", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "getDefaultMessage", "bundle", "Ljava/util/ResourceBundle;", "key", "message", "Lksp/org/jetbrains/annotations/Nls;", "(Ljava/util/ResourceBundle;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "messageOrDefault", "defaultValue", "(Ljava/util/ResourceBundle;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "partialMessage", "unassignedParams", "", "(Ljava/util/ResourceBundle;Ljava/lang/String;I[Ljava/lang/Object;)Ljava/lang/String;", "postprocessValue", "replaceMnemonicAmpersand", "setTranslationConsumer", "consumer", "Ljava/util/function/BiConsumer;", "useDefaultValue", "intellij.platform.util"})
public final class BundleBase {
    @NotNull
    public static final BundleBase INSTANCE = new BundleBase();
    public static final char MNEMONIC = '\u001b';
    @NotNull
    public static final String MNEMONIC_STRING = "\u001b";
    @JvmField
    public static final boolean SHOW_LOCALIZED_MESSAGES = Boolean.getBoolean("idea.l10n");
    @JvmField
    public static final boolean SHOW_DEFAULT_MESSAGES = Boolean.getBoolean("idea.l10n.english");
    @JvmField
    public static final boolean SHOW_KEYS = Boolean.getBoolean("idea.l10n.keys");
    @NotNull
    public static final String L10N_MARKER = "\ud83d\udd05";

    private BundleBase() {
    }

    public final void assertOnMissedKeys(boolean doAssert) {
        BundleBaseKt.access$setAssertOnMissedKeys$p(doAssert);
    }

    @JvmStatic
    @NotNull
    public static final String partialMessage(@NotNull ResourceBundle bundle, @NotNull String key, int unassignedParams, @NotNull Object[] params) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (!(unassignedParams > 0)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        Object[] objectArray = Arrays.copyOf(params, params.length + unassignedParams);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
        Object[] newParams = objectArray;
        String prefix = "#$$$TemplateParameter$$$#";
        String suffix = "#$$$/TemplateParameter$$$#";
        for (int i2 = 0; i2 < unassignedParams; ++i2) {
            newParams[i2 + params.length] = prefix + i2 + suffix;
        }
        Object[] objectArray2 = newParams;
        String message = BundleBase.message(bundle, key, Arrays.copyOf(objectArray2, objectArray2.length));
        return StringsKt.replace$default((String)StringsKt.replace$default((String)BundleBaseKt.access$quotePattern(message), (String)prefix, (String)"{", (boolean)false, (int)4, null), (String)suffix, (String)"}", (boolean)false, (int)4, null);
    }

    @JvmStatic
    @NotNull
    public static final String message(@NotNull ResourceBundle bundle, @NotNull String key, Object ... params) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        String string2 = BundleBase.messageOrDefault(bundle, key, null, Arrays.copyOf(params, params.length));
        Intrinsics.checkNotNull((Object)string2);
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final String messageOrDefault(@Nullable ResourceBundle bundle, @NotNull String key, @Nullable String defaultValue, Object ... params) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (bundle == null) {
            String string3 = defaultValue;
            Intrinsics.checkNotNull((Object)string3);
            return string3;
        }
        boolean resourceFound = true;
        try {
            string2 = bundle.getString(key);
        }
        catch (MissingResourceException e2) {
            resourceFound = false;
            string2 = BundleBase.useDefaultValue(bundle, key, defaultValue);
        }
        String value2 = string2;
        Intrinsics.checkNotNull((Object)value2);
        String result2 = BundleBase.postprocessValue(bundle, value2, Arrays.copyOf(params, params.length));
        BiConsumer biConsumer = BundleBaseKt.access$getTranslationConsumer$p();
        if (biConsumer != null) {
            biConsumer.accept(key, result2);
        }
        return !resourceFound ? result2 : (SHOW_KEYS && SHOW_DEFAULT_MESSAGES ? BundleBase.appendLocalizationSuffix(result2, " (" + key + '=' + BundleBase.getDefaultMessage(bundle, key) + ')') : (SHOW_KEYS ? BundleBase.appendLocalizationSuffix(result2, " (" + key + ')') : (SHOW_DEFAULT_MESSAGES ? BundleBase.appendLocalizationSuffix(result2, " (" + BundleBase.getDefaultMessage(bundle, key) + ')') : (SHOW_LOCALIZED_MESSAGES ? BundleBase.appendLocalizationSuffix(result2, L10N_MARKER) : result2))));
    }

    @JvmStatic
    @NotNull
    public static final String getDefaultMessage(@NotNull ResourceBundle bundle, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            Field field = ResourceBundle.class.getDeclaredField("parent");
            field.setAccessible(true);
            Object parentBundle = field.get(bundle);
            if (parentBundle instanceof ResourceBundle) {
                String string2 = ((ResourceBundle)parentBundle).getString(key);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
                return string2;
            }
        }
        catch (IllegalAccessException e2) {
            BundleBaseKt.access$getLOG().warn("Cannot fetch default message with 'idea.l10n.english' enabled, by key '" + key + '\'');
        }
        return "undefined";
    }

    @JvmStatic
    @NotNull
    public static final String appendLocalizationSuffix(@NotNull String result2, @NotNull String suffixToAppend) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)suffixToAppend, (String)"suffixToAppend");
        for (String suffix : BundleBaseKt.access$getSUFFIXES$p()) {
            if (!StringsKt.endsWith$default((String)result2, (String)suffix, (boolean)false, (int)2, null)) continue;
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = result2.substring(0, result2.length() - suffix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            return stringBuilder.append(string2).append(L10N_MARKER).append(suffix).toString();
        }
        return result2 + suffixToAppend;
    }

    @JvmStatic
    @NotNull
    public static final String useDefaultValue(@Nullable ResourceBundle bundle, @NotNull String key, @Nullable String defaultValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (defaultValue != null) {
            return defaultValue;
        }
        if (BundleBaseKt.access$getAssertOnMissedKeys$p()) {
            String bundleName = bundle == null ? "" : '(' + bundle.getBaseBundleName() + ')';
            BundleBaseKt.access$getLOG().error('\'' + key + "' is not found in " + bundle + bundleName);
        }
        return '!' + key + '!';
    }

    @JvmStatic
    @NotNull
    public static final String postprocessValue(@NotNull ResourceBundle bundle, @NotNull String value2, Object ... params) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        String value3 = value2;
        String string2 = BundleBase.replaceMnemonicAmpersand(value3);
        Intrinsics.checkNotNull((Object)string2);
        value3 = string2;
        if (!(params.length == 0) && StringsKt.contains$default((CharSequence)value3, (char)'{', (boolean)false, (int)2, null)) {
            String string3;
            Locale locale = bundle.getLocale();
            try {
                MessageFormat format = locale == null ? new MessageFormat(value3) : new MessageFormat(value3, locale);
                OrdinalFormat.apply(format);
                string3 = format.format(params);
                Intrinsics.checkNotNull((Object)string3);
            }
            catch (IllegalArgumentException e2) {
                string3 = "!invalid format: `" + value3 + "`!";
            }
            value3 = string3;
        }
        return value3;
    }

    @JvmStatic
    @Contract(pure=true)
    @NotNull
    public static final String format(@NotNull String value2, Object ... params) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (!(params.length == 0) && StringsKt.indexOf$default((CharSequence)value2, (char)'{', (int)0, (boolean)false, (int)6, null) >= 0) {
            String string3 = MessageFormat.format(value2, Arrays.copyOf(params, params.length));
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        } else {
            string2 = value2;
        }
        return string2;
    }

    @JvmStatic
    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static final String replaceMnemonicAmpersand(@Nullable String value2) {
        if (value2 == null || !StringsKt.contains$default((CharSequence)value2, (char)'&', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)value2, (char)'\u001b', (boolean)false, (int)2, null)) {
            return value2;
        }
        StringBuilder builder2 = new StringBuilder();
        boolean macMnemonic = StringsKt.contains$default((CharSequence)value2, (CharSequence)"&&", (boolean)false, (int)2, null);
        boolean mnemonicAdded = false;
        for (int i2 = 0; i2 < value2.length(); ++i2) {
            char c2 = value2.charAt(i2);
            if (c2 == '\\') {
                if (i2 < value2.length() - 1 && value2.charAt(i2 + 1) == '&') {
                    builder2.append('&');
                    ++i2;
                    continue;
                }
                builder2.append(c2);
                continue;
            }
            if (c2 == '&') {
                if (i2 < value2.length() - 1 && value2.charAt(i2 + 1) == '&') {
                    if (SystemInfoRt.isMac && !mnemonicAdded) {
                        mnemonicAdded = true;
                        builder2.append('\u001b');
                    }
                    ++i2;
                    continue;
                }
                if (SystemInfoRt.isMac && macMnemonic || mnemonicAdded) continue;
                mnemonicAdded = true;
                builder2.append('\u001b');
                continue;
            }
            builder2.append(c2);
        }
        return builder2.toString();
    }

    @JvmStatic
    @TestOnly
    public static final void setTranslationConsumer(@Nullable BiConsumer<String, String> consumer2) {
        BundleBaseKt.access$setTranslationConsumer$p(consumer2);
    }
}

