/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.google.common.collect;

import java.util.Queue;
import ksp.com.google.common.annotations.GwtCompatible;
import ksp.com.google.common.base.Preconditions;
import ksp.com.google.common.collect.AbstractIterator;
import ksp.com.google.common.collect.ElementTypesAreNonnullByDefault;
import ksp.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class ConsumingQueueIterator<T>
extends AbstractIterator<T> {
    private final Queue<T> queue;

    ConsumingQueueIterator(Queue<T> queue) {
        this.queue = Preconditions.checkNotNull(queue);
    }

    @Override
    @CheckForNull
    protected T computeNext() {
        if (this.queue.isEmpty()) {
            return this.endOfData();
        }
        return this.queue.remove();
    }
}

