/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.calls.checkers;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.psi.Call;
import ksp.org.jetbrains.kotlin.psi.KtBinaryExpression;
import ksp.org.jetbrains.kotlin.psi.KtElement;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtLambdaExpression;
import ksp.org.jetbrains.kotlin.psi.KtNamedFunction;
import ksp.org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import ksp.org.jetbrains.kotlin.psi.KtValueArgumentList;
import ksp.org.jetbrains.kotlin.psi.LambdaArgument;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.util.CallResolverUtilKt;
import ksp.org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.serialization.deserialization.SuspendFunctionTypeUtilKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0002J\u000e\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u000eH\u0002J\f\u0010\u0011\u001a\u00020\r*\u00020\u000eH\u0002J\f\u0010\u0012\u001a\u00020\r*\u00020\u000eH\u0002J\f\u0010\u0013\u001a\u00020\r*\u00020\u000eH\u0002\u00a8\u0006\u0014"}, d2={"Lksp/org/jetbrains/kotlin/resolve/calls/checkers/LambdaWithSuspendModifierCallChecker;", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lksp/com/intellij/psi/PsiElement;", "context", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "hasFormOfSuspendModifierForLambdaOrFun", "", "Lksp/org/jetbrains/kotlin/psi/Call;", "referencedName", "", "hasNoArgumentListButDanglingLambdas", "isInfixWithRightLambda", "isInfixWithRightFun", "frontend"})
public final class LambdaWithSuspendModifierCallChecker
implements CallChecker {
    @NotNull
    public static final LambdaWithSuspendModifierCallChecker INSTANCE = new LambdaWithSuspendModifierCallChecker();

    private LambdaWithSuspendModifierCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        String variableCalleeName;
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object obj = resolvedCall2.getCandidateDescriptor();
        Intrinsics.checkNotNullExpressionValue(obj, (String)"getCandidateDescriptor(...)");
        Object descriptor2 = obj;
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"getCall(...)");
        Call call3 = call2;
        String calleeName = this.referencedName(call3);
        Object object = resolvedCall2 instanceof VariableAsFunctionResolvedCall ? (VariableAsFunctionResolvedCall)((Object)resolvedCall2) : null;
        String string2 = object != null && (object = object.getVariableCall()) != null && (object = object.getCall()) != null ? this.referencedName((Call)object) : (variableCalleeName = null);
        if (!(Intrinsics.areEqual((Object)calleeName, (Object)"suspend") || Intrinsics.areEqual((Object)variableCalleeName, (Object)"suspend") || Intrinsics.areEqual((Object)descriptor2.getName().asString(), (Object)"suspend"))) {
            return;
        }
        if (Intrinsics.areEqual((Object)DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)descriptor2), (Object)SuspendFunctionTypeUtilKt.KOTLIN_SUSPEND_BUILT_IN_FUNCTION_FQ_NAME)) {
            if (!Intrinsics.areEqual((Object)calleeName, (Object)"suspend") || !this.hasFormOfSuspendModifierForLambdaOrFun(call3) || call3.getExplicitReceiver() != null) {
                context2.getTrace().report(Errors.NON_MODIFIER_FORM_FOR_BUILT_IN_SUSPEND.on(reportOn));
            }
        } else if ((Intrinsics.areEqual((Object)calleeName, (Object)"suspend") || Intrinsics.areEqual((Object)variableCalleeName, (Object)"suspend")) && this.hasFormOfSuspendModifierForLambdaOrFun(call3)) {
            if (this.hasNoArgumentListButDanglingLambdas(call3) || this.isInfixWithRightLambda(call3)) {
                context2.getTrace().report(Errors.MODIFIER_FORM_FOR_NON_BUILT_IN_SUSPEND.on(reportOn));
            } else {
                if (!this.isInfixWithRightFun(call3)) {
                    String string3 = "Failed requirement.";
                    throw new IllegalArgumentException(string3.toString());
                }
                context2.getTrace().report(Errors.MODIFIER_FORM_FOR_NON_BUILT_IN_SUSPEND_FUN.on(context2.getLanguageVersionSettings(), reportOn));
            }
        }
    }

    private final boolean hasFormOfSuspendModifierForLambdaOrFun(Call $this$hasFormOfSuspendModifierForLambdaOrFun) {
        return !CallUtilKt.isCallableReference($this$hasFormOfSuspendModifierForLambdaOrFun) && $this$hasFormOfSuspendModifierForLambdaOrFun.getTypeArguments().isEmpty() && (this.hasNoArgumentListButDanglingLambdas($this$hasFormOfSuspendModifierForLambdaOrFun) || this.isInfixWithRightLambda($this$hasFormOfSuspendModifierForLambdaOrFun) || this.isInfixWithRightFun($this$hasFormOfSuspendModifierForLambdaOrFun));
    }

    private final String referencedName(Call $this$referencedName) {
        KtExpression ktExpression = $this$referencedName.getCalleeExpression();
        KtSimpleNameExpression ktSimpleNameExpression = ktExpression instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)ktExpression : null;
        return ktSimpleNameExpression != null ? ktSimpleNameExpression.getReferencedName() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasNoArgumentListButDanglingLambdas(Call $this$hasNoArgumentListButDanglingLambdas) {
        KtValueArgumentList ktValueArgumentList = $this$hasNoArgumentListButDanglingLambdas.getValueArgumentList();
        if ((ktValueArgumentList != null ? ktValueArgumentList.getLeftParenthesis() : null) != null) return false;
        List<? extends LambdaArgument> list = $this$hasNoArgumentListButDanglingLambdas.getFunctionLiteralArguments();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getFunctionLiteralArguments(...)");
        if (((Collection)list).isEmpty()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInfixWithRightLambda(Call $this$isInfixWithRightLambda) {
        if (!CallResolverUtilKt.isInfixCall($this$isInfixWithRightLambda)) return false;
        KtElement ktElement = $this$isInfixWithRightLambda.getCallElement();
        KtBinaryExpression ktBinaryExpression = ktElement instanceof KtBinaryExpression ? (KtBinaryExpression)ktElement : null;
        if (!((ktBinaryExpression != null ? ktBinaryExpression.getRight() : null) instanceof KtLambdaExpression)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInfixWithRightFun(Call $this$isInfixWithRightFun) {
        if (!CallResolverUtilKt.isInfixCall($this$isInfixWithRightFun)) return false;
        KtElement ktElement = $this$isInfixWithRightFun.getCallElement();
        KtBinaryExpression ktBinaryExpression = ktElement instanceof KtBinaryExpression ? (KtBinaryExpression)ktElement : null;
        if (!((ktBinaryExpression != null ? ktBinaryExpression.getRight() : null) instanceof KtNamedFunction)) return false;
        return true;
    }
}

