/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.psi;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.stubs.IStubElementType;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.com.intellij.psi.tree.TokenSet;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.psi.KtClassBody;
import ksp.org.jetbrains.kotlin.psi.KtClassOrObject;
import ksp.org.jetbrains.kotlin.psi.KtModifierList;
import ksp.org.jetbrains.kotlin.psi.KtObjectDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtProperty;
import ksp.org.jetbrains.kotlin.psi.KtVisitor;
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinClassOrObjectStub;
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinClassStub;
import ksp.org.jetbrains.kotlin.psi.stubs.elements.KtClassElementType;
import ksp.org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bB!\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\t\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n\u00a2\u0006\u0004\b\u0004\u0010\u000bJ5\u0010\u000f\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u0010\"\u0004\b\u0001\u0010\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u0002H\u00110\u00132\u0006\u0010\u0014\u001a\u0002H\u0011H\u0016\u00a2\u0006\u0002\u0010\u0015J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001dJ\u0006\u0010\u001f\u001a\u00020\u001dJ\u0006\u0010 \u001a\u00020\u001dJ\u0006\u0010!\u001a\u00020\u001dJ\u0006\u0010\"\u001a\u00020\u001dJ\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u001aH\u0016J\b\u0010%\u001a\u0004\u0018\u00010&J\b\u0010'\u001a\u0004\u0018\u00010&J\b\u0010(\u001a\u0004\u0018\u00010&R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006)"}, d2={"Lksp/org/jetbrains/kotlin/psi/KtClass;", "Lksp/org/jetbrains/kotlin/psi/KtClassOrObject;", "node", "Lksp/com/intellij/lang/ASTNode;", "<init>", "(Lcom/intellij/lang/ASTNode;)V", "stub", "Lksp/org/jetbrains/kotlin/psi/stubs/KotlinClassStub;", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinClassStub;)V", "nodeType", "Lksp/com/intellij/psi/stubs/IStubElementType;", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinClassStub;Lcom/intellij/psi/stubs/IStubElementType;)V", "classInterfaceTokenSet", "Lksp/com/intellij/psi/tree/TokenSet;", "Lksp/org/jetbrains/annotations/NotNull;", "accept", "R", "D", "visitor", "Lksp/org/jetbrains/kotlin/psi/KtVisitor;", "data", "(Lorg/jetbrains/kotlin/psi/KtVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "_stub", "get_stub", "()Lorg/jetbrains/kotlin/psi/stubs/KotlinClassStub;", "getProperties", "", "Lksp/org/jetbrains/kotlin/psi/KtProperty;", "isInterface", "", "isEnum", "isSealed", "isInner", "isInline", "isValue", "getCompanionObjects", "Lksp/org/jetbrains/kotlin/psi/KtObjectDeclaration;", "getClassOrInterfaceKeyword", "Lksp/com/intellij/psi/PsiElement;", "getClassKeyword", "getFunKeyword", "psi"})
public class KtClass
extends KtClassOrObject {
    @NotNull
    private final TokenSet classInterfaceTokenSet;

    public KtClass(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        super(node);
        IElementType[] iElementTypeArray = new IElementType[]{KtTokens.CLASS_KEYWORD, KtTokens.INTERFACE_KEYWORD};
        TokenSet tokenSet = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        this.classInterfaceTokenSet = tokenSet;
    }

    public KtClass(@NotNull KotlinClassStub stub2) {
        Intrinsics.checkNotNullParameter((Object)stub2, (String)"stub");
        KotlinClassOrObjectStub kotlinClassOrObjectStub = stub2;
        KtClassElementType ktClassElementType = KtStubElementTypes.CLASS;
        Intrinsics.checkNotNullExpressionValue((Object)ktClassElementType, (String)"CLASS");
        super(kotlinClassOrObjectStub, (IStubElementType)ktClassElementType);
        IElementType[] iElementTypeArray = new IElementType[]{KtTokens.CLASS_KEYWORD, KtTokens.INTERFACE_KEYWORD};
        TokenSet tokenSet = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        this.classInterfaceTokenSet = tokenSet;
    }

    public KtClass(@NotNull KotlinClassStub stub2, @NotNull IStubElementType<?, ?> nodeType) {
        Intrinsics.checkNotNullParameter((Object)stub2, (String)"stub");
        Intrinsics.checkNotNullParameter(nodeType, (String)"nodeType");
        super(stub2, nodeType);
        IElementType[] iElementTypeArray = new IElementType[]{KtTokens.CLASS_KEYWORD, KtTokens.INTERFACE_KEYWORD};
        TokenSet tokenSet = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        this.classInterfaceTokenSet = tokenSet;
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        Intrinsics.checkNotNullParameter(visitor2, (String)"visitor");
        return visitor2.visitClass(this, data);
    }

    private final KotlinClassStub get_stub() {
        Object t2 = this.getGreenStub();
        return t2 instanceof KotlinClassStub ? (KotlinClassStub)t2 : null;
    }

    @NotNull
    public final List<KtProperty> getProperties() {
        KtClassBody ktClassBody = this.getBody();
        List list = ktClassBody != null ? ktClassBody.getProperties() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final boolean isInterface() {
        KotlinClassStub kotlinClassStub = this.get_stub();
        return kotlinClassStub != null ? kotlinClassStub.isInterface() : this.findChildByType(KtTokens.INTERFACE_KEYWORD) != null;
    }

    public final boolean isEnum() {
        return this.hasModifier(KtTokens.ENUM_KEYWORD);
    }

    public final boolean isSealed() {
        return this.hasModifier(KtTokens.SEALED_KEYWORD);
    }

    public final boolean isInner() {
        return this.hasModifier(KtTokens.INNER_KEYWORD);
    }

    public final boolean isInline() {
        return this.hasModifier(KtTokens.INLINE_KEYWORD);
    }

    public final boolean isValue() {
        return this.hasModifier(KtTokens.VALUE_KEYWORD);
    }

    @Override
    @NotNull
    public List<KtObjectDeclaration> getCompanionObjects() {
        KtClassBody ktClassBody = this.getBody();
        List list = ktClassBody != null ? ktClassBody.getAllCompanionObjects() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Nullable
    public final PsiElement getClassOrInterfaceKeyword() {
        return this.findChildByType(this.classInterfaceTokenSet);
    }

    @Nullable
    public final PsiElement getClassKeyword() {
        return this.findChildByType(KtTokens.CLASS_KEYWORD);
    }

    @Nullable
    public final PsiElement getFunKeyword() {
        KtModifierList ktModifierList = this.getModifierList();
        return ktModifierList != null ? ktModifierList.getModifier(KtTokens.FUN_KEYWORD) : null;
    }
}

