/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util;

import java.nio.charset.StandardCharsets;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.util.NlsSafe;
import ksp.com.intellij.openapi.util.SystemInfo;
import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.org.jetbrains.annotations.NotNull;

public enum LineSeparator {
    LF("\n"),
    CRLF("\r\n"),
    CR("\r");

    private final String mySeparatorString;
    private final byte[] myBytes;

    private LineSeparator(String separatorString) {
        if (separatorString == null) {
            LineSeparator.$$$reportNull$$$0(0);
        }
        this.mySeparatorString = separatorString;
        this.myBytes = separatorString.getBytes(StandardCharsets.UTF_8);
    }

    @NlsSafe
    public String toString() {
        return super.toString();
    }

    @NotNull
    public static LineSeparator fromString(@NotNull String string2) {
        if (string2 == null) {
            LineSeparator.$$$reportNull$$$0(1);
        }
        for (LineSeparator separator : LineSeparator.values()) {
            if (!separator.getSeparatorString().equals(string2)) continue;
            LineSeparator lineSeparator = separator;
            if (lineSeparator == null) {
                LineSeparator.$$$reportNull$$$0(2);
            }
            return lineSeparator;
        }
        Logger.getInstance(LineSeparator.class).error("Invalid string for line separator: " + StringUtil.escapeStringCharacters(string2));
        return LineSeparator.getSystemLineSeparator();
    }

    @NotNull
    public String getSeparatorString() {
        String string2 = this.mySeparatorString;
        if (string2 == null) {
            LineSeparator.$$$reportNull$$$0(3);
        }
        return string2;
    }

    public byte @NotNull [] getSeparatorBytes() {
        if (this.myBytes == null) {
            LineSeparator.$$$reportNull$$$0(4);
        }
        return this.myBytes;
    }

    @NotNull
    public static LineSeparator getSystemLineSeparator() {
        LineSeparator lineSeparator = SystemInfo.isWindows ? CRLF : LF;
        if (lineSeparator == null) {
            LineSeparator.$$$reportNull$$$0(5);
        }
        return lineSeparator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separatorString";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/util/LineSeparator";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/util/LineSeparator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "fromString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparatorString";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparatorBytes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemLineSeparator";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

