/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.editor.colors;

import java.awt.Color;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.util.Comparing;
import ksp.com.intellij.openapi.util.Key;
import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.com.intellij.util.ConcurrencyUtil;
import ksp.com.intellij.util.containers.JBIterable;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class ColorKey
implements Comparable<ColorKey> {
    private static final Logger LOG = Logger.getInstance(ColorKey.class);
    public static final Key<Function<ColorKey, Color>> FUNCTION_KEY = Key.create("COLOR_KEY_FUNCTION");
    private static final ConcurrentMap<String, ColorKey> ourRegistry = new ConcurrentHashMap<String, ColorKey>();
    private final String myExternalName;
    private final Color myDefaultColor;
    private final ColorKey myFallbackColorKey;

    private ColorKey(@NotNull String externalName, Color defaultColor, ColorKey fallBackColorKey) {
        if (externalName == null) {
            ColorKey.$$$reportNull$$$0(0);
        }
        this.myExternalName = externalName;
        this.myDefaultColor = defaultColor;
        this.myFallbackColorKey = fallBackColorKey;
    }

    @NotNull
    public static ColorKey find(@NotNull String externalName) {
        if (externalName == null) {
            ColorKey.$$$reportNull$$$0(1);
        }
        ColorKey colorKey = ourRegistry.computeIfAbsent(externalName, s2 -> new ColorKey((String)s2, null, null));
        if (colorKey == null) {
            ColorKey.$$$reportNull$$$0(2);
        }
        return colorKey;
    }

    public String toString() {
        return this.myExternalName;
    }

    @NotNull
    public String getExternalName() {
        String string2 = this.myExternalName;
        if (string2 == null) {
            ColorKey.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @Override
    public int compareTo(@NotNull ColorKey key) {
        if (key == null) {
            ColorKey.$$$reportNull$$$0(4);
        }
        return this.myExternalName.compareTo(key.myExternalName);
    }

    public Color getDefaultColor() {
        return this.myDefaultColor;
    }

    @Nullable
    public ColorKey getFallbackColorKey() {
        return this.myFallbackColorKey;
    }

    @NotNull
    public static ColorKey createColorKey(@NonNls @NotNull String externalName) {
        if (externalName == null) {
            ColorKey.$$$reportNull$$$0(5);
        }
        return ColorKey.find(externalName);
    }

    @NotNull
    public static ColorKey createColorKeyWithFallback(@NonNls @NotNull String externalName, @Nullable ColorKey fallbackColorKey) {
        JBIterable<ColorKey> it;
        ColorKey existing;
        if (externalName == null) {
            ColorKey.$$$reportNull$$$0(6);
        }
        if ((existing = (ColorKey)ourRegistry.get(externalName)) != null) {
            if (Comparing.equal(existing.getFallbackColorKey(), fallbackColorKey)) {
                ColorKey colorKey = existing;
                if (colorKey == null) {
                    ColorKey.$$$reportNull$$$0(7);
                }
                return colorKey;
            }
            ourRegistry.remove(externalName, existing);
        }
        ColorKey newKey = new ColorKey(externalName, existing == null ? null : existing.getDefaultColor(), fallbackColorKey);
        ColorKey res2 = ConcurrencyUtil.cacheOrGet(ourRegistry, externalName, newKey);
        if (fallbackColorKey != null && (it = JBIterable.generate(fallbackColorKey, o2 -> o2 == res2 ? null : o2.myFallbackColorKey)).find(o2 -> o2 == res2) == res2) {
            String cycle = StringUtil.join(it.map(ColorKey::getExternalName), "->");
            LOG.error("Cycle detected: " + cycle);
        }
        ColorKey colorKey = res2;
        if (colorKey == null) {
            ColorKey.$$$reportNull$$$0(8);
        }
        return colorKey;
    }

    @NotNull
    public static ColorKey createColorKey(@NonNls @NotNull String externalName, @Nullable Color defaultColor) {
        ColorKey existing;
        if (externalName == null) {
            ColorKey.$$$reportNull$$$0(9);
        }
        if ((existing = (ColorKey)ourRegistry.get(externalName)) != null) {
            if (Comparing.equal(existing.getDefaultColor(), defaultColor)) {
                ColorKey colorKey = existing;
                if (colorKey == null) {
                    ColorKey.$$$reportNull$$$0(10);
                }
                return colorKey;
            }
            ourRegistry.remove(externalName, existing);
        }
        ColorKey newKey = new ColorKey(externalName, defaultColor, existing == null ? null : existing.getFallbackColorKey());
        ColorKey colorKey = ConcurrencyUtil.cacheOrGet(ourRegistry, externalName, newKey);
        if (colorKey == null) {
            ColorKey.$$$reportNull$$$0(11);
        }
        return colorKey;
    }

    public int hashCode() {
        return this.myExternalName.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ColorKey && this.myExternalName.equals(((ColorKey)obj).myExternalName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalName";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/openapi/editor/colors/ColorKey";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/openapi/editor/colors/ColorKey";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createColorKeyWithFallback";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createColorKey";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 5: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createColorKey";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createColorKeyWithFallback";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

