/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.util;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import ksp.com.intellij.diagnostic.PluginException;
import ksp.com.intellij.openapi.Disposable;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.extensions.ExtensionNotApplicableException;
import ksp.com.intellij.openapi.extensions.ExtensionPoint;
import ksp.com.intellij.openapi.extensions.ExtensionPointAndAreaListener;
import ksp.com.intellij.openapi.extensions.ExtensionPointName;
import ksp.com.intellij.openapi.extensions.ExtensionPointPriorityListener;
import ksp.com.intellij.openapi.extensions.Extensions;
import ksp.com.intellij.openapi.extensions.ExtensionsArea;
import ksp.com.intellij.openapi.extensions.PluginDescriptor;
import ksp.com.intellij.openapi.progress.ProcessCanceledException;
import ksp.com.intellij.openapi.util.Disposer;
import ksp.com.intellij.openapi.util.ModificationTracker;
import ksp.com.intellij.openapi.util.SimpleModificationTracker;
import ksp.com.intellij.util.KeyedLazyInstance;
import ksp.kotlinx.collections.immutable.ExtensionsKt;
import ksp.kotlinx.collections.immutable.PersistentList;
import ksp.kotlinx.collections.immutable.PersistentMap;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public class KeyedExtensionCollector<T, KeyT>
implements ModificationTracker {
    private static final Logger LOG = Logger.getInstance(KeyedExtensionCollector.class);
    @NonNls
    protected final String lock;
    private PersistentMap<String, PersistentList<T>> explicitExtensions;
    private volatile PersistentMap<String, PersistentList<T>> cache;
    private final String myEpName;
    private final SimpleModificationTracker tracker;
    protected final AtomicBoolean myEpListenerAdded;

    public KeyedExtensionCollector(@NotNull ExtensionPointName<? extends KeyedLazyInstance<T>> epName) {
        if (epName == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(0);
        }
        this(epName.getName());
    }

    public KeyedExtensionCollector(@NotNull String epName) {
        if (epName == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(1);
        }
        this.explicitExtensions = ExtensionsKt.persistentHashMapOf();
        this.cache = ExtensionsKt.persistentHashMapOf();
        this.tracker = new SimpleModificationTracker();
        this.myEpListenerAdded = new AtomicBoolean();
        this.myEpName = epName;
        this.lock = "lock for KeyedExtensionCollector " + epName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        String string2 = this.lock;
        synchronized (string2) {
            this.cache = this.cache.clear();
            this.tracker.incModificationCount();
        }
    }

    private void addExtensionPointListener(@NotNull @NotNull ExtensionPoint<@NotNull KeyedLazyInstance<T>> point) {
        if (point == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(2);
        }
        if (this.myEpListenerAdded.compareAndSet(false, true)) {
            point.addExtensionPointListener(new MyExtensionPointListener(), false, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateCacheForExtension(String key) {
        String string2 = this.lock;
        synchronized (string2) {
            if (key != null) {
                this.cache = this.cache.remove(key);
            }
            this.tracker.incModificationCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExplicitExtension(@NotNull KeyT key, @NotNull T t2) {
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(3);
        }
        if (t2 == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(4);
        }
        String stringKey = this.keyToString(key);
        String string2 = this.lock;
        synchronized (string2) {
            PersistentList value2 = (PersistentList)this.explicitExtensions.get(stringKey);
            this.explicitExtensions = this.explicitExtensions.put(stringKey, value2 == null ? ExtensionsKt.persistentListOf(t2) : value2.add(t2));
            this.invalidateCacheForExtension(stringKey);
        }
    }

    public void addExplicitExtension(@NotNull KeyT key, @NotNull T t2, @NotNull Disposable parentDisposable) {
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(5);
        }
        if (t2 == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(6);
        }
        if (parentDisposable == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(7);
        }
        this.addExplicitExtension(key, t2);
        Disposer.register(parentDisposable, () -> this.removeExplicitExtension(key, t2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExplicitExtension(@NotNull KeyT key, @NotNull T t2) {
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(8);
        }
        if (t2 == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(9);
        }
        String stringKey = this.keyToString(key);
        String string2 = this.lock;
        synchronized (string2) {
            PersistentList<T> list = (PersistentList<T>)this.explicitExtensions.get(stringKey);
            if (list != null) {
                this.explicitExtensions = (list = list.remove(t2)).isEmpty() ? this.explicitExtensions.remove(stringKey) : this.explicitExtensions.put(stringKey, list);
            }
            this.invalidateCacheForExtension(stringKey);
        }
    }

    @NotNull
    protected String keyToString(@NotNull KeyT key) {
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(10);
        }
        String string2 = key.toString();
        if (string2 == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(11);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public final List<T> forKey(@NotNull KeyT key) {
        String stringKey;
        PersistentList<T> cached;
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(12);
        }
        if ((cached = (PersistentList<T>)this.cache.get(stringKey = this.keyToString(key))) != null) {
            PersistentList<T> persistentList = cached;
            if (persistentList != null) return persistentList;
            KeyedExtensionCollector.$$$reportNull$$$0(13);
            return persistentList;
        }
        cached = this.buildExtensions(stringKey, key);
        String string2 = this.lock;
        // MONITORENTER : string2
        PersistentList recent = (PersistentList)this.cache.get(stringKey);
        if (recent != null) {
            PersistentList persistentList = recent;
            // MONITOREXIT : string2
            if (persistentList != null) return persistentList;
            KeyedExtensionCollector.$$$reportNull$$$0(14);
            return persistentList;
        }
        this.cache = this.cache.put(stringKey, cached);
        PersistentList<T> persistentList = cached;
        // MONITOREXIT : string2
        if (persistentList != null) return persistentList;
        KeyedExtensionCollector.$$$reportNull$$$0(15);
        return persistentList;
    }

    public final T findSingle(@NotNull KeyT key) {
        List<T> list;
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(16);
        }
        return (list = this.forKey(key)).isEmpty() ? null : (T)list.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    protected PersistentList<T> buildExtensions(@NotNull String stringKey, @NotNull KeyT key) {
        if (stringKey == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(17);
        }
        if (key == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(18);
        }
        List<KeyedLazyInstance<T>> extensions = this.getExtensions();
        String string2 = this.lock;
        // MONITORENTER : string2
        PersistentList explicit = (PersistentList)this.explicitExtensions.get(stringKey);
        PersistentList<T> result2 = this.buildExtensionsFromExtensionPoint(bean -> stringKey.equals(bean.getKey()), extensions);
        PersistentList<T> persistentList = explicit == null ? result2 : explicit.addAll(result2);
        // MONITOREXIT : string2
        if (persistentList != null) return persistentList;
        KeyedExtensionCollector.$$$reportNull$$$0(19);
        return persistentList;
    }

    @NotNull
    protected final List<KeyedLazyInstance<T>> getExtensions() {
        ExtensionPoint<@NotNull KeyedLazyInstance<T>> point = this.getPoint();
        if (point == null) {
            List<KeyedLazyInstance<T>> list = Collections.emptyList();
            if (list == null) {
                KeyedExtensionCollector.$$$reportNull$$$0(20);
            }
            return list;
        }
        this.addExtensionPointListener(point);
        List<KeyedLazyInstance<T>> list = point.getExtensionList();
        if (list == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(21);
        }
        return list;
    }

    @NotNull
    final PersistentList<T> buildExtensionsFromExtensionPoint(@NotNull Predicate<? super KeyedLazyInstance<T>> isMyBean, @NotNull List<? extends KeyedLazyInstance<T>> extensions) {
        if (isMyBean == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(22);
        }
        if (extensions == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(23);
        }
        PersistentList<T> result2 = ExtensionsKt.persistentListOf();
        for (KeyedLazyInstance<T> bean : extensions) {
            T instance2;
            if (!isMyBean.test(bean) || (instance2 = KeyedExtensionCollector.instantiate(bean)) == null) continue;
            result2 = result2.add(instance2);
        }
        PersistentList<T> persistentList = result2;
        if (persistentList == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(24);
        }
        return persistentList;
    }

    @Nullable
    public static <T> T instantiate(@NotNull KeyedLazyInstance<T> bean) {
        if (bean == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(25);
        }
        try {
            return bean.getInstance();
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (ExtensionNotApplicableException ignore) {
            return null;
        }
        catch (Exception | LinkageError e) {
            LOG.error(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    protected final PersistentList<T> buildExtensions(@NotNull Set<String> keys) {
        if (keys == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(26);
        }
        List<KeyedLazyInstance<T>> extensions = this.getExtensions();
        String string2 = this.lock;
        // MONITORENTER : string2
        PersistentList<T> explicit = this.buildExtensionsFromExplicitRegistration(keys::contains);
        PersistentList<T> result2 = this.buildExtensionsFromExtensionPoint(bean -> keys.contains(bean.getKey()), extensions);
        PersistentList<T> persistentList = explicit.addAll(result2);
        // MONITOREXIT : string2
        if (persistentList != null) return persistentList;
        KeyedExtensionCollector.$$$reportNull$$$0(27);
        return persistentList;
    }

    @NotNull
    protected final PersistentList<T> buildExtensionsFromExplicitRegistration(@NotNull Predicate<? super String> isMyBean) {
        if (isMyBean == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(28);
        }
        PersistentList result2 = ExtensionsKt.persistentListOf();
        for (Map.Entry entry : this.explicitExtensions.entrySet()) {
            String key = (String)entry.getKey();
            if (!isMyBean.test(key)) continue;
            result2 = result2.addAll((Collection)entry.getValue());
        }
        PersistentList persistentList = result2;
        if (persistentList == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(29);
        }
        return persistentList;
    }

    @ApiStatus.Internal
    public final @Nullable ExtensionPoint<@NotNull KeyedLazyInstance<T>> getPoint() {
        return Extensions.getRootArea().getExtensionPointIfRegistered(this.myEpName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAnyExtensions() {
        String string2 = this.lock;
        synchronized (string2) {
            if (!this.explicitExtensions.isEmpty()) {
                return true;
            }
        }
        ExtensionPoint<@NotNull KeyedLazyInstance<T>> point = this.getPoint();
        return point != null && point.size() != 0;
    }

    @NotNull
    public String getName() {
        String string2 = this.myEpName;
        if (string2 == null) {
            KeyedExtensionCollector.$$$reportNull$$$0(30);
        }
        return string2;
    }

    @Override
    public long getModificationCount() {
        return this.tracker.getModificationCount();
    }

    protected void ensureValuesLoaded() {
        ExtensionPoint<@NotNull KeyedLazyInstance<T>> point = this.getPoint();
        if (point != null) {
            for (KeyedLazyInstance<T> bean : point.getExtensionList()) {
                bean.getInstance();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 27: 
            case 29: 
            case 30: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 27: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "epName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 27: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/openapi/util/KeyedExtensionCollector";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringKey";
                break;
            }
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isMyBean";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/openapi/util/KeyedExtensionCollector";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "keyToString";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "forKey";
                break;
            }
            case 19: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "buildExtensions";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "buildExtensionsFromExtensionPoint";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "buildExtensionsFromExplicitRegistration";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addExtensionPointListener";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addExplicitExtension";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeExplicitExtension";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "keyToString";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 27: 
            case 29: 
            case 30: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "forKey";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findSingle";
                break;
            }
            case 17: 
            case 18: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "buildExtensions";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "buildExtensionsFromExtensionPoint";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "instantiate";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "buildExtensionsFromExplicitRegistration";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 27: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyExtensionPointListener
    implements ExtensionPointAndAreaListener<KeyedLazyInstance<T>>,
    ExtensionPointPriorityListener {
        private MyExtensionPointListener() {
        }

        @Override
        public void extensionAdded(@NotNull KeyedLazyInstance<T> bean, @NotNull PluginDescriptor pluginDescriptor) {
            if (bean == null) {
                MyExtensionPointListener.$$$reportNull$$$0(0);
            }
            if (pluginDescriptor == null) {
                MyExtensionPointListener.$$$reportNull$$$0(1);
            }
            if (bean.getKey() == null) {
                throw new PluginException("No key specified for extension of class " + bean.getInstance().getClass(), pluginDescriptor.getPluginId());
            }
            KeyedExtensionCollector.this.invalidateCacheForExtension(bean.getKey());
        }

        @Override
        public void extensionRemoved(@NotNull KeyedLazyInstance<T> bean, @NotNull PluginDescriptor pluginDescriptor) {
            if (bean == null) {
                MyExtensionPointListener.$$$reportNull$$$0(2);
            }
            if (pluginDescriptor == null) {
                MyExtensionPointListener.$$$reportNull$$$0(3);
            }
            KeyedExtensionCollector.this.invalidateCacheForExtension(bean.getKey());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void areaReplaced(@NotNull ExtensionsArea area) {
            if (area == null) {
                MyExtensionPointListener.$$$reportNull$$$0(4);
            }
            String string2 = KeyedExtensionCollector.this.lock;
            synchronized (string2) {
                KeyedExtensionCollector.this.cache = KeyedExtensionCollector.this.cache.clear();
                KeyedExtensionCollector.this.tracker.incModificationCount();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bean";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginDescriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "area";
                    break;
                }
            }
            objectArray2[1] = "ksp/com/intellij/openapi/util/KeyedExtensionCollector$MyExtensionPointListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extensionAdded";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extensionRemoved";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "areaReplaced";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

