/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.core;

import java.io.File;
import ksp.com.intellij.core.CoreApplicationEnvironment;
import ksp.com.intellij.core.CoreJavaCodeStyleManager;
import ksp.com.intellij.core.CoreJavaCodeStyleSettingsFacade;
import ksp.com.intellij.core.CoreJavaFileCodeStyleFacade;
import ksp.com.intellij.core.CoreJavaFileManager;
import ksp.com.intellij.core.CoreJavaPsiImplementationHelper;
import ksp.com.intellij.core.CoreLanguageLevelProjectExtension;
import ksp.com.intellij.core.CorePackageIndex;
import ksp.com.intellij.core.CoreProjectEnvironment;
import ksp.com.intellij.lang.jvm.facade.JvmFacade;
import ksp.com.intellij.lang.jvm.facade.JvmFacadeImpl;
import ksp.com.intellij.mock.MockFileIndexFacade;
import ksp.com.intellij.openapi.Disposable;
import ksp.com.intellij.openapi.roots.LanguageLevelProjectExtension;
import ksp.com.intellij.openapi.roots.PackageIndex;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.psi.JavaPsiFacade;
import ksp.com.intellij.psi.JvmPsiConversionHelper;
import ksp.com.intellij.psi.PsiElementFactory;
import ksp.com.intellij.psi.PsiResolveHelper;
import ksp.com.intellij.psi.codeStyle.JavaCodeStyleManager;
import ksp.com.intellij.psi.codeStyle.JavaCodeStyleSettingsFacade;
import ksp.com.intellij.psi.codeStyle.JavaFileCodeStyleFacade;
import ksp.com.intellij.psi.controlFlow.ControlFlowFactory;
import ksp.com.intellij.psi.impl.JavaPsiFacadeImpl;
import ksp.com.intellij.psi.impl.JavaPsiImplementationHelper;
import ksp.com.intellij.psi.impl.JvmPsiConversionHelperImpl;
import ksp.com.intellij.psi.impl.PsiElementFactoryImpl;
import ksp.com.intellij.psi.impl.file.impl.JavaFileManager;
import ksp.com.intellij.psi.impl.source.resolve.JavaResolveCache;
import ksp.com.intellij.psi.impl.source.resolve.PsiResolveHelperImpl;
import ksp.org.jetbrains.annotations.NotNull;

public class JavaCoreProjectEnvironment
extends CoreProjectEnvironment {
    private final JavaFileManager myFileManager;
    private final PackageIndex myPackageIndex;

    public JavaCoreProjectEnvironment(@NotNull Disposable parentDisposable, @NotNull CoreApplicationEnvironment applicationEnvironment) {
        if (parentDisposable == null) {
            JavaCoreProjectEnvironment.$$$reportNull$$$0(0);
        }
        if (applicationEnvironment == null) {
            JavaCoreProjectEnvironment.$$$reportNull$$$0(1);
        }
        super(parentDisposable, applicationEnvironment);
        this.project.registerService(PsiElementFactory.class, new PsiElementFactoryImpl(this.project));
        this.project.registerService(JavaPsiImplementationHelper.class, this.createJavaPsiImplementationHelper());
        this.project.registerService(PsiResolveHelper.class, new PsiResolveHelperImpl(this.project));
        this.project.registerService(LanguageLevelProjectExtension.class, new CoreLanguageLevelProjectExtension());
        this.project.registerService(JavaResolveCache.class, new JavaResolveCache(this.project));
        this.project.registerService(JavaCodeStyleSettingsFacade.class, new CoreJavaCodeStyleSettingsFacade());
        this.project.registerService(JavaFileCodeStyleFacade.class, new CoreJavaFileCodeStyleFacade());
        this.project.registerService(JavaCodeStyleManager.class, new CoreJavaCodeStyleManager());
        this.project.registerService(ControlFlowFactory.class, new ControlFlowFactory(this.project));
        this.myPackageIndex = this.createCorePackageIndex();
        this.project.registerService(PackageIndex.class, this.myPackageIndex);
        this.myFileManager = this.createCoreFileManager();
        this.project.registerService(JavaFileManager.class, this.myFileManager);
        this.project.registerService(JvmPsiConversionHelper.class, new JvmPsiConversionHelperImpl());
        this.registerJavaPsiFacade();
        this.project.registerService(JvmFacade.class, new JvmFacadeImpl(this.project));
    }

    protected void registerJavaPsiFacade() {
        JavaPsiFacadeImpl javaPsiFacade = new JavaPsiFacadeImpl(this.project);
        this.project.registerService(JavaPsiFacade.class, javaPsiFacade);
    }

    protected CoreJavaPsiImplementationHelper createJavaPsiImplementationHelper() {
        return new CoreJavaPsiImplementationHelper(this.project);
    }

    protected JavaFileManager createCoreFileManager() {
        return new CoreJavaFileManager(this.myPsiManager);
    }

    protected PackageIndex createCorePackageIndex() {
        return new CorePackageIndex();
    }

    public void addJarToClassPath(File path) {
        assert (path.isFile());
        VirtualFile root = this.getEnvironment().getJarFileSystem().findFileByPath(path + "!/");
        if (root == null) {
            throw new IllegalArgumentException("trying to add non-existing file to classpath: " + path);
        }
        this.addSourcesToClasspath(root);
    }

    public void addSourcesToClasspath(@NotNull VirtualFile root) {
        if (root == null) {
            JavaCoreProjectEnvironment.$$$reportNull$$$0(2);
        }
        assert (root.isDirectory());
        ((CoreJavaFileManager)this.myFileManager).addToClasspath(root);
        ((CorePackageIndex)this.myPackageIndex).addToClasspath(root);
        ((MockFileIndexFacade)this.myFileIndexFacade).addLibraryRoot(root);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationEnvironment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        objectArray2[1] = "ksp/com/intellij/core/JavaCoreProjectEnvironment";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addSourcesToClasspath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

