/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.jvm.codegen;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.backend.common.ErrorReportingContextKt;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import ksp.org.jetbrains.kotlin.backend.jvm.codegen.AnnotationCodegenKt;
import ksp.org.jetbrains.kotlin.backend.jvm.codegen.ClassCodegen;
import ksp.org.jetbrains.kotlin.backend.jvm.codegen.IrTypeAnnotationCollector;
import ksp.org.jetbrains.kotlin.backend.jvm.codegen.TypeAnnotationPosition;
import ksp.org.jetbrains.kotlin.backend.jvm.codegen.TypePathInfo;
import ksp.org.jetbrains.kotlin.backend.jvm.ir.IrJvmFlexibleTypeKt;
import ksp.org.jetbrains.kotlin.backend.jvm.ir.JvmIrTypeUtilsKt;
import ksp.org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import ksp.org.jetbrains.kotlin.backend.jvm.mapping.IrTypeMapper;
import ksp.org.jetbrains.kotlin.backend.jvm.mapping.IrTypeMappingKt;
import ksp.org.jetbrains.kotlin.backend.jvm.mapping.MethodSignatureMapper;
import ksp.org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import ksp.org.jetbrains.kotlin.descriptors.SourceElement;
import ksp.org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import ksp.org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import ksp.org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrConstructor;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import ksp.org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import ksp.org.jetbrains.kotlin.ir.declarations.IrField;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrProperty;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import ksp.org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import ksp.org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import ksp.org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import ksp.org.jetbrains.kotlin.ir.expressions.IrClassReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConst;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrVararg;
import ksp.org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import ksp.org.jetbrains.kotlin.ir.symbols.IrEnumEntrySymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrSymbol;
import ksp.org.jetbrains.kotlin.ir.types.IrType;
import ksp.org.jetbrains.kotlin.ir.types.IrTypeSystemContext;
import ksp.org.jetbrains.kotlin.ir.types.IrTypesKt;
import ksp.org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import ksp.org.jetbrains.kotlin.ir.util.IrTypeErasureUtilsKt;
import ksp.org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;
import ksp.org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import ksp.org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import ksp.org.jetbrains.kotlin.load.kotlin.TypeMappingMode;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.name.StandardClassIds;
import ksp.org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import ksp.org.jetbrains.org.objectweb.asm.Type;
import ksp.org.jetbrains.org.objectweb.asm.TypePath;
import ksp.org.jetbrains.org.objectweb.asm.TypeReference;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 :2\u00020\u0001:\u0001:B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH&J\"\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000e2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0015\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b J\u0018\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0012H\u0002J\u000e\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020'J$\u0010(\u001a\u0004\u0018\u00010\u000e2\u0006\u0010)\u001a\u00020\u00152\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010*\u001a\u00020\u001aH\u0002J\u0018\u0010+\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u00152\u0006\u0010,\u001a\u00020\u0017H\u0002J\u001a\u0010-\u001a\u00020\u000e2\b\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u000201H\u0002J\"\u00102\u001a\u00020\u00102\b\u00103\u001a\u0004\u0018\u00010\u000e2\u0006\u0010&\u001a\u00020'2\u0006\u0010,\u001a\u00020\u0017H\u0002J\u001d\u00104\u001a\u00020\u00102\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0000\u00a2\u0006\u0002\b9R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/codegen/AnnotationCodegen;", "", "classCodegen", "Lksp/org/jetbrains/kotlin/backend/jvm/codegen/ClassCodegen;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/codegen/ClassCodegen;)V", "context", "Lksp/org/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "typeMapper", "Lksp/org/jetbrains/kotlin/backend/jvm/mapping/IrTypeMapper;", "methodSignatureMapper", "Lksp/org/jetbrains/kotlin/backend/jvm/mapping/MethodSignatureMapper;", "annotationDescriptorsAlreadyPresent", "", "", "genAnnotations", "", "annotated", "Lksp/org/jetbrains/kotlin/ir/declarations/IrDeclaration;", "annotations", "", "Lksp/org/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "visitAnnotation", "Lksp/org/jetbrains/org/objectweb/asm/AnnotationVisitor;", "descr", "visible", "", "visitTypeAnnotation", "path", "Lksp/org/jetbrains/org/objectweb/asm/TypePath;", "generateNullabilityAnnotation", "declaration", "generateNullabilityAnnotation$backend_jvm_codegen", "isMovedReceiverParameterOfStaticValueClassReplacement", "parameter", "Lksp/org/jetbrains/kotlin/ir/declarations/IrValueParameter;", "parent", "generateAnnotationDefaultValue", "value", "Lksp/org/jetbrains/kotlin/ir/expressions/IrExpression;", "genAnnotation", "annotation", "isTypeAnnotation", "genAnnotationArguments", "annotationVisitor", "getAnnotationArgumentJvmName", "annotationClass", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "parameterName", "Lksp/org/jetbrains/kotlin/name/Name;", "genCompileTimeValue", "name", "generateTypeAnnotations", "type", "Lksp/org/jetbrains/kotlin/ir/types/IrType;", "position", "Lksp/org/jetbrains/kotlin/backend/jvm/codegen/TypeAnnotationPosition;", "generateTypeAnnotations$backend_jvm_codegen", "Companion", "backend.jvm.codegen"})
@SourceDebugExtension(value={"SMAP\nAnnotationCodegen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotationCodegen.kt\norg/jetbrains/kotlin/backend/jvm/codegen/AnnotationCodegen\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,400:1\n669#2,11:401\n1#3:412\n*S KotlinDebug\n*F\n+ 1 AnnotationCodegen.kt\norg/jetbrains/kotlin/backend/jvm/codegen/AnnotationCodegen\n*L\n210#1:401,11\n*E\n"})
public abstract class AnnotationCodegen {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClassCodegen classCodegen;
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final IrTypeMapper typeMapper;
    @NotNull
    private final MethodSignatureMapper methodSignatureMapper;
    @NotNull
    private final Set<String> annotationDescriptorsAlreadyPresent;
    @NotNull
    private static final Map<KotlinRetention, RetentionPolicy> annotationRetentionMap;

    public AnnotationCodegen(@NotNull ClassCodegen classCodegen) {
        Intrinsics.checkNotNullParameter((Object)classCodegen, (String)"classCodegen");
        this.classCodegen = classCodegen;
        this.context = this.classCodegen.getContext();
        this.typeMapper = this.classCodegen.getTypeMapper();
        this.methodSignatureMapper = this.classCodegen.getMethodSignatureMapper();
        this.annotationDescriptorsAlreadyPresent = new LinkedHashSet();
    }

    public final void genAnnotations(@NotNull IrDeclaration annotated, @NotNull List<? extends IrConstructorCall> annotations2) {
        Intrinsics.checkNotNullParameter((Object)annotated, (String)"annotated");
        Intrinsics.checkNotNullParameter(annotations2, (String)"annotations");
        for (IrConstructorCall irConstructorCall : annotations2) {
            String descriptor2;
            boolean bl2;
            Set applicableTargets;
            Set set = AdditionalIrUtilsKt.getAnnotationTargets(Companion.getAnnotationClass(irConstructorCall));
            if (set == null) {
                set = applicableTargets = SetsKt.emptySet();
            }
            if (annotated instanceof IrSimpleFunction && annotated.getOrigin() == IrDeclarationOrigin.Companion.getLOCAL_FUNCTION_FOR_LAMBDA() && !applicableTargets.contains((Object)KotlinTarget.FUNCTION) && !applicableTargets.contains((Object)KotlinTarget.PROPERTY_GETTER) && !applicableTargets.contains((Object)KotlinTarget.PROPERTY_SETTER)) {
                if (Intrinsics.areEqual((Object)irConstructorCall.getSource(), (Object)SourceElement.NO_SOURCE)) {
                    ErrorReportingContextKt.report(this.context, CompilerMessageSeverity.WARNING, annotated, IrUtilsKt.getFileOrNull(annotated), "Inconsistent target list for lambda annotation: +" + AdditionalIrUtilsKt.getKotlinFqName(Companion.getAnnotationClass(irConstructorCall)) + ' ' + applicableTargets + " on " + AdditionalIrUtilsKt.getKotlinFqName((IrDeclarationParent)((Object)annotated)));
                } else {
                    bl2 = applicableTargets.contains((Object)KotlinTarget.EXPRESSION);
                    if (!_Assertions.ENABLED || bl2) continue;
                    boolean $i$a$-assert-AnnotationCodegen$genAnnotations$332 = false;
                    String $i$a$-assert-AnnotationCodegen$genAnnotations$332 = "Inconsistent target list for lambda annotation: " + applicableTargets + " on " + annotated;
                    throw new AssertionError((Object)$i$a$-assert-AnnotationCodegen$genAnnotations$332);
                }
            }
            if (annotated instanceof IrClass && Intrinsics.areEqual((Object)((IrClass)annotated).getVisibility(), (Object)DescriptorVisibilities.LOCAL) && !applicableTargets.contains((Object)KotlinTarget.CLASS) && !applicableTargets.contains((Object)KotlinTarget.ANNOTATION_CLASS)) {
                bl2 = applicableTargets.contains((Object)KotlinTarget.EXPRESSION);
                if (!_Assertions.ENABLED || bl2) continue;
                boolean bl3 = false;
                String string = "Inconsistent target list for object literal annotation: " + applicableTargets + " on " + annotated;
                throw new AssertionError((Object)string);
            }
            if (this.genAnnotation(irConstructorCall, null, false) == null) continue;
            boolean bl4 = false;
            this.annotationDescriptorsAlreadyPresent.add(descriptor2);
        }
    }

    public static /* synthetic */ void genAnnotations$default(AnnotationCodegen annotationCodegen2, IrDeclaration irDeclaration, List list, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: genAnnotations");
        }
        if ((n2 & 2) != 0) {
            list = irDeclaration.getAnnotations();
        }
        annotationCodegen2.genAnnotations(irDeclaration, list);
    }

    @NotNull
    public abstract AnnotationVisitor visitAnnotation(@NotNull String var1, boolean var2);

    @NotNull
    public AnnotationVisitor visitTypeAnnotation(@NotNull String descr, @Nullable TypePath path, boolean visible) {
        Intrinsics.checkNotNullParameter((Object)descr, (String)"descr");
        throw new RuntimeException("Not implemented");
    }

    public final void generateNullabilityAnnotation$backend_jvm_codegen(@NotNull IrDeclaration declaration2) {
        IrType irType;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        if (AnnotationCodegen.Companion.isInvisibleForNullabilityAnalysis(declaration2)) {
            return;
        }
        if (declaration2 instanceof IrValueParameter) {
            IrDeclarationParent irDeclarationParent = ((IrValueParameter)declaration2).getParent();
            Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
            IrDeclaration parent2 = (IrDeclaration)((Object)irDeclarationParent);
            if (AnnotationCodegen.Companion.isInvisibleForNullabilityAnalysis(parent2)) {
                return;
            }
            if (this.isMovedReceiverParameterOfStaticValueClassReplacement((IrValueParameter)declaration2, parent2)) {
                return;
            }
        }
        if (declaration2 instanceof IrSimpleFunction && ((IrSimpleFunction)declaration2).getCorrespondingPropertySymbol() != null && IrUtilsKt.isAnnotationClass(IrUtilsKt.getParentAsClass(declaration2))) {
            return;
        }
        IrDeclaration irDeclaration = declaration2;
        if (irDeclaration instanceof IrFunction) {
            irType = ((IrFunction)declaration2).getReturnType();
        } else if (irDeclaration instanceof IrValueDeclaration) {
            irType = ((IrValueDeclaration)declaration2).getType();
        } else if (irDeclaration instanceof IrField) {
            Object object = ((IrField)declaration2).getCorrespondingPropertySymbol();
            boolean bl2 = object != null && (object = (IrProperty)object.getOwner()) != null ? ((IrProperty)object).isLateinit() : false;
            if (bl2) {
                return;
            }
            irType = ((IrField)declaration2).getType();
        } else {
            return;
        }
        IrType type2 = irType;
        if (AnnotationCodegenKt.access$isBareTypeParameterWithNullableUpperBound(type2)) {
            return;
        }
        if (IrJvmFlexibleTypeKt.isWithFlexibleNullability(type2)) {
            return;
        }
        Class annotationClass = IrTypeUtilsKt.isNullable(type2) ? Nullable.class : NotNull.class;
        String descriptor2 = Type.getType(annotationClass).getDescriptor();
        if (!this.annotationDescriptorsAlreadyPresent.contains(descriptor2)) {
            Intrinsics.checkNotNull((Object)descriptor2);
            this.visitAnnotation(descriptor2, false).visitEnd();
        }
    }

    private final boolean isMovedReceiverParameterOfStaticValueClassReplacement(IrValueParameter parameter2, IrDeclaration parent2) {
        return (Intrinsics.areEqual((Object)parent2.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getSTATIC_INLINE_CLASS_REPLACEMENT()) || Intrinsics.areEqual((Object)parent2.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getSTATIC_MULTI_FIELD_VALUE_CLASS_REPLACEMENT())) && Intrinsics.areEqual((Object)parameter2.getOrigin(), (Object)IrDeclarationOrigin.Companion.getMOVED_DISPATCH_RECEIVER());
    }

    public final void generateAnnotationDefaultValue(@NotNull IrExpression value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        AnnotationVisitor visitor2 = this.visitAnnotation("", false);
        this.genCompileTimeValue(null, value2, visitor2);
        visitor2.visitEnd();
    }

    private final String genAnnotation(IrConstructorCall annotation, TypePath path, boolean isTypeAnnotation) {
        AnnotationVisitor annotationVisitor;
        FqName fqName;
        IrClass annotationClass = Companion.getAnnotationClass(annotation);
        RetentionPolicy retentionPolicy = AnnotationCodegen.Companion.getRetentionPolicy(annotationClass);
        if (retentionPolicy == RetentionPolicy.SOURCE && !this.context.getState().getClassBuilderMode().generateSourceRetentionAnnotations) {
            return null;
        }
        FqName fqName2 = fqName = IrUtilsKt.getFqNameWhenAvailable(annotationClass);
        if (Intrinsics.areEqual((Object)(fqName2 != null ? fqName2.parent() : null), (Object)StandardClassIds.INSTANCE.getBASE_INTERNAL_IR_PACKAGE()) || Intrinsics.areEqual((Object)fqName, (Object)JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION)) {
            return null;
        }
        if (JvmIrUtilsKt.isOptionalAnnotationClass(annotationClass)) {
            return null;
        }
        this.classCodegen.addInnerClassInfo(annotationClass);
        String asmTypeDescriptor = IrTypeMapper.mapType$default(this.typeMapper, annotation.getType(), null, null, false, 14, null).getDescriptor();
        if (!isTypeAnnotation) {
            Intrinsics.checkNotNull((Object)asmTypeDescriptor);
            annotationVisitor = this.visitAnnotation(asmTypeDescriptor, retentionPolicy == RetentionPolicy.RUNTIME);
        } else {
            Intrinsics.checkNotNull((Object)asmTypeDescriptor);
            annotationVisitor = this.visitTypeAnnotation(asmTypeDescriptor, path, retentionPolicy == RetentionPolicy.RUNTIME);
        }
        AnnotationVisitor annotationVisitor2 = annotationVisitor;
        this.genAnnotationArguments(annotation, annotationVisitor2);
        annotationVisitor2.visitEnd();
        return asmTypeDescriptor;
    }

    private final void genAnnotationArguments(IrConstructorCall annotation, AnnotationVisitor annotationVisitor) {
        IrClass annotationClass = Companion.getAnnotationClass(annotation);
        for (IrValueParameter param : ((IrConstructor)annotation.getSymbol().getOwner()).getParameters()) {
            IrExpression value2 = annotation.getArguments().get(param);
            if (value2 != null) {
                this.genCompileTimeValue(this.getAnnotationArgumentJvmName(annotationClass, param.getName()), value2, annotationVisitor);
                continue;
            }
            if (param.getDefaultValue() != null || !this.context.getState().getClassBuilderMode().generateBodies) continue;
            throw new IllegalStateException(("No value for annotation parameter " + RenderIrElementKt.render$default(param, null, 1, null)).toString());
        }
    }

    private final String getAnnotationArgumentJvmName(IrClass annotationClass, Name parameterName) {
        Object v2;
        block5: {
            if (annotationClass == null) {
                String string = parameterName.asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                return string;
            }
            Iterable $this$singleOrNull$iv = annotationClass.getDeclarations();
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                Object object;
                IrDeclaration it = (IrDeclaration)element$iv;
                boolean bl2 = false;
                if (!(it instanceof IrSimpleFunction && Intrinsics.areEqual((object = ((IrSimpleFunction)it).getCorrespondingPropertySymbol()) != null && (object = (IrProperty)object.getOwner()) != null ? object.getName() : null, (Object)parameterName) || it instanceof IrProperty && Intrinsics.areEqual((Object)((IrProperty)it).getName(), (Object)parameterName))) continue;
                if (found$iv) {
                    v2 = null;
                    break block5;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v2 = !found$iv ? null : single$iv;
        }
        IrDeclaration irDeclaration = v2;
        if (irDeclaration == null) {
            String string = parameterName.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            return string;
        }
        IrDeclaration propertyOrGetter = irDeclaration;
        IrSimpleFunction irSimpleFunction = propertyOrGetter instanceof IrSimpleFunction ? (IrSimpleFunction)propertyOrGetter : null;
        if (irSimpleFunction == null && (irSimpleFunction = ((IrProperty)propertyOrGetter).getGetter()) == null) {
            throw new IllegalStateException(("No getter for annotation property: " + RenderIrElementKt.render$default(propertyOrGetter, null, 1, null)).toString());
        }
        IrSimpleFunction getter2 = irSimpleFunction;
        return MethodSignatureMapper.mapFunctionName$default(this.methodSignatureMapper, getter2, false, 2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void genCompileTimeValue(String name2, IrExpression value2, AnnotationVisitor annotationVisitor) {
        IrExpression irExpression = value2;
        if (irExpression instanceof IrConst) {
            annotationVisitor.visit(name2, ((IrConst)value2).getValue());
            return;
        }
        if (irExpression instanceof IrConstructorCall) {
            IrConstructor callee = (IrConstructor)((IrConstructorCall)value2).getSymbol().getOwner();
            if (!IrUtilsKt.isAnnotationClass(IrUtilsKt.getParentAsClass(callee))) throw new IllegalStateException(("Not supported as annotation! " + IrUtilsKt.ir2string(value2)).toString());
            IrType annotationClassType = callee.getReturnType();
            String internalAnnName = IrTypeMapper.mapType$default(this.typeMapper, annotationClassType, null, null, false, 14, null).getDescriptor();
            AnnotationVisitor visitor2 = annotationVisitor.visitAnnotation(name2, internalAnnName);
            Object object = IrTypesKt.getClassOrNull(annotationClassType);
            if (object != null && (object = (IrClass)object.getOwner()) != null) {
                Object object2 = object;
                ClassCodegen classCodegen = this.classCodegen;
                Object p0 = object2;
                boolean bl2 = false;
                classCodegen.addInnerClassInfo((IrClass)p0);
            }
            IrConstructorCall irConstructorCall = (IrConstructorCall)value2;
            Intrinsics.checkNotNull((Object)visitor2);
            this.genAnnotationArguments(irConstructorCall, visitor2);
            visitor2.visitEnd();
            return;
        }
        if (irExpression instanceof IrGetEnumValue) {
            IrEnumEntry enumEntry = (IrEnumEntry)((IrGetEnumValue)value2).getSymbol().getOwner();
            IrClass enumClass = IrUtilsKt.getParentAsClass(enumEntry);
            this.classCodegen.addInnerClassInfo(enumClass);
            annotationVisitor.visitEnum(name2, IrTypeMappingKt.mapClass(this.typeMapper, enumClass).getDescriptor(), enumEntry.getName().asString());
            return;
        }
        if (irExpression instanceof IrVararg) {
            AnnotationVisitor visitor3 = annotationVisitor.visitArray(name2);
            for (IrVarargElement element2 : ((IrVararg)value2).getElements()) {
                Intrinsics.checkNotNull((Object)element2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                IrExpression irExpression2 = (IrExpression)element2;
                Intrinsics.checkNotNull((Object)visitor3);
                this.genCompileTimeValue(null, irExpression2, visitor3);
            }
            visitor3.visitEnd();
            return;
        }
        if (irExpression instanceof IrClassReference) {
            IrType classType = ((IrClassReference)value2).getClassType();
            Object object = IrTypesKt.getClassOrNull(classType);
            if (object != null && (object = (IrClass)object.getOwner()) != null) {
                Object object3 = object;
                ClassCodegen classCodegen = this.classCodegen;
                Object p0 = object3;
                boolean bl3 = false;
                classCodegen.addInnerClassInfo((IrClass)p0);
            }
            Type mappedType = JvmIrTypeUtilsKt.isInlineClassType(classType) ? IrTypeMappingKt.mapClass(this.typeMapper, IrTypeErasureUtilsKt.getErasedUpperBound(classType)) : IrTypeMapper.mapType$default(this.typeMapper, classType, null, null, false, 14, null);
            annotationVisitor.visit(name2, mappedType);
            return;
        }
        if (!(irExpression instanceof IrErrorExpression)) throw new IllegalStateException(("Unsupported compile-time value " + IrUtilsKt.ir2string(value2)).toString());
        throw new IllegalStateException(("Don't know how to compile annotation value " + IrUtilsKt.ir2string(value2)).toString());
    }

    public final void generateTypeAnnotations$backend_jvm_codegen(@NotNull IrType type2, @NotNull TypeAnnotationPosition position) {
        TypeMappingMode typeMappingMode;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        if (!this.context.getConfig().getEmitJvmTypeAnnotations()) {
            return;
        }
        TypeAnnotationPosition typeAnnotationPosition = position;
        if (typeAnnotationPosition instanceof TypeAnnotationPosition.FunctionReturnType) {
            typeMappingMode = MethodSignatureMapper.Companion.getTypeMappingModeForReturnType(this.context.getTypeSystem(), ((TypeAnnotationPosition.FunctionReturnType)position).getFunction(), ((TypeAnnotationPosition.FunctionReturnType)position).getFunction().getReturnType());
        } else if (typeAnnotationPosition instanceof TypeAnnotationPosition.ValueParameterType) {
            IrTypeSystemContext irTypeSystemContext = this.context.getTypeSystem();
            IrDeclarationParent irDeclarationParent = ((TypeAnnotationPosition.ValueParameterType)position).getParameter().getParent();
            Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
            typeMappingMode = MethodSignatureMapper.Companion.getTypeMappingModeForParameter(irTypeSystemContext, (IrDeclaration)((Object)irDeclarationParent), type2);
        } else if (typeAnnotationPosition instanceof TypeAnnotationPosition.FieldType) {
            typeMappingMode = ((TypeAnnotationPosition.FieldType)position).getField().isFinal() ? MethodSignatureMapper.Companion.getTypeMappingModeForReturnType(this.context.getTypeSystem(), ((TypeAnnotationPosition.FieldType)position).getField(), ((TypeAnnotationPosition.FieldType)position).getField().getType()) : MethodSignatureMapper.Companion.getTypeMappingModeForParameter(this.context.getTypeSystem(), ((TypeAnnotationPosition.FieldType)position).getField(), ((TypeAnnotationPosition.FieldType)position).getField().getType());
        } else if (typeAnnotationPosition instanceof TypeAnnotationPosition.TypeParameterBoundType) {
            typeMappingMode = TypeMappingMode.GENERIC_ARGUMENT;
        } else if (typeAnnotationPosition instanceof TypeAnnotationPosition.Supertype) {
            typeMappingMode = TypeMappingMode.SUPER_TYPE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        TypeMappingMode mode = typeMappingMode;
        for (TypePathInfo typePathInfo : new IrTypeAnnotationCollector(this.context).collectTypeAnnotations(type2, mode)) {
            for (IrConstructorCall annotation : typePathInfo.getAnnotations()) {
                this.genAnnotation(annotation, typePathInfo.getPath(), true);
            }
        }
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)KotlinRetention.SOURCE), (Object)((Object)RetentionPolicy.SOURCE)), TuplesKt.to((Object)((Object)KotlinRetention.BINARY), (Object)((Object)RetentionPolicy.CLASS)), TuplesKt.to((Object)((Object)KotlinRetention.RUNTIME), (Object)((Object)RetentionPolicy.RUNTIME))};
        annotationRetentionMap = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0092\u0001\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2b\u0010\u000f\u001a^\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0015\u0012\u0013\u0018\u00010\u0014\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0019\u0012\u0004\u0012\u00020\u001a0\u0010J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020$H\u0002R\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010%\u001a\u00020$*\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006)"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/codegen/AnnotationCodegen$Companion;", "", "<init>", "()V", "genAnnotationsOnTypeParametersAndBounds", "", "context", "Lksp/org/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "typeParameterContainer", "Lksp/org/jetbrains/kotlin/ir/declarations/IrTypeParametersContainer;", "classCodegen", "Lksp/org/jetbrains/kotlin/backend/jvm/codegen/ClassCodegen;", "referenceType", "", "boundType", "visitor", "Lkotlin/Function4;", "Lkotlin/ParameterName;", "name", "typeRef", "Lksp/org/jetbrains/org/objectweb/asm/TypePath;", "typePath", "", "descriptor", "", "visible", "Lksp/org/jetbrains/org/objectweb/asm/AnnotationVisitor;", "isInvisibleForNullabilityAnalysis", "declaration", "Lksp/org/jetbrains/kotlin/ir/declarations/IrDeclaration;", "annotationRetentionMap", "", "Lksp/org/jetbrains/kotlin/descriptors/annotations/KotlinRetention;", "Ljava/lang/annotation/RetentionPolicy;", "getRetentionPolicy", "irClass", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "annotationClass", "Lksp/org/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "getAnnotationClass", "(Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;)Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "backend.jvm.codegen"})
    public static final class Companion {
        private Companion() {
        }

        public final void genAnnotationsOnTypeParametersAndBounds(@NotNull JvmBackendContext context2, @NotNull IrTypeParametersContainer typeParameterContainer, @NotNull ClassCodegen classCodegen, int referenceType, int boundType, @NotNull Function4<? super Integer, ? super TypePath, ? super String, ? super Boolean, ? extends AnnotationVisitor> visitor2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)typeParameterContainer, (String)"typeParameterContainer");
            Intrinsics.checkNotNullParameter((Object)classCodegen, (String)"classCodegen");
            Intrinsics.checkNotNullParameter(visitor2, (String)"visitor");
            Iterator iterator2 = ((Iterable)typeParameterContainer.getTypeParameters()).iterator();
            int n2 = 0;
            while (iterator2.hasNext()) {
                int index2 = n2++;
                IrTypeParameter typeParameter = (IrTypeParameter)iterator2.next();
                AnnotationCodegen.genAnnotations$default(new AnnotationCodegen(classCodegen, referenceType, index2, visitor2, typeParameterContainer){
                    final /* synthetic */ int $referenceType;
                    final /* synthetic */ int $index;
                    final /* synthetic */ Function4<Integer, TypePath, String, Boolean, AnnotationVisitor> $visitor;
                    final /* synthetic */ IrTypeParametersContainer $typeParameterContainer;
                    {
                        this.$referenceType = $referenceType;
                        this.$index = $index;
                        this.$visitor = $visitor;
                        this.$typeParameterContainer = $typeParameterContainer;
                        super($classCodegen);
                    }

                    public AnnotationVisitor visitAnnotation(String descr, boolean visible) {
                        Intrinsics.checkNotNullParameter((Object)descr, (String)"descr");
                        TypeReference typeReference = TypeReference.newTypeParameterReference(this.$referenceType, this.$index);
                        return (AnnotationVisitor)this.$visitor.invoke((Object)typeReference.getValue(), null, (Object)descr, (Object)visible);
                    }

                    public AnnotationVisitor visitTypeAnnotation(String descr, TypePath path, boolean visible) {
                        Intrinsics.checkNotNullParameter((Object)descr, (String)"descr");
                        throw new IllegalStateException(("Type annotation cannot be on a type parameter: " + RenderIrElementKt.render$default(this.$typeParameterContainer, null, 1, null)).toString());
                    }
                }, typeParameter, null, 2, null);
                if (!context2.getConfig().getEmitJvmTypeAnnotations()) continue;
                int superInterfaceIndex = 1;
                for (IrType superType : typeParameter.getSuperTypes()) {
                    boolean isClassOrTypeParameter = !IrTypeUtilsKt.isInterface(superType) && !IrTypeUtilsKt.isAnnotation(superType);
                    int superIndex = isClassOrTypeParameter ? 0 : superInterfaceIndex++;
                    new AnnotationCodegen(classCodegen, typeParameterContainer, boundType, index2, superIndex, visitor2){
                        final /* synthetic */ IrTypeParametersContainer $typeParameterContainer;
                        final /* synthetic */ int $boundType;
                        final /* synthetic */ int $index;
                        final /* synthetic */ int $superIndex;
                        final /* synthetic */ Function4<Integer, TypePath, String, Boolean, AnnotationVisitor> $visitor;
                        {
                            this.$typeParameterContainer = $typeParameterContainer;
                            this.$boundType = $boundType;
                            this.$index = $index;
                            this.$superIndex = $superIndex;
                            this.$visitor = $visitor;
                            super($classCodegen);
                        }

                        public AnnotationVisitor visitAnnotation(String descr, boolean visible) {
                            Intrinsics.checkNotNullParameter((Object)descr, (String)"descr");
                            throw new IllegalStateException(("Only type annotation can be on a type parameter bound: " + RenderIrElementKt.render$default(this.$typeParameterContainer, null, 1, null)).toString());
                        }

                        public AnnotationVisitor visitTypeAnnotation(String descr, TypePath path, boolean visible) {
                            Intrinsics.checkNotNullParameter((Object)descr, (String)"descr");
                            TypeReference typeReference = TypeReference.newTypeParameterBoundReference(this.$boundType, this.$index, this.$superIndex);
                            return (AnnotationVisitor)this.$visitor.invoke((Object)typeReference.getValue(), (Object)path, (Object)descr, (Object)visible);
                        }
                    }.generateTypeAnnotations$backend_jvm_codegen(superType, TypeAnnotationPosition.TypeParameterBoundType.INSTANCE);
                }
            }
        }

        private final boolean isInvisibleForNullabilityAnalysis(IrDeclaration declaration2) {
            IrDeclarationParent irDeclarationParent = declaration2.getParent();
            IrClass irClass = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
            return (irClass != null ? AdditionalIrUtilsKt.isLocal(irClass) : false) ? true : (declaration2.getOrigin().isSynthetic() ? true : Intrinsics.areEqual((Object)declaration2.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getINLINE_CLASS_GENERATED_IMPL_METHOD()) || Intrinsics.areEqual((Object)declaration2.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getMULTI_FIELD_VALUE_CLASS_GENERATED_IMPL_METHOD()) || Intrinsics.areEqual((Object)declaration2.getOrigin(), (Object)IrDeclarationOrigin.Companion.getGENERATED_SAM_IMPLEMENTATION()));
        }

        private final RetentionPolicy getRetentionPolicy(IrClass irClass) {
            KotlinRetention retention = IrUtilsKt.getAnnotationRetention(irClass);
            if (retention != null) {
                Object v2 = annotationRetentionMap.get((Object)retention);
                Intrinsics.checkNotNull(v2);
                return (RetentionPolicy)((Object)v2);
            }
            IrAnnotationContainer irAnnotationContainer = irClass;
            String string = Retention.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation(irAnnotationContainer, new FqName(string));
            if (irConstructorCall != null) {
                IrSymbol symbol;
                IrConstructorCall retentionAnnotation = irConstructorCall;
                boolean bl2 = false;
                IrExpression value2 = (IrExpression)retentionAnnotation.getArguments().get(0);
                if (value2 instanceof IrDeclarationReference && (symbol = ((IrDeclarationReference)value2).getSymbol()) instanceof IrEnumEntrySymbol) {
                    IrEnumEntry entry = (IrEnumEntry)((IrEnumEntrySymbol)symbol).getOwner();
                    FqName enumClassFqName = IrUtilsKt.getFqNameWhenAvailable(IrUtilsKt.getParentAsClass(entry));
                    FqName fqName = enumClassFqName;
                    if (Intrinsics.areEqual((Object)RetentionPolicy.class.getName(), (Object)(fqName != null ? fqName.asString() : null))) {
                        String string2 = entry.getName().asString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
                        return RetentionPolicy.valueOf(string2);
                    }
                }
            }
            return RetentionPolicy.RUNTIME;
        }

        @NotNull
        public final IrClass getAnnotationClass(@NotNull IrConstructorCall $this$annotationClass) {
            Intrinsics.checkNotNullParameter((Object)$this$annotationClass, (String)"<this>");
            return IrUtilsKt.getParentAsClass($this$annotationClass.getSymbol().getOwner());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

