/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.source.resolve;

import java.util.function.Predicate;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.pom.java.LanguageLevel;
import ksp.com.intellij.psi.JavaModuleSystem;
import ksp.com.intellij.psi.JavaPsiFacade;
import ksp.com.intellij.psi.JavaResolveResult;
import ksp.com.intellij.psi.PsiAnonymousClass;
import ksp.com.intellij.psi.PsiCallExpression;
import ksp.com.intellij.psi.PsiClass;
import ksp.com.intellij.psi.PsiClassType;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiExpression;
import ksp.com.intellij.psi.PsiExpressionList;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.PsiImplicitClass;
import ksp.com.intellij.psi.PsiInferenceHelper;
import ksp.com.intellij.psi.PsiJavaCodeReferenceElement;
import ksp.com.intellij.psi.PsiJavaParserFacade;
import ksp.com.intellij.psi.PsiManager;
import ksp.com.intellij.psi.PsiMember;
import ksp.com.intellij.psi.PsiMethod;
import ksp.com.intellij.psi.PsiMethodCallExpression;
import ksp.com.intellij.psi.PsiModifierList;
import ksp.com.intellij.psi.PsiNewExpression;
import ksp.com.intellij.psi.PsiPackage;
import ksp.com.intellij.psi.PsiParameter;
import ksp.com.intellij.psi.PsiReferenceExpression;
import ksp.com.intellij.psi.PsiResolveHelper;
import ksp.com.intellij.psi.PsiSubstitutor;
import ksp.com.intellij.psi.PsiType;
import ksp.com.intellij.psi.PsiTypeParameter;
import ksp.com.intellij.psi.PsiVariable;
import ksp.com.intellij.psi.ResolveState;
import ksp.com.intellij.psi.impl.JavaPsiImplementationHelper;
import ksp.com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import ksp.com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import ksp.com.intellij.psi.impl.source.resolve.PsiOldInferenceHelper;
import ksp.com.intellij.psi.impl.source.resolve.ResolveClassUtil;
import ksp.com.intellij.psi.impl.source.resolve.ResolveVariableUtil;
import ksp.com.intellij.psi.impl.source.resolve.graphInference.PsiGraphInferenceHelper;
import ksp.com.intellij.psi.infos.CandidateInfo;
import ksp.com.intellij.psi.infos.MethodCandidateInfo;
import ksp.com.intellij.psi.scope.MethodProcessorSetupFailedException;
import ksp.com.intellij.psi.scope.PsiConflictResolver;
import ksp.com.intellij.psi.scope.conflictResolvers.DuplicateConflictResolver;
import ksp.com.intellij.psi.scope.processor.MethodCandidatesProcessor;
import ksp.com.intellij.psi.scope.processor.MethodResolverProcessor;
import ksp.com.intellij.psi.scope.util.PsiScopesUtil;
import ksp.com.intellij.psi.util.PsiTreeUtil;
import ksp.com.intellij.psi.util.PsiUtil;
import ksp.com.intellij.util.IncorrectOperationException;
import ksp.com.intellij.util.SmartList;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public class PsiResolveHelperImpl
implements PsiResolveHelper {
    private static final Logger LOG = Logger.getInstance(PsiResolveHelperImpl.class);
    private final PsiManager myManager;

    public PsiResolveHelperImpl(@NotNull Project project) {
        if (project == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(0);
        }
        this.myManager = PsiManager.getInstance(project);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public PsiResolveHelperImpl(@NotNull PsiManager manager) {
        if (manager == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(1);
        }
        this.myManager = manager;
    }

    @Override
    @NotNull
    public JavaResolveResult resolveConstructor(PsiClassType classType, @NotNull PsiExpressionList argumentList, PsiElement place) {
        JavaResolveResult[] result2;
        if (argumentList == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(2);
        }
        JavaResolveResult javaResolveResult = (result2 = this.multiResolveConstructor(classType, argumentList, place)).length == 1 ? result2[0] : JavaResolveResult.EMPTY;
        if (javaResolveResult == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(3);
        }
        return javaResolveResult;
    }

    @Override
    public JavaResolveResult @NotNull [] multiResolveConstructor(@NotNull PsiClassType type2, @NotNull PsiExpressionList argumentList, @NotNull PsiElement place) {
        MethodResolverProcessor processor;
        PsiClassType.ClassResolveResult classResolveResult;
        PsiClass aClass;
        if (type2 == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(4);
        }
        if (argumentList == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(5);
        }
        if (place == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(6);
        }
        if ((aClass = (classResolveResult = type2.resolveGenerics()).getElement()) == null) {
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                PsiResolveHelperImpl.$$$reportNull$$$0(7);
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        PsiSubstitutor substitutor2 = classResolveResult.getSubstitutor();
        if (argumentList.getParent() instanceof PsiAnonymousClass) {
            PsiAnonymousClass anonymous = (PsiAnonymousClass)argumentList.getParent();
            processor = new MethodResolverProcessor(anonymous, argumentList, place, place.getContainingFile());
            aClass = anonymous.getBaseClassType().resolve();
            if (aClass == null) {
                if (JavaResolveResult.EMPTY_ARRAY == null) {
                    PsiResolveHelperImpl.$$$reportNull$$$0(8);
                }
                return JavaResolveResult.EMPTY_ARRAY;
            }
        } else {
            processor = new MethodResolverProcessor(null, argumentList, place, place.getContainingFile());
        }
        ResolveState state = ResolveState.initial().put(PsiSubstitutor.KEY, substitutor2);
        for (PsiMethod constructor : aClass.getConstructors()) {
            if (!processor.execute(constructor, state)) break;
        }
        JavaResolveResult[] javaResolveResultArray = processor.getResult();
        if (javaResolveResultArray == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(9);
        }
        return javaResolveResultArray;
    }

    @Override
    public PsiClass resolveReferencedClass(@NotNull String referenceText, PsiElement context2) {
        if (referenceText == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(10);
        }
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(this.myManager.getProject()).getParserFacade();
        try {
            PsiJavaCodeReferenceElement ref = parserFacade.createReferenceFromText(referenceText, context2);
            PsiFile containingFile2 = ref.getContainingFile();
            LOG.assertTrue(containingFile2.isValid(), referenceText);
            return ResolveClassUtil.resolveClass(ref, containingFile2);
        }
        catch (IncorrectOperationException e2) {
            return null;
        }
    }

    @Override
    public PsiVariable resolveReferencedVariable(@NotNull String referenceText, PsiElement context2) {
        if (referenceText == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(11);
        }
        return this.resolveVar(referenceText, context2, null);
    }

    @Override
    public PsiVariable resolveAccessibleReferencedVariable(@NotNull String referenceText, PsiElement context2) {
        if (referenceText == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(12);
        }
        boolean[] problemWithAccess = new boolean[1];
        PsiVariable variable = this.resolveVar(referenceText, context2, problemWithAccess);
        return problemWithAccess[0] ? null : variable;
    }

    @Nullable
    private PsiVariable resolveVar(@NotNull String referenceText, PsiElement context2, boolean[] problemWithAccess) {
        if (referenceText == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(13);
        }
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(this.myManager.getProject()).getParserFacade();
        try {
            PsiJavaCodeReferenceElement ref = parserFacade.createReferenceFromText(referenceText, context2);
            return ResolveVariableUtil.resolveVariable(ref, problemWithAccess, null);
        }
        catch (IncorrectOperationException e2) {
            return null;
        }
    }

    @Override
    public boolean isAccessible(@NotNull PsiMember member, @NotNull PsiElement place, @Nullable PsiClass accessObjectClass) {
        if (member == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(14);
        }
        if (place == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(15);
        }
        return this.isAccessible(member, member.getModifierList(), place, accessObjectClass, null);
    }

    @Override
    public boolean isAccessible(@NotNull PsiMember member, @Nullable PsiModifierList modifierList2, @NotNull PsiElement place, @Nullable PsiClass accessObjectClass, @Nullable PsiElement currentFileResolveScope) {
        PsiClass containingClass;
        boolean accessible;
        if (member == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(16);
        }
        if (place == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(17);
        }
        if ((accessible = JavaResolveUtil.isAccessible(member, containingClass = member.getContainingClass(), modifierList2, place, accessObjectClass, currentFileResolveScope)) && member instanceof PsiClass && !(member instanceof PsiTypeParameter)) {
            accessible = PsiResolveHelperImpl.isAccessible(moduleSystem -> moduleSystem.isAccessible((PsiClass)member, place));
        }
        if (PsiResolveHelperImpl.fromImplicitClassOutsideThisClass(member, place)) {
            return false;
        }
        return accessible;
    }

    private static boolean fromImplicitClassOutsideThisClass(@NotNull PsiMember member, @NotNull PsiElement place) {
        PsiImplicitClass implicitClass;
        if (member == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(18);
        }
        if (place == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(19);
        }
        if ((implicitClass = PsiTreeUtil.getParentOfType((PsiElement)member, PsiImplicitClass.class)) == null) {
            return false;
        }
        PsiImplicitClass placeImplicitClass = PsiTreeUtil.getParentOfType(place, PsiImplicitClass.class);
        if (placeImplicitClass == null) {
            return true;
        }
        return !member.getManager().areElementsEquivalent(implicitClass, placeImplicitClass);
    }

    @Override
    public boolean isAccessible(@NotNull PsiPackage pkg, @NotNull PsiElement place) {
        if (pkg == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(20);
        }
        if (place == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(21);
        }
        return PsiResolveHelperImpl.isAccessible(moduleSystem -> moduleSystem.isAccessible(pkg.getQualifiedName(), null, place));
    }

    private static boolean isAccessible(Predicate<? super JavaModuleSystem> predicate) {
        for (JavaModuleSystem t2 : JavaModuleSystem.EP_NAME.getExtensionList()) {
            if (predicate.test(t2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public CandidateInfo @NotNull [] getReferencedMethodCandidates(@NotNull PsiCallExpression expr, boolean dummyImplicitConstructor, final boolean checkVarargs) {
        if (expr == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(22);
        }
        PsiFile containingFile2 = expr.getContainingFile();
        MethodCandidatesProcessor processor = new MethodCandidatesProcessor(expr, containingFile2, new PsiConflictResolver[]{DuplicateConflictResolver.INSTANCE}, new SmartList()){

            @Override
            protected boolean acceptVarargs() {
                return checkVarargs;
            }
        };
        try {
            PsiScopesUtil.setupAndRunProcessor(processor, expr, dummyImplicitConstructor);
        }
        catch (MethodProcessorSetupFailedException e2) {
            if (CandidateInfo.EMPTY_ARRAY == null) {
                PsiResolveHelperImpl.$$$reportNull$$$0(23);
            }
            return CandidateInfo.EMPTY_ARRAY;
        }
        CandidateInfo[] candidateInfoArray = processor.getCandidates();
        if (candidateInfoArray == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(24);
        }
        return candidateInfoArray;
    }

    @Override
    public boolean hasOverloads(@NotNull PsiCallExpression call2) {
        PsiJavaCodeReferenceElement classReference;
        if (call2 == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(25);
        }
        PsiFile containingFile2 = call2.getContainingFile();
        MethodCandidatesProcessor processor = new MethodCandidatesProcessor(call2, containingFile2, new PsiConflictResolver[0], new SmartList()){

            @Override
            protected boolean acceptVarargs() {
                return true;
            }
        };
        if (call2 instanceof PsiMethodCallExpression) {
            PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)call2).getMethodExpression();
            processor.setIsConstructor(false);
            processor.setName(methodExpression.getReferenceName());
            PsiScopesUtil.resolveAndWalk(processor, methodExpression, null);
        } else if (call2 instanceof PsiNewExpression && (classReference = ((PsiNewExpression)call2).getClassOrAnonymousClassReference()) != null) {
            processor.setIsConstructor(true);
            processor.setName(classReference.getReferenceName());
            PsiScopesUtil.resolveAndWalk(processor, classReference, null);
        }
        return processor.getCandidates().length > 1;
    }

    @Override
    public CandidateInfo @NotNull [] getReferencedMethodCandidates(@NotNull PsiCallExpression call2, boolean dummyImplicitConstructor) {
        if (call2 == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(26);
        }
        CandidateInfo[] candidateInfoArray = this.getReferencedMethodCandidates(call2, dummyImplicitConstructor, false);
        if (candidateInfoArray == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(27);
        }
        return candidateInfoArray;
    }

    @Override
    public PsiType inferTypeForMethodTypeParameter(@NotNull PsiTypeParameter typeParameter, PsiParameter @NotNull [] parameters2, PsiExpression @NotNull [] arguments2, @NotNull PsiSubstitutor partialSubstitutor, @Nullable PsiElement parent2, @NotNull ParameterTypeInferencePolicy policy) {
        if (typeParameter == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(28);
        }
        if (partialSubstitutor == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(29);
        }
        if (policy == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(30);
        }
        if (parameters2 == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(31);
        }
        if (arguments2 == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(32);
        }
        return this.getInferenceHelper(PsiUtil.getLanguageLevel(parent2 != null ? parent2 : typeParameter)).inferTypeForMethodTypeParameter(typeParameter, parameters2, arguments2, partialSubstitutor, parent2, policy);
    }

    @Override
    @NotNull
    public PsiSubstitutor inferTypeArguments(PsiTypeParameter @NotNull [] typeParameters2, PsiParameter @NotNull [] parameters2, PsiExpression @NotNull [] arguments2, @NotNull PsiSubstitutor partialSubstitutor, @NotNull PsiElement parent2, @NotNull ParameterTypeInferencePolicy policy) {
        if (partialSubstitutor == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(33);
        }
        if (parent2 == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(34);
        }
        if (policy == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(35);
        }
        if (typeParameters2 == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(36);
        }
        if (parameters2 == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(37);
        }
        if (arguments2 == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(38);
        }
        PsiSubstitutor psiSubstitutor = this.getInferenceHelper(PsiUtil.getLanguageLevel(parent2)).inferTypeArguments(typeParameters2, parameters2, arguments2, null, partialSubstitutor, parent2, policy, PsiUtil.getLanguageLevel(parent2));
        if (psiSubstitutor == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(39);
        }
        return psiSubstitutor;
    }

    @Override
    @NotNull
    public PsiSubstitutor inferTypeArguments(PsiTypeParameter @NotNull [] typeParameters2, PsiParameter @NotNull [] parameters2, PsiExpression @NotNull [] arguments2, @NotNull MethodCandidateInfo currentCandidate, @NotNull PsiElement parent2, @NotNull ParameterTypeInferencePolicy policy, @NotNull LanguageLevel languageLevel) {
        if (currentCandidate == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(40);
        }
        if (parent2 == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(41);
        }
        if (policy == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(42);
        }
        if (languageLevel == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(43);
        }
        if (typeParameters2 == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(44);
        }
        if (parameters2 == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(45);
        }
        if (arguments2 == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(46);
        }
        PsiSubstitutor psiSubstitutor = this.getInferenceHelper(languageLevel).inferTypeArguments(typeParameters2, parameters2, arguments2, currentCandidate, currentCandidate.getSiteSubstitutor(), parent2, policy, languageLevel);
        if (psiSubstitutor == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(47);
        }
        return psiSubstitutor;
    }

    @Override
    @NotNull
    public PsiSubstitutor inferTypeArguments(PsiTypeParameter @NotNull [] typeParameters2, PsiType @NotNull [] leftTypes, PsiType @NotNull [] rightTypes, @NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(48);
        }
        if (typeParameters2 == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(49);
        }
        if (leftTypes == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(50);
        }
        if (rightTypes == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(51);
        }
        PsiSubstitutor psiSubstitutor = this.inferTypeArguments(typeParameters2, leftTypes, rightTypes, PsiSubstitutor.EMPTY, languageLevel);
        if (psiSubstitutor == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(52);
        }
        return psiSubstitutor;
    }

    @Override
    @NotNull
    public PsiSubstitutor inferTypeArguments(PsiTypeParameter @NotNull [] typeParameters2, PsiType @NotNull [] leftTypes, PsiType @NotNull [] rightTypes, @NotNull PsiSubstitutor partialSubstitutor, @NotNull LanguageLevel languageLevel) {
        if (partialSubstitutor == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(53);
        }
        if (languageLevel == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(54);
        }
        if (typeParameters2 == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(55);
        }
        if (leftTypes == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(56);
        }
        if (rightTypes == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(57);
        }
        PsiSubstitutor psiSubstitutor = this.getInferenceHelper(languageLevel).inferTypeArguments(typeParameters2, leftTypes, rightTypes, partialSubstitutor, languageLevel);
        if (psiSubstitutor == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(58);
        }
        return psiSubstitutor;
    }

    @Override
    public PsiType getSubstitutionForTypeParameter(PsiTypeParameter typeParam, PsiType param, PsiType arg, boolean isContraVariantPosition, LanguageLevel languageLevel) {
        return this.getInferenceHelper(languageLevel).getSubstitutionForTypeParameter(typeParam, param, arg, isContraVariantPosition, languageLevel);
    }

    @Override
    @NotNull
    public LanguageLevel getEffectiveLanguageLevel(@Nullable VirtualFile virtualFile) {
        LanguageLevel languageLevel = JavaPsiImplementationHelper.getInstance(this.myManager.getProject()).getEffectiveLanguageLevel(virtualFile);
        if (languageLevel == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(59);
        }
        return languageLevel;
    }

    @NotNull
    public PsiInferenceHelper getInferenceHelper(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(60);
        }
        if (languageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
            return new PsiGraphInferenceHelper(this.myManager);
        }
        return new PsiOldInferenceHelper(this.myManager);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 23: 
            case 24: 
            case 27: 
            case 39: 
            case 47: 
            case 52: 
            case 58: 
            case 59: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 23: 
            case 24: 
            case 27: 
            case 39: 
            case 47: 
            case 52: 
            case 58: 
            case 59: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 23: 
            case 24: 
            case 27: 
            case 39: 
            case 47: 
            case 52: 
            case 58: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceText";
                break;
            }
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 29: 
            case 33: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partialSubstitutor";
                break;
            }
            case 30: 
            case 35: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 31: 
            case 37: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 32: 
            case 38: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 34: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 36: 
            case 44: 
            case 49: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentCandidate";
                break;
            }
            case 43: 
            case 48: 
            case 54: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 50: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftTypes";
                break;
            }
            case 51: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightTypes";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveConstructor";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveConstructor";
                break;
            }
            case 23: 
            case 24: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedMethodCandidates";
                break;
            }
            case 39: 
            case 47: 
            case 52: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "inferTypeArguments";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveLanguageLevel";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveConstructor";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 23: 
            case 24: 
            case 27: 
            case 39: 
            case 47: 
            case 52: 
            case 58: 
            case 59: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveConstructor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferencedClass";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferencedVariable";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resolveAccessibleReferencedVariable";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveVar";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isAccessible";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "fromImplicitClassOutsideThisClass";
                break;
            }
            case 22: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getReferencedMethodCandidates";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "hasOverloads";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "inferTypeForMethodTypeParameter";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "inferTypeArguments";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getInferenceHelper";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 23: 
            case 24: 
            case 27: 
            case 39: 
            case 47: 
            case 52: 
            case 58: 
            case 59: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

