/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.editor.impl.event;

import java.util.ArrayList;
import ksp.com.intellij.openapi.editor.Document;
import ksp.com.intellij.openapi.editor.event.DocumentEvent;
import ksp.com.intellij.openapi.editor.ex.LineIterator;
import ksp.com.intellij.openapi.editor.impl.LineSet;
import ksp.com.intellij.util.ArrayUtil;
import ksp.com.intellij.util.diff.Diff;
import ksp.com.intellij.util.diff.FilesTooBigForDiffException;
import ksp.com.intellij.util.text.MergingCharSequence;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;

public class DocumentEventImpl
extends DocumentEvent {
    private final int myOffset;
    @NotNull
    private final CharSequence myOldString;
    private final int myOldLength;
    @NotNull
    private final CharSequence myNewString;
    private final int myNewLength;
    private final long myOldTimeStamp;
    private final boolean myIsWholeDocReplaced;
    private Diff.Change myChange;
    private static final Diff.Change TOO_BIG_FILE = new Diff.Change(0, 0, 0, 0, null);
    private final int myInitialStartOffset;
    private final int myInitialOldLength;
    private final int myMoveOffset;
    private LineSet myOldFragmentLineSet;
    private int myOldFragmentLineSetStart;

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    public DocumentEventImpl(@NotNull Document document, int offset, @NotNull CharSequence oldString, @NotNull CharSequence newString, long oldTimeStamp, boolean wholeTextReplaced, int initialStartOffset, int initialOldLength, int n2) {
        void moveOffset;
        if (document == null) {
            DocumentEventImpl.$$$reportNull$$$0(0);
        }
        if (oldString == null) {
            DocumentEventImpl.$$$reportNull$$$0(1);
        }
        if (newString == null) {
            DocumentEventImpl.$$$reportNull$$$0(2);
        }
        super(document);
        this.myOffset = offset;
        this.myOldString = oldString;
        this.myOldLength = oldString.length();
        this.myNewString = newString;
        this.myNewLength = newString.length();
        this.myInitialStartOffset = initialStartOffset;
        this.myInitialOldLength = initialOldLength;
        this.myMoveOffset = moveOffset;
        this.myOldTimeStamp = oldTimeStamp;
        boolean bl2 = this.myIsWholeDocReplaced = this.getDocument().getTextLength() != 0 && wholeTextReplaced;
        assert (initialStartOffset >= 0) : initialStartOffset;
        assert (initialOldLength >= 0) : initialOldLength;
        assert (moveOffset == offset || this.myOldLength == 0 || this.myNewLength == 0) : this;
    }

    @Override
    public int getOffset() {
        return this.myOffset;
    }

    @Override
    public int getOldLength() {
        return this.myOldLength;
    }

    @Override
    public int getNewLength() {
        return this.myNewLength;
    }

    @Override
    @NotNull
    public CharSequence getOldFragment() {
        CharSequence charSequence = this.myOldString;
        if (charSequence == null) {
            DocumentEventImpl.$$$reportNull$$$0(3);
        }
        return charSequence;
    }

    @Override
    @NotNull
    public CharSequence getNewFragment() {
        CharSequence charSequence = this.myNewString;
        if (charSequence == null) {
            DocumentEventImpl.$$$reportNull$$$0(4);
        }
        return charSequence;
    }

    public int getInitialStartOffset() {
        return this.myInitialStartOffset;
    }

    public int getInitialOldLength() {
        return this.myInitialOldLength;
    }

    @Override
    public int getMoveOffset() {
        return this.myMoveOffset;
    }

    @Override
    public long getOldTimeStamp() {
        return this.myOldTimeStamp;
    }

    @Override
    public String toString() {
        return "DocumentEventImpl[myOffset=" + this.myOffset + ", myOldLength=" + this.myOldLength + ", myNewLength=" + this.myNewLength + "]" + (this.isWholeTextReplaced() ? " Whole." : ".");
    }

    @Override
    public boolean isWholeTextReplaced() {
        return this.myIsWholeDocReplaced;
    }

    public int translateLineViaDiff(int line) throws FilesTooBigForDiffException {
        Diff.Change change = this.reBuildDiffIfNeeded();
        if (change == null) {
            return line;
        }
        int startLine = this.getDocument().getLineNumber(this.getOffset());
        int newLine = line -= startLine;
        while (change != null && line >= change.line0) {
            if (line >= change.line0 + change.deleted) {
                newLine += change.inserted - change.deleted;
            } else {
                int delta = Math.min(change.inserted, line - change.line0);
                newLine = change.line1 + delta;
                break;
            }
            change = change.link;
        }
        return newLine + startLine;
    }

    public int translateLineViaDiffStrict(int line) throws FilesTooBigForDiffException {
        Diff.Change change = this.reBuildDiffIfNeeded();
        if (change == null) {
            return line;
        }
        int startLine = this.getDocument().getLineNumber(this.getOffset());
        if (line < startLine) {
            return line;
        }
        int translatedRelative = Diff.translateLine((Diff.Change)change, (int)(line - startLine));
        return translatedRelative < 0 ? -1 : translatedRelative + startLine;
    }

    private Diff.Change reBuildDiffIfNeeded() throws FilesTooBigForDiffException {
        if (this.myChange == TOO_BIG_FILE) {
            throw new FilesTooBigForDiffException();
        }
        if (this.myChange == null) {
            Object[] oldLines = this.getOldLines();
            Object[] newLines = Diff.splitLines((CharSequence)this.myNewString);
            try {
                this.myChange = Diff.buildChanges((Object[])oldLines, (Object[])newLines);
            }
            catch (FilesTooBigForDiffException e2) {
                this.myChange = TOO_BIG_FILE;
                throw e2;
            }
        }
        return this.myChange;
    }

    private String @NotNull [] getOldLines() {
        String[] stringArray;
        this.createOldFragmentLineSetIfNeeded();
        int offsetDiff = this.myOffset - this.myOldFragmentLineSetStart;
        LineIterator lineIterator = this.myOldFragmentLineSet.createIterator();
        ArrayList<String> lines = new ArrayList<String>(this.myOldFragmentLineSet.getLineCount());
        while (!lineIterator.atEnd()) {
            int start = lineIterator.getStart() - offsetDiff;
            int end = lineIterator.getEnd() - lineIterator.getSeparatorLength() - offsetDiff;
            if (start >= 0 && end <= this.myOldString.length()) {
                lines.add(this.myOldString.subSequence(start, end).toString());
            }
            lineIterator.advance();
        }
        if (lines.isEmpty()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        } else {
            stringArray = ArrayUtil.toStringArray(lines);
        }
        if (stringArray == null) {
            DocumentEventImpl.$$$reportNull$$$0(5);
        }
        return stringArray;
    }

    public int getLineNumberBeforeUpdate(int offsetBeforeUpdate) {
        this.createOldFragmentLineSetIfNeeded();
        Document document = this.getDocument();
        if (offsetBeforeUpdate <= this.myOldFragmentLineSetStart) {
            return document.getLineNumber(offsetBeforeUpdate);
        }
        int oldFragmentLineSetEnd = this.myOldFragmentLineSetStart + this.myOldFragmentLineSet.getLength();
        if (offsetBeforeUpdate <= oldFragmentLineSetEnd) {
            return document.getLineNumber(this.myOldFragmentLineSetStart) + this.myOldFragmentLineSet.findLineIndex(offsetBeforeUpdate - this.myOldFragmentLineSetStart);
        }
        int shift = this.getNewLength() - this.getOldLength();
        return document.getLineNumber(this.myOldFragmentLineSetStart) + (this.myOldFragmentLineSetStart == oldFragmentLineSetEnd ? 0 : this.myOldFragmentLineSet.getLineCount() - 1) + document.getLineNumber(offsetBeforeUpdate + shift) - document.getLineNumber(oldFragmentLineSetEnd + shift);
    }

    private void createOldFragmentLineSetIfNeeded() {
        int newChangeEnd;
        if (this.myOldFragmentLineSet != null) {
            return;
        }
        CharSequence newText = this.getDocument().getImmutableCharSequence();
        CharSequence oldFragment = this.getOldFragment();
        this.myOldFragmentLineSetStart = this.getOffset();
        if (this.myOldFragmentLineSetStart > 0 && newText.charAt(this.myOldFragmentLineSetStart - 1) == '\r') {
            --this.myOldFragmentLineSetStart;
            oldFragment = new MergingCharSequence("\r", oldFragment);
        }
        if ((newChangeEnd = this.getOffset() + this.getNewLength()) < newText.length() && newText.charAt(newChangeEnd) == '\n') {
            oldFragment = new MergingCharSequence(oldFragment, "\n");
        }
        this.myOldFragmentLineSet = LineSet.createLineSet(oldFragment);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldString";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newString";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/openapi/editor/impl/event/DocumentEventImpl";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/openapi/editor/impl/event/DocumentEventImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOldFragment";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewFragment";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOldLines";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

