/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.google.common.collect;

import java.io.Serializable;
import ksp.com.google.common.annotations.GwtCompatible;
import ksp.com.google.common.base.Preconditions;
import ksp.com.google.common.collect.ElementTypesAreNonnullByDefault;
import ksp.com.google.common.collect.Ordering;
import ksp.com.google.common.collect.ReverseNaturalOrdering;
import ksp.com.google.errorprone.annotations.concurrent.LazyInit;
import ksp.javax.annotation.CheckForNull;
import ksp.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true)
final class NaturalOrdering
extends Ordering<Comparable<?>>
implements Serializable {
    static final NaturalOrdering INSTANCE = new NaturalOrdering();
    @LazyInit
    @CheckForNull
    private transient Ordering<@Nullable Comparable<?>> nullsFirst;
    @LazyInit
    @CheckForNull
    private transient Ordering<@Nullable Comparable<?>> nullsLast;
    private static final long serialVersionUID = 0L;

    @Override
    public int compare(Comparable<?> left, Comparable<?> right) {
        Preconditions.checkNotNull(left);
        Preconditions.checkNotNull(right);
        return left.compareTo(right);
    }

    @Override
    public <S extends Comparable<?>> Ordering<@Nullable S> nullsFirst() {
        Ordering<@Nullable Comparable<Object>> result2 = this.nullsFirst;
        if (result2 == null) {
            result2 = this.nullsFirst = super.nullsFirst();
        }
        return result2;
    }

    @Override
    public <S extends Comparable<?>> Ordering<@Nullable S> nullsLast() {
        Ordering<@Nullable Comparable<Object>> result2 = this.nullsLast;
        if (result2 == null) {
            result2 = this.nullsLast = super.nullsLast();
        }
        return result2;
    }

    @Override
    public <S extends Comparable<?>> Ordering<S> reverse() {
        return ReverseNaturalOrdering.INSTANCE;
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public String toString() {
        return "Ordering.natural()";
    }

    private NaturalOrdering() {
    }
}

