/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.native.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.native.FirNativeErrors;
import ksp.org.jetbrains.kotlin.fir.analysis.native.checkers.FirNativeHelpersKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.FirVariable;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThreadLocalChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "threadLocalClassId", "Lksp/org/jetbrains/kotlin/name/ClassId;", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.native"})
public final class FirNativeThreadLocalChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirNativeThreadLocalChecker INSTANCE = new FirNativeThreadLocalChecker();
    @NotNull
    private static final ClassId threadLocalClassId = ClassId.Companion.topLevel(new FqName("kotlin.native.concurrent.ThreadLocal"));

    private FirNativeThreadLocalChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        boolean isOk;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        boolean isObject = declaration2 instanceof FirClass && ((FirClass)declaration2).getClassKind() == ClassKind.OBJECT;
        boolean bl2 = isOk = declaration2 instanceof FirVariable && (declaration2 instanceof FirProperty && DeclarationAttributesKt.getHasBackingField((FirProperty)declaration2) || ((FirVariable)declaration2).getDelegate() != null) || isObject;
        if (!isOk) {
            FirNativeHelpersKt.reportIfHasAnnotation(reporter, declaration2, threadLocalClassId, FirNativeErrors.INSTANCE.getINAPPLICABLE_THREAD_LOCAL(), context2);
        }
        KtSourceElement ktSourceElement = declaration2.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
            return;
        }
        if (!FirHelpersKt.isTopLevel(context2) && !isObject) {
            FirNativeHelpersKt.reportIfHasAnnotation(reporter, declaration2, threadLocalClassId, FirNativeErrors.INSTANCE.getINAPPLICABLE_THREAD_LOCAL_TOP_LEVEL(), context2);
        }
    }
}

