/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import ksp.com.intellij.AbstractBundle;
import ksp.com.intellij.BundleBase;
import ksp.com.intellij.diagnostic.LoadingState;
import ksp.com.intellij.openapi.application.Application;
import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.extensions.ExtensionPointName;
import ksp.com.intellij.openapi.extensions.PluginAware;
import ksp.com.intellij.openapi.extensions.PluginDescriptor;
import ksp.com.intellij.openapi.progress.ProcessCanceledException;
import ksp.com.intellij.openapi.util.io.FileUtil;
import ksp.com.intellij.util.DefaultBundleService;
import ksp.com.intellij.util.LocalizationUtil;
import ksp.com.intellij.util.ReflectionUtil;
import ksp.com.intellij.util.containers.CollectionFactory;
import ksp.com.intellij.util.xmlb.annotations.Attribute;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.annotations.Unmodifiable;

public class DynamicBundle
extends AbstractBundle {
    private static final Logger LOG = Logger.getInstance(DynamicBundle.class);
    @NotNull
    private static String ourLangTag = Locale.ENGLISH.toLanguageTag();
    private static final ConcurrentMap<String, ResourceBundle> bundles = CollectionFactory.createConcurrentWeakValueMap();
    private boolean isInitializedBeforeL10Plugin;
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final DynamicBundle INSTANCE = new DynamicBundle(""){};
    private static final Map<ClassLoader, Map<String, ResourceBundle>> ourCache = CollectionFactory.createConcurrentWeakMap();
    private static final Map<ClassLoader, Map<String, ResourceBundle>> ourDefaultCache = CollectionFactory.createConcurrentWeakMap();

    public DynamicBundle(@NotNull Class<?> bundleClass, @NotNull String pathToBundle) {
        if (bundleClass == null) {
            DynamicBundle.$$$reportNull$$$0(0);
        }
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(1);
        }
        super(bundleClass, pathToBundle);
        this.isInitializedBeforeL10Plugin = !LocalizationUtil.INSTANCE.isL10nPluginInitialized();
    }

    @ApiStatus.Obsolete
    protected DynamicBundle(@NotNull String pathToBundle) {
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(2);
        }
        super(pathToBundle);
        this.isInitializedBeforeL10Plugin = !LocalizationUtil.INSTANCE.isL10nPluginInitialized();
    }

    @Override
    @NotNull
    protected ResourceBundle findBundle(@NotNull String pathToBundle, @NotNull ClassLoader baseLoader, @NotNull ResourceBundle.Control control) {
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(3);
        }
        if (baseLoader == null) {
            DynamicBundle.$$$reportNull$$$0(4);
        }
        if (control == null) {
            DynamicBundle.$$$reportNull$$$0(5);
        }
        return DynamicBundle.resolveResourceBundle(this.getBundleClassLoader(), baseLoader, pathToBundle, DynamicBundle.getLocale(), (loader, locale) -> super.findBundle(pathToBundle, (ClassLoader)loader, control, (Locale)locale));
    }

    @NotNull
    private static ResourceBundle resolveResourceBundle(@NotNull ClassLoader bundleClassLoader, @NotNull ClassLoader baseLoader, @NotNull String defaultPath, @NotNull Locale locale, @NotNull @NotNull BiFunction<? super @NotNull ClassLoader, ? super Locale, ? extends @NotNull ResourceBundle> bundleResolver) {
        if (bundleClassLoader == null) {
            DynamicBundle.$$$reportNull$$$0(6);
        }
        if (baseLoader == null) {
            DynamicBundle.$$$reportNull$$$0(7);
        }
        if (defaultPath == null) {
            DynamicBundle.$$$reportNull$$$0(8);
        }
        if (locale == null) {
            DynamicBundle.$$$reportNull$$$0(9);
        }
        if (bundleResolver == null) {
            DynamicBundle.$$$reportNull$$$0(10);
        }
        Path bundlePath = FileSystems.getDefault().getPath(FileUtil.toCanonicalPath(defaultPath, '.'), new String[0]);
        ClassLoader pluginClassLoader = DynamicBundle.languagePluginClassLoader(bundleClassLoader, locale);
        List<Path> paths2 = LocalizationUtil.INSTANCE.getLocalizedPaths(bundlePath, locale);
        HashMap<BundleOrder, ResourceBundle> bundleOrderMap = new HashMap<BundleOrder, ResourceBundle>();
        if (pluginClassLoader != null) {
            DynamicBundle.resolveBundleOrder(pluginClassLoader, true, bundlePath, paths2, bundleOrderMap, bundleResolver, locale);
        }
        DynamicBundle.resolveBundleOrder(baseLoader, false, bundlePath, paths2, bundleOrderMap, bundleResolver, locale);
        DynamicBundle.reorderParents(bundleOrderMap);
        Optional resourceBundleEntry = bundleOrderMap.entrySet().stream().min(Map.Entry.comparingByKey());
        if (!resourceBundleEntry.isPresent()) {
            throw new RuntimeException("No such resource bundle: " + bundlePath);
        }
        ResourceBundle bundle = (ResourceBundle)resourceBundleEntry.get().getValue();
        bundles.put(defaultPath, bundle);
        ResourceBundle resourceBundle = bundle;
        if (resourceBundle == null) {
            DynamicBundle.$$$reportNull$$$0(11);
        }
        return resourceBundle;
    }

    @NotNull
    private static List<ResourceBundle> getBundlesFromLocalizationFolder(@NotNull Path pathToBundle, ClassLoader loader, @NotNull Locale locale) {
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(12);
        }
        if (locale == null) {
            DynamicBundle.$$$reportNull$$$0(13);
        }
        List<Path> paths2 = LocalizationUtil.INSTANCE.getFolderLocalizedPaths(pathToBundle, locale);
        ArrayList<ResourceBundle> resourceBundles = new ArrayList<ResourceBundle>();
        for (Path path : paths2) {
            try {
                ResourceBundle resourceBundle = DynamicBundle.resolveBundle(loader, locale, FileUtil.toSystemIndependentName(path.toString()));
                resourceBundles.add(resourceBundle);
            }
            catch (MissingResourceException e2) {
                LOG.debug(e2);
            }
        }
        ArrayList<ResourceBundle> arrayList = resourceBundles;
        if (arrayList == null) {
            DynamicBundle.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @Nullable
    private static ClassLoader languagePluginClassLoader(@NotNull ClassLoader bundleClassLoader, @NotNull Locale locale) {
        if (bundleClassLoader == null) {
            DynamicBundle.$$$reportNull$$$0(15);
        }
        if (locale == null) {
            DynamicBundle.$$$reportNull$$$0(16);
        }
        if (DefaultBundleService.isDefaultBundle()) {
            return null;
        }
        LanguageBundleEP langBundle = DynamicBundle.findLanguageBundle();
        if (langBundle == null) {
            return null;
        }
        if (!Objects.equals(locale.getLanguage(), DynamicBundle.getLocale().getLanguage()) || locale.getCountry() != null && !Objects.equals(locale.getCountry(), DynamicBundle.getLocale().getCountry())) {
            return null;
        }
        PluginDescriptor pluginDescriptor = langBundle.pluginDescriptor;
        return pluginDescriptor == null ? bundleClassLoader : pluginDescriptor.getClassLoader();
    }

    private static ResourceBundle getParent(@NotNull ResourceBundle bundle) throws Throwable {
        if (bundle == null) {
            DynamicBundle.$$$reportNull$$$0(17);
        }
        return (ResourceBundle)DynamicBundleInternal.GET_PARENT.invokeWithArguments(bundle);
    }

    private static void resolveBundleOrder(@NotNull ClassLoader loader, boolean isPluginClassLoader, @NotNull Path pathToBundle, @NotNull List<? extends Path> orderedPaths, @NotNull Map<? super BundleOrder, ? super ResourceBundle> bundleOrderMap, @NotNull @NotNull BiFunction<? super @NotNull ClassLoader, ? super Locale, ? extends @NotNull ResourceBundle> bundleResolver, @NotNull Locale locale) {
        if (loader == null) {
            DynamicBundle.$$$reportNull$$$0(18);
        }
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(19);
        }
        if (orderedPaths == null) {
            DynamicBundle.$$$reportNull$$$0(20);
        }
        if (bundleOrderMap == null) {
            DynamicBundle.$$$reportNull$$$0(21);
        }
        if (bundleResolver == null) {
            DynamicBundle.$$$reportNull$$$0(22);
        }
        if (locale == null) {
            DynamicBundle.$$$reportNull$$$0(23);
        }
        ResourceBundle bundle = bundleResolver.apply(loader, locale);
        try {
            while (bundle != null) {
                DynamicBundle.putBundleOrder(bundle, bundleOrderMap, orderedPaths, isPluginClassLoader);
                bundle = DynamicBundle.getParent(bundle);
            }
        }
        catch (Throwable throwable) {
            LOG.info(throwable);
        }
        for (ResourceBundle localizedBundle : DynamicBundle.getBundlesFromLocalizationFolder(pathToBundle, loader, locale)) {
            DynamicBundle.putBundleOrder(localizedBundle, bundleOrderMap, orderedPaths, isPluginClassLoader);
        }
    }

    private static void putBundleOrder(@NotNull ResourceBundle bundle, @NotNull Map<? super BundleOrder, ? super ResourceBundle> bundleOrderMap, @NotNull List<? extends Path> orderedPaths, boolean isPluginClassLoader) {
        Path path;
        BundleOrder bundleOrder;
        if (bundle == null) {
            DynamicBundle.$$$reportNull$$$0(24);
        }
        if (bundleOrderMap == null) {
            DynamicBundle.$$$reportNull$$$0(25);
        }
        if (orderedPaths == null) {
            DynamicBundle.$$$reportNull$$$0(26);
        }
        String bundlePath = FileUtil.toCanonicalPath(bundle.getBaseBundleName(), '.');
        if (!bundle.getLocale().toString().isEmpty()) {
            bundlePath = bundlePath + "_" + bundle.getLocale().toString();
        }
        if ((bundleOrder = BundleOrder.getBundleOrder(orderedPaths, path = FileSystems.getDefault().getPath(bundlePath, new String[0]), isPluginClassLoader)) == null) {
            LOG.debug("Order cannot be defined for the bundle: " + path + "; Current locale: " + DynamicBundle.getLocale() + "; Paths for locale: " + orderedPaths);
            return;
        }
        bundleOrderMap.put(bundleOrder, bundle);
    }

    private static void reorderParents(@NotNull Map<BundleOrder, ResourceBundle> bundleOrderMap) {
        if (bundleOrderMap == null) {
            DynamicBundle.$$$reportNull$$$0(27);
        }
        ResourceBundle resourceBundle = null;
        for (BundleOrder bundleOrder : BundleOrder.values()) {
            ResourceBundle parentBundle = bundleOrderMap.get((Object)bundleOrder);
            if (parentBundle == null || parentBundle == resourceBundle) continue;
            if (resourceBundle != null) {
                try {
                    DynamicBundleInternal.SET_PARENT.bindTo(resourceBundle).invoke(parentBundle);
                }
                catch (Throwable e2) {
                    LOG.warn(e2);
                }
            }
            resourceBundle = parentBundle;
        }
    }

    @Nullable
    public static LanguageBundleEP findLanguageBundle() {
        try {
            if (!LoadingState.COMPONENTS_REGISTERED.isOccurred()) {
                return null;
            }
            Application app = ApplicationManager.getApplication();
            if (app == null || !app.getExtensionArea().hasExtensionPoint(LanguageBundleEP.EP_NAME)) {
                return null;
            }
            return LanguageBundleEP.EP_NAME.findExtension(LanguageBundleEP.class);
        }
        catch (ProcessCanceledException e2) {
            throw e2;
        }
        catch (Exception e3) {
            LOG.error(e3);
            return null;
        }
    }

    @Override
    @ApiStatus.Internal
    protected ResourceBundle getBundle(boolean isDefault) {
        if (!isDefault && LocalizationUtil.INSTANCE.isL10nPluginInitialized() && this.isInitializedBeforeL10Plugin) {
            this.isInitializedBeforeL10Plugin = false;
            return null;
        }
        return super.getBundle(isDefault);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public final ResourceBundle getResourceBundle(@NotNull @NonNls String pathToBundle, @NotNull ClassLoader loader) {
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(28);
        }
        if (loader == null) {
            DynamicBundle.$$$reportNull$$$0(29);
        }
        return DynamicBundle.getResourceBundle(loader, pathToBundle);
    }

    @NotNull
    public static ResourceBundle getResourceBundle(@NotNull ClassLoader loader, @NotNull @NonNls String pathToBundle) {
        if (loader == null) {
            DynamicBundle.$$$reportNull$$$0(30);
        }
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(31);
        }
        ResourceBundle resourceBundle = (DefaultBundleService.isDefaultBundle() ? ourDefaultCache : ourCache).computeIfAbsent(loader, __ -> CollectionFactory.createConcurrentSoftValueMap()).computeIfAbsent(pathToBundle, __ -> DynamicBundle.resolveResourceBundle(loader, pathToBundle, DynamicBundle.getLocale()));
        if (resourceBundle == null) {
            DynamicBundle.$$$reportNull$$$0(32);
        }
        return resourceBundle;
    }

    @NotNull
    public static ResourceBundle getResourceBundle(@NotNull ClassLoader loader, @NotNull @NonNls String pathToBundle, @NotNull Locale locale) {
        if (loader == null) {
            DynamicBundle.$$$reportNull$$$0(33);
        }
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(34);
        }
        if (locale == null) {
            DynamicBundle.$$$reportNull$$$0(35);
        }
        ResourceBundle resourceBundle = (DefaultBundleService.isDefaultBundle() ? ourDefaultCache : ourCache).computeIfAbsent(loader, __ -> CollectionFactory.createConcurrentSoftValueMap()).computeIfAbsent(pathToBundle, __ -> DynamicBundle.resolveResourceBundle(loader, pathToBundle, locale));
        if (resourceBundle == null) {
            DynamicBundle.$$$reportNull$$$0(36);
        }
        return resourceBundle;
    }

    @Nullable
    public static ResourceBundle getPluginBundle(@NotNull PluginDescriptor pluginDescriptor) {
        if (pluginDescriptor == null) {
            DynamicBundle.$$$reportNull$$$0(37);
        }
        ClassLoader classLoader = pluginDescriptor.getPluginClassLoader();
        String baseName = pluginDescriptor.getResourceBundleBaseName();
        return classLoader != null && baseName != null ? DynamicBundle.getResourceBundle(classLoader, baseName) : null;
    }

    @NotNull
    private static ResourceBundle resolveResourceBundle(@NotNull ClassLoader loader, @NonNls @NotNull String pathToBundle, @NotNull Locale locale) {
        if (loader == null) {
            DynamicBundle.$$$reportNull$$$0(38);
        }
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(39);
        }
        if (locale == null) {
            DynamicBundle.$$$reportNull$$$0(40);
        }
        ResourceBundle resourceBundle = DynamicBundle.resolveResourceBundleWithFallback(loader, pathToBundle, () -> DynamicBundle.resolveResourceBundle(DynamicBundle.class.getClassLoader(), loader, pathToBundle, locale, DynamicBundle.bundleResolver(pathToBundle)));
        if (resourceBundle == null) {
            DynamicBundle.$$$reportNull$$$0(41);
        }
        return resourceBundle;
    }

    @NotNull
    private static @NotNull BiFunction<@NotNull ClassLoader, @NotNull Locale, @NotNull ResourceBundle> bundleResolver(@NonNls @NotNull String pathToBundle) {
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(42);
        }
        BiFunction<ClassLoader, Locale, ResourceBundle> biFunction = (loader, locale) -> DynamicBundle.resolveBundle(loader, locale, pathToBundle);
        if (biFunction == null) {
            DynamicBundle.$$$reportNull$$$0(43);
        }
        return biFunction;
    }

    @Deprecated
    public static ResourceBundle getBundle(@NotNull String baseName) {
        Class<?> callerClass;
        if (baseName == null) {
            DynamicBundle.$$$reportNull$$$0(44);
        }
        return DynamicBundle.getBundle(baseName, (callerClass = ReflectionUtil.findCallerClass(2)) == null ? DynamicBundle.class : callerClass);
    }

    @Deprecated
    public static ResourceBundle getBundle(@NotNull String baseName, @NotNull Class<?> formClass) {
        if (baseName == null) {
            DynamicBundle.$$$reportNull$$$0(45);
        }
        if (formClass == null) {
            DynamicBundle.$$$reportNull$$$0(46);
        }
        final ResourceBundle rb = DynamicBundle.getResourceBundle(formClass.getClassLoader(), baseName);
        if (!BundleBase.SHOW_LOCALIZED_MESSAGES) {
            return rb;
        }
        return new ResourceBundle(){

            @Override
            protected Object handleGetObject(@NotNull String key) {
                if (key == null) {
                    2.$$$reportNull$$$0(0);
                }
                Object get2 = rb.getObject(key);
                assert (get2 instanceof String) : "Language bundles should contain only strings";
                return BundleBase.appendLocalizationSuffix((String)get2, "\ud83d\udd05");
            }

            @Override
            @NotNull
            public Enumeration<String> getKeys() {
                Enumeration<String> enumeration = rb.getKeys();
                if (enumeration == null) {
                    2.$$$reportNull$$$0(1);
                }
                return enumeration;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n3;
                String string2;
                switch (n2) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        n3 = 3;
                        break;
                    }
                    case 1: {
                        n3 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "key";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ksp/com/intellij/DynamicBundle$2";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "ksp/com/intellij/DynamicBundle$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getKeys";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "handleGetObject";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n2) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public static void loadLocale(@Nullable LanguageBundleEP langBundle) {
        if (langBundle != null) {
            ourLangTag = langBundle.locale;
            ourCache.clear();
        }
    }

    @NotNull
    public static Locale getLocale() {
        Locale locale = Locale.forLanguageTag(ourLangTag);
        if (locale == null) {
            DynamicBundle.$$$reportNull$$$0(47);
        }
        return locale;
    }

    @ApiStatus.Internal
    @NotNull
    public static @Unmodifiable Map<String, ResourceBundle> getResourceBundles() {
        Map<String, ResourceBundle> map = Collections.unmodifiableMap(bundles);
        if (map == null) {
            DynamicBundle.$$$reportNull$$$0(48);
        }
        return map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 14: 
            case 32: 
            case 36: 
            case 41: 
            case 43: 
            case 47: 
            case 48: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 11: 
            case 14: 
            case 32: 
            case 36: 
            case 41: 
            case 43: 
            case 47: 
            case 48: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 12: 
            case 19: 
            case 28: 
            case 31: 
            case 34: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToBundle";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseLoader";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "control";
                break;
            }
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleClassLoader";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultPath";
                break;
            }
            case 9: 
            case 13: 
            case 16: 
            case 23: 
            case 35: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locale";
                break;
            }
            case 10: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleResolver";
                break;
            }
            case 11: 
            case 14: 
            case 32: 
            case 36: 
            case 41: 
            case 43: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/DynamicBundle";
                break;
            }
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 18: 
            case 29: 
            case 30: 
            case 33: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderedPaths";
                break;
            }
            case 21: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleOrderMap";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formClass";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/DynamicBundle";
                break;
            }
            case 11: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveResourceBundle";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundlesFromLocalizationFolder";
                break;
            }
            case 32: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceBundle";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "bundleResolver";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocale";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceBundles";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findBundle";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "resolveResourceBundle";
                break;
            }
            case 11: 
            case 14: 
            case 32: 
            case 36: 
            case 41: 
            case 43: 
            case 47: 
            case 48: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getBundlesFromLocalizationFolder";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "languagePluginClassLoader";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getParent";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "resolveBundleOrder";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "putBundleOrder";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "reorderParents";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getResourceBundle";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getPluginBundle";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "bundleResolver";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getBundle";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 11: 
            case 14: 
            case 32: 
            case 36: 
            case 41: 
            case 43: 
            case 47: 
            case 48: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    @ApiStatus.Internal
    public static final class LanguageBundleEP
    implements PluginAware {
        public static final ExtensionPointName<LanguageBundleEP> EP_NAME = new ExtensionPointName("ksp.com.intellij.languageBundle");
        @Attribute(value="locale")
        public String locale = Locale.ENGLISH.getLanguage();
        public PluginDescriptor pluginDescriptor;

        @Override
        public void setPluginDescriptor(@NotNull PluginDescriptor pluginDescriptor) {
            if (pluginDescriptor == null) {
                LanguageBundleEP.$$$reportNull$$$0(0);
            }
            this.pluginDescriptor = pluginDescriptor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "ksp/com/intellij/DynamicBundle$LanguageBundleEP", "setPluginDescriptor"));
        }
    }

    private static class DynamicBundleInternal {
        @NotNull
        private static final MethodHandle SET_PARENT;
        @NotNull
        private static final MethodHandle GET_PARENT;

        private DynamicBundleInternal() {
        }

        static {
            try {
                Method method = ResourceBundle.class.getDeclaredMethod("setParent", ResourceBundle.class);
                method.setAccessible(true);
                SET_PARENT = MethodHandles.lookup().unreflect(method);
                Field parentField = ResourceBundle.class.getDeclaredField("parent");
                parentField.setAccessible(true);
                GET_PARENT = MethodHandles.lookup().unreflectGetter(parentField);
            }
            catch (ReflectiveOperationException e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    private static enum BundleOrder {
        FOLDER_REGION_LEVEL_PLUGIN,
        FOLDER_REGION_LEVEL_PLATFORM,
        SUFFIX_REGION_LEVEL_PLUGIN,
        SUFFIX_REGION_LEVEL_PLATFORM,
        FOLDER_LANGUAGE_LEVEL_PLUGIN,
        FOLDER_LANGUAGE_LEVEL_PLATFORM,
        SUFFIX_LANGUAGE_LEVEL_PLUGIN,
        SUFFIX_LANGUAGE_LEVEL_PLATFORM,
        DEFAULT_PLUGIN,
        DEFAULT_PLATFORM;


        @Nullable
        static BundleOrder getBundleOrder(@NotNull List<? extends Path> orderedPaths, @NotNull Path bundlePath, boolean isPluginClassLoader) {
            if (orderedPaths == null) {
                BundleOrder.$$$reportNull$$$0(0);
            }
            if (bundlePath == null) {
                BundleOrder.$$$reportNull$$$0(1);
            }
            int order = orderedPaths.indexOf(bundlePath);
            order = isPluginClassLoader ? order * 2 : order * 2 + 1;
            return 0 <= order && order < BundleOrder.values().length ? BundleOrder.values()[order] : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "orderedPaths";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "bundlePath";
                    break;
                }
            }
            objectArray[1] = "ksp/com/intellij/DynamicBundle$BundleOrder";
            objectArray[2] = "getBundleOrder";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

