/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ksp.com.intellij.openapi.util.TextRange;
import ksp.com.intellij.psi.MultiRangeReference;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiReference;
import ksp.org.jetbrains.annotations.NotNull;

public final class ReferenceRange {
    private ReferenceRange() {
    }

    @NotNull
    public static List<TextRange> getRanges(@NotNull PsiReference ref) {
        if (ref == null) {
            ReferenceRange.$$$reportNull$$$0(0);
        }
        if (ref instanceof MultiRangeReference) {
            List<TextRange> list = ((MultiRangeReference)ref).getRanges();
            if (list == null) {
                ReferenceRange.$$$reportNull$$$0(1);
            }
            return list;
        }
        List<TextRange> list = Collections.singletonList(ref.getRangeInElement());
        if (list == null) {
            ReferenceRange.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public static List<TextRange> getAbsoluteRanges(@NotNull PsiReference ref) {
        if (ref == null) {
            ReferenceRange.$$$reportNull$$$0(3);
        }
        PsiElement elt = ref.getElement();
        List<TextRange> relativeRanges = ReferenceRange.getRanges(ref);
        ArrayList<TextRange> answer = new ArrayList<TextRange>(relativeRanges.size());
        int parentOffset = elt.getTextRange().getStartOffset();
        for (TextRange relativeRange : relativeRanges) {
            answer.add(relativeRange.shiftRight(parentOffset));
        }
        ArrayList<TextRange> arrayList = answer;
        if (arrayList == null) {
            ReferenceRange.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public static TextRange getRange(@NotNull PsiReference ref) {
        if (ref == null) {
            ReferenceRange.$$$reportNull$$$0(5);
        }
        if (ref instanceof MultiRangeReference) {
            List<TextRange> ranges = ((MultiRangeReference)ref).getRanges();
            return new TextRange(ranges.get(0).getStartOffset(), ranges.get(ranges.size() - 1).getEndOffset());
        }
        return ref.getRangeInElement();
    }

    public static boolean containsOffsetInElement(@NotNull PsiReference ref, int offset) {
        if (ref == null) {
            ReferenceRange.$$$reportNull$$$0(6);
        }
        if (ref instanceof MultiRangeReference) {
            for (TextRange range : ((MultiRangeReference)ref).getRanges()) {
                if (!range.containsOffset(offset)) continue;
                return true;
            }
            return false;
        }
        return ref.getRangeInElement().containsOffset(offset);
    }

    public static boolean containsRangeInElement(@NotNull PsiReference ref, @NotNull TextRange rangeInElement) {
        if (ref == null) {
            ReferenceRange.$$$reportNull$$$0(7);
        }
        if (rangeInElement == null) {
            ReferenceRange.$$$reportNull$$$0(8);
        }
        if (ref instanceof MultiRangeReference) {
            for (TextRange range : ((MultiRangeReference)ref).getRanges()) {
                if (!range.contains(rangeInElement)) continue;
                return true;
            }
            return false;
        }
        return ref.getRangeInElement().contains(rangeInElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/ReferenceRange";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/ReferenceRange";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRanges";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbsoluteRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRanges";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAbsoluteRanges";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRange";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "containsOffsetInElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "containsRangeInElement";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

