/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.scope.processor;

import java.util.List;
import ksp.com.intellij.openapi.util.Key;
import ksp.com.intellij.pom.java.LanguageLevel;
import ksp.com.intellij.psi.PsiCallExpression;
import ksp.com.intellij.psi.PsiClass;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiExpressionList;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.PsiMethod;
import ksp.com.intellij.psi.PsiSubstitutor;
import ksp.com.intellij.psi.PsiType;
import ksp.com.intellij.psi.filters.ElementFilter;
import ksp.com.intellij.psi.infos.CandidateInfo;
import ksp.com.intellij.psi.scope.ElementClassFilter;
import ksp.com.intellij.psi.scope.ElementClassHint;
import ksp.com.intellij.psi.scope.JavaScopeProcessorEvent;
import ksp.com.intellij.psi.scope.PsiConflictResolver;
import ksp.com.intellij.psi.scope.PsiScopeProcessor;
import ksp.com.intellij.psi.scope.processor.ConflictFilterProcessor;
import ksp.com.intellij.psi.util.PsiUtil;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public abstract class MethodsProcessor
extends ConflictFilterProcessor
implements ElementClassHint {
    private static final ElementFilter ourFilter = ElementClassFilter.METHOD;
    private boolean myStaticScopeFlag;
    private boolean myIsConstructor;
    protected PsiElement myCurrentFileContext;
    PsiClass myAccessClass;
    private PsiExpressionList myArgumentList;
    private PsiType[] myTypeArguments;
    private final LanguageLevel myLanguageLevel;

    MethodsProcessor(PsiConflictResolver @NotNull [] resolvers, @NotNull List<CandidateInfo> container, @NotNull PsiElement place, @NotNull PsiFile placeFile) {
        if (container == null) {
            MethodsProcessor.$$$reportNull$$$0(0);
        }
        if (place == null) {
            MethodsProcessor.$$$reportNull$$$0(1);
        }
        if (placeFile == null) {
            MethodsProcessor.$$$reportNull$$$0(2);
        }
        if (resolvers == null) {
            MethodsProcessor.$$$reportNull$$$0(3);
        }
        super(null, ourFilter, resolvers, container, place, placeFile);
        this.myLanguageLevel = PsiUtil.getLanguageLevel(placeFile);
    }

    public PsiExpressionList getArgumentList() {
        return this.myArgumentList;
    }

    public void setArgumentList(@Nullable PsiExpressionList argList) {
        this.myArgumentList = argList;
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel languageLevel = this.myLanguageLevel;
        if (languageLevel == null) {
            MethodsProcessor.$$$reportNull$$$0(4);
        }
        return languageLevel;
    }

    public void obtainTypeArguments(@NotNull PsiCallExpression callExpression) {
        PsiType[] typeArguments2;
        if (callExpression == null) {
            MethodsProcessor.$$$reportNull$$$0(5);
        }
        if ((typeArguments2 = callExpression.getTypeArguments()).length > 0) {
            this.setTypeArguments(typeArguments2);
        }
    }

    private void setTypeArguments(PsiType[] typeParameters2) {
        this.myTypeArguments = typeParameters2;
    }

    public PsiType[] getTypeArguments() {
        return this.myTypeArguments;
    }

    boolean isInStaticScope() {
        return this.myStaticScopeFlag;
    }

    @Override
    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            MethodsProcessor.$$$reportNull$$$0(6);
        }
        if (JavaScopeProcessorEvent.isEnteringStaticScope(event, associated)) {
            this.myStaticScopeFlag = true;
        } else if (JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT.equals(event)) {
            this.myCurrentFileContext = (PsiElement)associated;
        }
    }

    public void setAccessClass(PsiClass accessClass) {
        this.myAccessClass = accessClass;
    }

    public boolean isConstructor() {
        return this.myIsConstructor;
    }

    public PsiElement getCurrentFileContext() {
        return this.myCurrentFileContext;
    }

    public void setIsConstructor(boolean myIsConstructor) {
        this.myIsConstructor = myIsConstructor;
    }

    public void forceAddResult(@NotNull PsiMethod method) {
        if (method == null) {
            MethodsProcessor.$$$reportNull$$$0(7);
        }
        this.add(new CandidateInfo(method, PsiSubstitutor.EMPTY, false, false, this.myCurrentFileContext));
    }

    @Override
    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == null) {
            MethodsProcessor.$$$reportNull$$$0(8);
        }
        if (hintKey == ElementClassHint.KEY) {
            return (T)this;
        }
        return super.getHint(hintKey);
    }

    @Override
    public boolean shouldProcess(@NotNull ElementClassHint.DeclarationKind kind) {
        if (kind == null) {
            MethodsProcessor.$$$reportNull$$$0(9);
        }
        return kind == ElementClassHint.DeclarationKind.METHOD;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvers";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/scope/processor/MethodsProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintKey";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/scope/processor/MethodsProcessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "obtainTypeArguments";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleEvent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "forceAddResult";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getHint";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "shouldProcess";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

