/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jdom.output.support;

import java.util.List;
import ksp.org.jdom.Content;
import ksp.org.jdom.Text;
import ksp.org.jdom.Verifier;
import ksp.org.jdom.output.support.AbstractFormattedWalker;
import ksp.org.jdom.output.support.FormatStack;

public class WalkerTRIM
extends AbstractFormattedWalker {
    public WalkerTRIM(List<? extends Content> content, FormatStack fstack, boolean escape) {
        super(content, fstack, escape);
    }

    @Override
    protected void analyzeMultiText(AbstractFormattedWalker.MultiText mtext, int offset, int len) {
        Content c;
        while (len > 0 && (c = this.get(offset)) instanceof Text && Verifier.isAllXMLWhitespace(c.getValue())) {
            ++offset;
            --len;
        }
        while (len > 0 && (c = this.get(offset + len - 1)) instanceof Text && Verifier.isAllXMLWhitespace(c.getValue())) {
            --len;
        }
        block6: for (int i = 0; i < len; ++i) {
            AbstractFormattedWalker.Trim trim = AbstractFormattedWalker.Trim.NONE;
            if (i + 1 == len) {
                trim = AbstractFormattedWalker.Trim.RIGHT;
            }
            if (i == 0) {
                trim = AbstractFormattedWalker.Trim.LEFT;
            }
            if (len == 1) {
                trim = AbstractFormattedWalker.Trim.BOTH;
            }
            Content c2 = this.get(offset + i);
            switch (c2.getCType()) {
                case Text: {
                    mtext.appendText(trim, c2.getValue());
                    continue block6;
                }
                case CDATA: {
                    mtext.appendCDATA(trim, c2.getValue());
                    continue block6;
                }
                default: {
                    mtext.appendRaw(c2);
                }
            }
        }
    }
}

