/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.translate.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsExpression;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsName;
import ksp.org.jetbrains.kotlin.js.translate.context.TranslationContext;
import ksp.org.jetbrains.kotlin.js.translate.declaration.AbstractDeclarationVisitor;
import ksp.org.jetbrains.kotlin.js.translate.declaration.PropertyTranslatorKt;
import ksp.org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import ksp.org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import ksp.org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import ksp.org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import ksp.org.jetbrains.kotlin.psi.KtElement;
import ksp.org.jetbrains.kotlin.psi.KtProperty;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J$\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\b\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\"\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lksp/org/jetbrains/kotlin/js/translate/declaration/FileDeclarationVisitor;", "Lksp/org/jetbrains/kotlin/js/translate/declaration/AbstractDeclarationVisitor;", "context", "Lksp/org/jetbrains/kotlin/js/translate/context/TranslationContext;", "<init>", "(Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "visitProperty", "", "expression", "Lksp/org/jetbrains/kotlin/psi/KtProperty;", "addFunction", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lksp/org/jetbrains/kotlin/js/backend/ast/JsExpression;", "psi", "Lksp/org/jetbrains/kotlin/psi/KtElement;", "addProperty", "Lksp/org/jetbrains/kotlin/descriptors/PropertyDescriptor;", "getter", "setter", "getBackingFieldReference", "js.translator"})
public final class FileDeclarationVisitor
extends AbstractDeclarationVisitor {
    @NotNull
    private final TranslationContext context;

    public FileDeclarationVisitor(@NotNull TranslationContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @Override
    public void visitProperty(@NotNull KtProperty expression2, @NotNull TranslationContext context2) {
        boolean backingFieldRequired;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        PropertyDescriptor propertyDescriptor = BindingUtils.getPropertyDescriptor(context2.bindingContext(), expression2);
        Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"getPropertyDescriptor(...)");
        PropertyDescriptor propertyDescriptor2 = propertyDescriptor;
        JsName jsName = context2.getInnerNameForDescriptor(propertyDescriptor2);
        Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"getInnerNameForDescriptor(...)");
        JsName innerName = jsName;
        Boolean bl = (Boolean)context2.bindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor2);
        boolean bl2 = backingFieldRequired = bl != null ? bl : false;
        if (backingFieldRequired || expression2.getDelegateExpression() != null) {
            JsExpression initializer = PropertyTranslatorKt.translateDelegateOrInitializerExpression(context2, expression2);
            context2.addDeclarationStatement(JsAstUtils.newVar(innerName, null));
            if (initializer != null) {
                context2.addTopLevelStatement(JsAstUtils.assignment(innerName.makeRef(), initializer).makeStmt());
            }
        }
        super.visitProperty(expression2, context2);
    }

    @Override
    public void addFunction(@NotNull FunctionDescriptor descriptor2, @Nullable JsExpression expression2, @Nullable KtElement psi) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (expression2 == null) {
            return;
        }
        UtilsKt.addFunctionButNotExport(this.context, descriptor2, expression2);
        this.context.export(descriptor2);
    }

    @Override
    public void addProperty(@NotNull PropertyDescriptor descriptor2, @NotNull JsExpression getter2, @Nullable JsExpression setter2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)getter2, (String)"getter");
        if (!JsDescriptorUtils.isSimpleFinalProperty(descriptor2)) {
            PropertyGetterDescriptor propertyGetterDescriptor = descriptor2.getGetter();
            Intrinsics.checkNotNull((Object)propertyGetterDescriptor);
            UtilsKt.addFunctionButNotExport(this.context, propertyGetterDescriptor, getter2);
            if (setter2 != null) {
                PropertySetterDescriptor propertySetterDescriptor = descriptor2.getSetter();
                Intrinsics.checkNotNull((Object)propertySetterDescriptor);
                UtilsKt.addFunctionButNotExport(this.context, propertySetterDescriptor, setter2);
            }
        }
        this.context.export(descriptor2);
    }

    @Override
    @NotNull
    public JsExpression getBackingFieldReference(@NotNull PropertyDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        JsExpression jsExpression = this.context.getInnerReference(descriptor2);
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"getInnerReference(...)");
        return jsExpression;
    }
}

