/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.resolve.transformers.plugin;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.fir.FirAnnotationContainer;
import ksp.org.jetbrains.kotlin.fir.FirElement;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFile;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.resolve.ScopeSession;
import ksp.org.jetbrains.kotlin.fir.resolve.transformers.DesignationState;
import ksp.org.jetbrains.kotlin.fir.resolve.transformers.plugin.FirDesignatedCompilerRequiredAnnotationsResolveTransformer;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.utils.exceptions.FirExceptionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.visitors.FirTransformerUtilKt;
import ksp.org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;
import ksp.org.jetbrains.kotlin.utils.exceptions.KotlinExceptionWithAttachments;
import ksp.org.jetbrains.kotlin.utils.exceptions.KotlinIllegalStateExceptionWithAttachments;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0006J\u000e\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0010J\u0016\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\bJ\u000e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0010J\u000e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0012J\u0016\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0018\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lksp/org/jetbrains/kotlin/fir/resolve/transformers/plugin/CompilerRequiredAnnotationsComputationSession;", "", "<init>", "()V", "filesWithResolvedImports", "", "Lksp/org/jetbrains/kotlin/fir/declarations/FirFile;", "importsAreResolved", "", "file", "useCacheForImportScope", "getUseCacheForImportScope", "()Z", "recordThatImportsAreResolved", "", "declarationsWithAnnotationResolutionInProgress", "Lksp/org/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "declarationsWithResolvedAnnotations", "Lksp/org/jetbrains/kotlin/fir/FirAnnotationContainer;", "annotationResolutionWasAlreadyStarted", "klass", "annotationsAreResolved", "declaration", "treatNonSourceDeclarationsAsResolved", "recordThatAnnotationResolutionStarted", "recordThatAnnotationsAreResolved", "resolveAnnotationsOnAnnotationIfNeeded", "symbol", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "scopeSession", "Lksp/org/jetbrains/kotlin/fir/resolve/ScopeSession;", "resolveAnnotationSymbol", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirCompilerRequiredAnnotationsResolveTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirCompilerRequiredAnnotationsResolveTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/plugin/CompilerRequiredAnnotationsComputationSession\n+ 2 ExceptionAttachmentBuilder.kt\norg/jetbrains/kotlin/utils/exceptions/ExceptionAttachmentBuilderKt\n*L\n1#1,318:1\n101#2,12:319\n57#2:331\n113#2,3:332\n*S KotlinDebug\n*F\n+ 1 FirCompilerRequiredAnnotationsResolveTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/plugin/CompilerRequiredAnnotationsComputationSession\n*L\n207#1:319,12\n207#1:331\n207#1:332,3\n*E\n"})
public class CompilerRequiredAnnotationsComputationSession {
    @NotNull
    private final Set<FirFile> filesWithResolvedImports = new LinkedHashSet();
    @NotNull
    private final Set<FirClassLikeDeclaration> declarationsWithAnnotationResolutionInProgress = new LinkedHashSet();
    @NotNull
    private final Set<FirAnnotationContainer> declarationsWithResolvedAnnotations = new LinkedHashSet();

    public final boolean importsAreResolved(@NotNull FirFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.filesWithResolvedImports.contains(file2);
    }

    public boolean getUseCacheForImportScope() {
        return false;
    }

    public final void recordThatImportsAreResolved(@NotNull FirFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!this.filesWithResolvedImports.add(file2)) {
            throw new IllegalStateException("Imports are resolved twice".toString());
        }
    }

    public final boolean annotationResolutionWasAlreadyStarted(@NotNull FirClassLikeDeclaration klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        return this.declarationsWithAnnotationResolutionInProgress.contains(klass);
    }

    public final boolean annotationsAreResolved(@NotNull FirAnnotationContainer declaration2, boolean treatNonSourceDeclarationsAsResolved) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        if (declaration2 instanceof FirFile) {
            return false;
        }
        if (treatNonSourceDeclarationsAsResolved && declaration2 instanceof FirDeclaration && !Intrinsics.areEqual((Object)((FirDeclaration)declaration2).getOrigin(), (Object)FirDeclarationOrigin.Source.INSTANCE)) {
            return true;
        }
        return this.declarationsWithResolvedAnnotations.contains(declaration2);
    }

    /*
     * WARNING - void declaration
     */
    public final void recordThatAnnotationResolutionStarted(@NotNull FirClassLikeDeclaration klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        boolean wasNotStartedBefore = this.declarationsWithAnnotationResolutionInProgress.add(klass);
        String attachmentName$iv = "info.txt";
        boolean $i$f$checkWithAttachment = false;
        if (!wasNotStartedBefore) {
            void $this$checkWithAttachment_u24lambda_u241$iv;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder;
            boolean bl = false;
            String string2 = "Annotation resolution was already started";
            KotlinIllegalStateExceptionWithAttachments exception$iv = new KotlinIllegalStateExceptionWithAttachments(string2);
            KotlinExceptionWithAttachments $this$buildAttachment$iv$iv = exception$iv;
            boolean $i$f$buildAttachment = false;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder2 = exceptionAttachmentBuilder = new ExceptionAttachmentBuilder();
            String string3 = attachmentName$iv;
            KotlinExceptionWithAttachments kotlinExceptionWithAttachments = $this$buildAttachment$iv$iv;
            boolean bl2 = false;
            void $this$recordThatAnnotationResolutionStarted_u24lambda_u241 = $this$checkWithAttachment_u24lambda_u241$iv;
            boolean bl3 = false;
            FirExceptionUtilsKt.withFirEntry((ExceptionAttachmentBuilder)$this$recordThatAnnotationResolutionStarted_u24lambda_u241, "class", klass);
            kotlinExceptionWithAttachments.withAttachment(string3, exceptionAttachmentBuilder.buildString());
            throw exception$iv;
        }
    }

    public final void recordThatAnnotationsAreResolved(@NotNull FirAnnotationContainer declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        TypeIntrinsics.asMutableCollection((Object)this.declarationsWithAnnotationResolutionInProgress).remove(declaration2);
        this.declarationsWithResolvedAnnotations.add(declaration2);
    }

    public final void resolveAnnotationsOnAnnotationIfNeeded(@NotNull FirRegularClassSymbol symbol, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        FirRegularClass regularClass = (FirRegularClass)symbol.getFir();
        if (this.annotationsAreResolved(regularClass, true)) {
            return;
        }
        if (regularClass.getAnnotations().isEmpty()) {
            return;
        }
        this.resolveAnnotationSymbol(symbol, scopeSession);
    }

    public void resolveAnnotationSymbol(@NotNull FirRegularClassSymbol symbol, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        DesignationState designationState = DesignationState.Companion.create(symbol, MapsKt.emptyMap(), true);
        if (designationState == null) {
            return;
        }
        DesignationState designation = designationState;
        FirDesignatedCompilerRequiredAnnotationsResolveTransformer transformer2 = new FirDesignatedCompilerRequiredAnnotationsResolveTransformer(designation.getFirstDeclaration().getModuleData().getSession(), scopeSession, this, designation);
        FirTransformerUtilKt.transformSingle((FirElement)designation.getFirstDeclaration(), transformer2, null);
    }
}

