/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.common.lower.loops;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.backend.common.CommonBackendContext;
import ksp.org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import ksp.org.jetbrains.kotlin.backend.common.ScopeWithIr;
import ksp.org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import ksp.org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import ksp.org.jetbrains.kotlin.backend.common.lower.loops.DefaultHeaderInfoBuilder;
import ksp.org.jetbrains.kotlin.backend.common.lower.loops.ForLoopBodyTransformer;
import ksp.org.jetbrains.kotlin.backend.common.lower.loops.ForLoopHeader;
import ksp.org.jetbrains.kotlin.backend.common.lower.loops.HeaderProcessor;
import ksp.org.jetbrains.kotlin.backend.common.lower.loops.LoopReplacement;
import ksp.org.jetbrains.kotlin.ir.IrElement;
import ksp.org.jetbrains.kotlin.ir.IrStatement;
import ksp.org.jetbrains.kotlin.ir.builders.Scope;
import ksp.org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import ksp.org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrConstructor;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import ksp.org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import ksp.org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import ksp.org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import ksp.org.jetbrains.kotlin.ir.declarations.IrField;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFile;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import ksp.org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import ksp.org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import ksp.org.jetbrains.kotlin.ir.declarations.IrProperty;
import ksp.org.jetbrains.kotlin.ir.declarations.IrScript;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import ksp.org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import ksp.org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import ksp.org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import ksp.org.jetbrains.kotlin.ir.declarations.IrVariable;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBlock;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBody;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBranch;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBreak;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrCatch;
import ksp.org.jetbrains.kotlin.ir.expressions.IrClassReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrComposite;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConst;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrContinue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import ksp.org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import ksp.org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpressionsKt;
import ksp.org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetClass;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetField;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetValue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import ksp.org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrLoop;
import ksp.org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrReturn;
import ksp.org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import ksp.org.jetbrains.kotlin.ir.expressions.IrSetField;
import ksp.org.jetbrains.kotlin.ir.expressions.IrSetValue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import ksp.org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import ksp.org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import ksp.org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import ksp.org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import ksp.org.jetbrains.kotlin.ir.expressions.IrThrow;
import ksp.org.jetbrains.kotlin.ir.expressions.IrTry;
import ksp.org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrVararg;
import ksp.org.jetbrains.kotlin.ir.expressions.IrWhen;
import ksp.org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import ksp.org.jetbrains.kotlin.ir.symbols.IrSymbol;
import ksp.org.jetbrains.kotlin.ir.types.IrType;
import ksp.org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import ksp.org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import ksp.org.jetbrains.kotlin.ir.types.IrTypesKt;
import ksp.org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import ksp.org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;
import ksp.org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import ksp.org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import ksp.org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\b\u0002\u0018\u0000 32\u00020\u0001:\u0003123B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u001a\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u0016\u0010-\u001a\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020 00H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lksp/org/jetbrains/kotlin/backend/common/lower/loops/RangeLoopTransformer;", "Lksp/org/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lksp/org/jetbrains/kotlin/backend/common/CommonBackendContext;", "container", "Lksp/org/jetbrains/kotlin/ir/declarations/IrSymbolOwner;", "oldLoopToNewLoop", "", "Lksp/org/jetbrains/kotlin/ir/expressions/IrLoop;", "loopBodyTransformer", "Lksp/org/jetbrains/kotlin/backend/common/lower/loops/ForLoopBodyTransformer;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Lorg/jetbrains/kotlin/ir/declarations/IrSymbolOwner;Ljava/util/Map;Lorg/jetbrains/kotlin/backend/common/lower/loops/ForLoopBodyTransformer;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "getContainer", "()Lorg/jetbrains/kotlin/ir/declarations/IrSymbolOwner;", "getOldLoopToNewLoop", "()Ljava/util/Map;", "getLoopBodyTransformer", "()Lorg/jetbrains/kotlin/backend/common/lower/loops/ForLoopBodyTransformer;", "headerInfoBuilder", "Lksp/org/jetbrains/kotlin/backend/common/lower/loops/DefaultHeaderInfoBuilder;", "headerProcessor", "Lksp/org/jetbrains/kotlin/backend/common/lower/loops/HeaderProcessor;", "getScopeOwnerSymbol", "Lksp/org/jetbrains/kotlin/ir/symbols/IrSymbol;", "visitBlock", "Lksp/org/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lksp/org/jetbrains/kotlin/ir/expressions/IrBlock;", "lowerHeader", "Lksp/org/jetbrains/kotlin/ir/IrStatement;", "variable", "Lksp/org/jetbrains/kotlin/ir/declarations/IrVariable;", "loopHeader", "Lksp/org/jetbrains/kotlin/backend/common/lower/loops/ForLoopHeader;", "lowerWhileLoop", "Lksp/org/jetbrains/kotlin/backend/common/lower/loops/LoopReplacement;", "loop", "Lksp/org/jetbrains/kotlin/ir/expressions/IrWhileLoop;", "specializeIteratorIfPossible", "", "irForLoopBlock", "Lksp/org/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "gatherLoopVariableInfo", "Lksp/org/jetbrains/kotlin/backend/common/lower/loops/RangeLoopTransformer$LoopVariableInfo;", "statements", "", "LoopVariableInfo", "FindInitializerCallVisitor", "Companion", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nForLoopsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForLoopsLowering.kt\norg/jetbrains/kotlin/backend/common/lower/loops/RangeLoopTransformer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,470:1\n1#2:471\n1755#3,3:472\n385#4,11:475\n*S KotlinDebug\n*F\n+ 1 ForLoopsLowering.kt\norg/jetbrains/kotlin/backend/common/lower/loops/RangeLoopTransformer\n*L\n181#1:472,3\n325#1:475,11\n*E\n"})
final class RangeLoopTransformer
extends IrElementTransformerVoidWithContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommonBackendContext context;
    @NotNull
    private final IrSymbolOwner container;
    @NotNull
    private final Map<IrLoop, IrLoop> oldLoopToNewLoop;
    @Nullable
    private final ForLoopBodyTransformer loopBodyTransformer;
    @NotNull
    private final DefaultHeaderInfoBuilder headerInfoBuilder;
    @NotNull
    private final HeaderProcessor headerProcessor;
    @NotNull
    private static final FqName STDLIB_ITERATOR_FUNCTION_FQ_NAME = new FqName("kotlin.collections.CollectionsKt.iterator");

    public RangeLoopTransformer(@NotNull CommonBackendContext context2, @NotNull IrSymbolOwner container, @NotNull Map<IrLoop, IrLoop> oldLoopToNewLoop, @Nullable ForLoopBodyTransformer loopBodyTransformer) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter(oldLoopToNewLoop, (String)"oldLoopToNewLoop");
        this.context = context2;
        this.container = container;
        this.oldLoopToNewLoop = oldLoopToNewLoop;
        this.loopBodyTransformer = loopBodyTransformer;
        this.headerInfoBuilder = new DefaultHeaderInfoBuilder(this.context, (Function0<? extends IrSymbol>)((Function0)new Function0<IrSymbol>((Object)this){

            public final IrSymbol invoke() {
                return ((RangeLoopTransformer)this.receiver).getScopeOwnerSymbol();
            }
        }));
        this.headerProcessor = new HeaderProcessor(this.context, this.headerInfoBuilder, (Function0<? extends IrSymbol>)((Function0)new Function0<IrSymbol>((Object)this){

            public final IrSymbol invoke() {
                return ((RangeLoopTransformer)this.receiver).getScopeOwnerSymbol();
            }
        }));
    }

    public /* synthetic */ RangeLoopTransformer(CommonBackendContext commonBackendContext, IrSymbolOwner irSymbolOwner, Map map, ForLoopBodyTransformer forLoopBodyTransformer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            forLoopBodyTransformer = null;
        }
        this(commonBackendContext, irSymbolOwner, map, forLoopBodyTransformer);
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final IrSymbolOwner getContainer() {
        return this.container;
    }

    @NotNull
    public final Map<IrLoop, IrLoop> getOldLoopToNewLoop() {
        return this.oldLoopToNewLoop;
    }

    @Nullable
    public final ForLoopBodyTransformer getLoopBodyTransformer() {
        return this.loopBodyTransformer;
    }

    @NotNull
    public final IrSymbol getScopeOwnerSymbol() {
        Object object = this.getCurrentScope();
        if (object == null || (object = ((ScopeWithIr)object).getScope()) == null || (object = ((Scope)object).getScopeOwnerSymbol()) == null) {
            object = this.container.getSymbol();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrExpression visitBlock(@NotNull IrBlock expression2) {
        boolean bl;
        ForLoopHeader loopHeader;
        IrWhileLoop oldLoop;
        IrVariable iteratorVariable;
        List<IrStatement> statements;
        block10: {
            boolean bl2;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            if (!Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)IrStatementOrigin.Companion.getFOR_LOOP())) {
                return super.visitBlock(expression2);
            }
            statements = expression2.getStatements();
            boolean bl3 = bl2 = statements.size() == 2;
            if (_Assertions.ENABLED && !bl2) {
                boolean $i$a$-assert-RangeLoopTransformer$visitBlock$42 = false;
                String $i$a$-assert-RangeLoopTransformer$visitBlock$42 = "Expected 2 statements in for-loop block, was:\n" + DumpIrTreeKt.dump$default(expression2, null, 1, null);
                throw new AssertionError((Object)$i$a$-assert-RangeLoopTransformer$visitBlock$42);
            }
            IrStatement irStatement = statements.get(0);
            Intrinsics.checkNotNull((Object)irStatement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrVariable");
            iteratorVariable = (IrVariable)irStatement;
            boolean $i$a$-assert-RangeLoopTransformer$visitBlock$42 = Intrinsics.areEqual((Object)iteratorVariable.getOrigin(), (Object)IrDeclarationOrigin.Companion.getFOR_LOOP_ITERATOR());
            if (_Assertions.ENABLED && !$i$a$-assert-RangeLoopTransformer$visitBlock$42) {
                boolean $i$a$-assert-RangeLoopTransformer$visitBlock$52 = false;
                String $i$a$-assert-RangeLoopTransformer$visitBlock$52 = "Expected FOR_LOOP_ITERATOR origin for iterator variable, was:\n" + DumpIrTreeKt.dump$default(iteratorVariable, null, 1, null);
                throw new AssertionError((Object)$i$a$-assert-RangeLoopTransformer$visitBlock$52);
            }
            IrStatement irStatement2 = statements.get(1);
            Intrinsics.checkNotNull((Object)irStatement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrWhileLoop");
            oldLoop = (IrWhileLoop)irStatement2;
            boolean $i$a$-assert-RangeLoopTransformer$visitBlock$52 = Intrinsics.areEqual((Object)oldLoop.getOrigin(), (Object)IrStatementOrigin.Companion.getFOR_LOOP_INNER_WHILE());
            if (_Assertions.ENABLED && !$i$a$-assert-RangeLoopTransformer$visitBlock$52) {
                boolean $i$a$-assert-RangeLoopTransformer$visitBlock$62 = false;
                String $i$a$-assert-RangeLoopTransformer$visitBlock$62 = "Expected FOR_LOOP_INNER_WHILE origin for while loop, was:\n" + DumpIrTreeKt.dump$default(oldLoop, null, 1, null);
                throw new AssertionError((Object)$i$a$-assert-RangeLoopTransformer$visitBlock$62);
            }
            ForLoopHeader forLoopHeader = this.headerProcessor.extractHeader(iteratorVariable);
            if (forLoopHeader == null) {
                void $this$visitBlock_u24lambda_u243;
                IrBlock irBlock;
                IrBlock irBlock2 = irBlock = expression2;
                RangeLoopTransformer rangeLoopTransformer = this;
                boolean bl4 = false;
                this.specializeIteratorIfPossible((IrContainerExpression)$this$visitBlock_u24lambda_u243);
                return super.visitBlock(irBlock);
            }
            loopHeader = forLoopHeader;
            Iterable $this$any$iv = loopHeader.getLoopInitStatements();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrStatement it = (IrStatement)element$iv;
                    boolean bl5 = false;
                    IrAnnotationContainer irAnnotationContainer = it instanceof IrVariable ? (IrVariable)it : null;
                    boolean bl6 = irAnnotationContainer != null && (irAnnotationContainer = irAnnotationContainer.getType()) != null ? IrTypePredicatesKt.isNothing((IrType)irAnnotationContainer) : false;
                    if (!bl6) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        if (bl) {
            return super.visitBlock(expression2);
        }
        IrStatement loweredHeader = this.lowerHeader(iteratorVariable, loopHeader);
        LoopReplacement loopReplacement = this.lowerWhileLoop(oldLoop, loopHeader);
        if (loopReplacement == null) {
            return super.visitBlock(expression2);
        }
        LoopReplacement loopReplacement2 = loopReplacement;
        IrLoop newLoop = loopReplacement2.component1();
        IrExpression loopReplacementExpression = loopReplacement2.component2();
        this.oldLoopToNewLoop.put(oldLoop, newLoop);
        statements.set(0, loweredHeader);
        statements.set(1, loopReplacementExpression);
        return super.visitBlock(expression2);
    }

    private final IrStatement lowerHeader(IrVariable variable, ForLoopHeader loopHeader) {
        return new IrCompositeImpl(variable.getStartOffset(), variable.getEndOffset(), this.context.getIrBuiltIns().getUnitType(), null, loopHeader.getLoopInitStatements());
    }

    private final LoopReplacement lowerWhileLoop(IrWhileLoop loop, ForLoopHeader loopHeader) {
        IrExpression newBody;
        IrExpression irExpression;
        IrExpression irExpression2 = loop.getBody();
        Object object = irExpression2 instanceof IrContainerExpression ? (IrContainerExpression)irExpression2 : null;
        if (object == null || (object = object.getStatements()) == null) {
            return null;
        }
        Object loopBodyStatements = object;
        LoopVariableInfo loopVariableInfo = this.gatherLoopVariableInfo((List<IrStatement>)loopBodyStatements);
        IrVariable mainLoopVariable = loopVariableInfo.component1();
        int mainLoopVariableIndex = loopVariableInfo.component2();
        Map<Integer, IrVariable> loopVariableComponents = loopVariableInfo.component3();
        List<Integer> loopVariableComponentIndices = loopVariableInfo.component4();
        if (loopHeader.getConsumesLoopVariableComponents() && !Intrinsics.areEqual((Object)mainLoopVariable.getOrigin(), (Object)IrDeclarationOrigin.Companion.getIR_TEMPORARY_VARIABLE())) {
            return null;
        }
        IrExpression irExpression3 = mainLoopVariable.getInitializer();
        Intrinsics.checkNotNull((Object)irExpression3);
        IrExpression initializer = irExpression3;
        DeclarationIrBuilder $this$lowerWhileLoop_u24lambda_u245 = LowerUtilsKt.createIrBuilder(this.context, this.getScopeOwnerSymbol(), initializer.getStartOffset(), initializer.getEndOffset());
        boolean bl = false;
        IrCompositeImpl replacement = new IrCompositeImpl(mainLoopVariable.getStartOffset(), mainLoopVariable.getEndOffset(), $this$lowerWhileLoop_u24lambda_u245.getContext().getIrBuiltIns().getUnitType(), IrStatementOrigin.Companion.getFOR_LOOP_NEXT(), loopHeader.initializeIteration(mainLoopVariable, loopVariableComponents, $this$lowerWhileLoop_u24lambda_u245, this.context));
        if (loopHeader.getConsumesLoopVariableComponents()) {
            Iterator iterator2 = CollectionsKt.asReversed(loopVariableComponentIndices).iterator();
            while (iterator2.hasNext()) {
                boolean bl2;
                int index2 = ((Number)iterator2.next()).intValue();
                boolean bl3 = bl2 = index2 > mainLoopVariableIndex;
                if (_Assertions.ENABLED && !bl2) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                loopBodyStatements.remove(index2);
            }
        }
        loopBodyStatements.set(mainLoopVariableIndex, replacement);
        IrExpression irExpression4 = loop.getBody();
        if (irExpression4 != null) {
            IrExpression it = irExpression4;
            boolean bl4 = false;
            irExpression = it instanceof IrContainerExpression && !IrExpressionsKt.isTransparentScope((IrContainerExpression)it) ? (IrExpression)new IrCompositeImpl(loop.getStartOffset(), loop.getEndOffset(), it.getType(), ((IrContainerExpression)it).getOrigin(), ((IrContainerExpression)it).getStatements()) : it;
        } else {
            irExpression = newBody = null;
        }
        if (newBody != null && this.loopBodyTransformer != null) {
            this.loopBodyTransformer.transform(this.context, newBody, mainLoopVariable, loopHeader, loopVariableComponents);
        }
        return loopHeader.buildLoop(LowerUtilsKt.createIrBuilder(this.context, this.getScopeOwnerSymbol(), loop.getStartOffset(), loop.getEndOffset()), loop, newBody);
    }

    private final void specializeIteratorIfPossible(IrContainerExpression irForLoopBlock) {
        block13: {
            IrVariable irVariable;
            IrStatement irStatement;
            IrStatement single$iv;
            Object receiverType;
            IrCall initializer;
            IrVariable iterator2;
            List<IrStatement> statements;
            block12: {
                statements = irForLoopBlock.getStatements();
                IrStatement irStatement2 = statements.get(0);
                Intrinsics.checkNotNull((Object)irStatement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrVariable");
                iterator2 = (IrVariable)irStatement2;
                IrExpression irExpression = iterator2.getInitializer();
                IrCall irCall = irExpression instanceof IrCall ? (IrCall)irExpression : null;
                if (irCall == null) {
                    return;
                }
                initializer = irCall;
                if (!AdditionalIrUtilsKt.hasEqualFqName(initializer.getSymbol().getOwner(), STDLIB_ITERATOR_FUNCTION_FQ_NAME)) {
                    return;
                }
                Object object = initializer.getExtensionReceiver();
                if (object == null || (object = ((IrExpression)object).getType()) == null) {
                    return;
                }
                receiverType = object;
                if (!IrTypeUtilsKt.isStrictSubtypeOfClass((IrType)receiverType, this.context.getIrBuiltIns().getIteratorClass())) {
                    return;
                }
                IrClass irClass = IrTypesKt.getClass((IrType)receiverType);
                if (irClass == null) {
                    return;
                }
                IrClass receiverClass = irClass;
                Sequence<IrSimpleFunction> $this$singleOrNull$iv = IrUtilsKt.getFunctions(receiverClass);
                boolean $i$f$singleOrNull = false;
                single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    IrSimpleFunction it = (IrSimpleFunction)element$iv;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)OperatorNameConventions.NEXT) && it.getDispatchReceiverParameter() != null && it.getExtensionReceiverParameter() == null && it.getValueParameters().isEmpty())) continue;
                    if (found$iv) {
                        irStatement = null;
                        break block12;
                    }
                    single$iv = (IrStatement)element$iv;
                    found$iv = true;
                }
                irStatement = !found$iv ? null : single$iv;
            }
            IrSimpleFunction irSimpleFunction = (IrSimpleFunction)irStatement;
            if (irSimpleFunction == null) {
                return;
            }
            IrSimpleFunction next2 = irSimpleFunction;
            IrVariable $this$specializeIteratorIfPossible_u24lambda_u248 = irVariable = iterator2;
            boolean bl = false;
            $this$specializeIteratorIfPossible_u24lambda_u248.setType((IrType)receiverType);
            $this$specializeIteratorIfPossible_u24lambda_u248.setInitializer(initializer.getExtensionReceiver());
            IrStatement irStatement3 = statements.get(1);
            Intrinsics.checkNotNull((Object)irStatement3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrWhileLoop");
            IrWhileLoop loop = (IrWhileLoop)irStatement3;
            IrExpression irExpression = loop.getBody();
            Object object = irExpression instanceof IrBlock ? (IrBlock)irExpression : null;
            single$iv = object != null && (object = object.getStatements()) != null ? (IrStatement)CollectionsKt.firstOrNull((List)object) : null;
            IrVariable irVariable2 = single$iv instanceof IrVariable ? (IrVariable)single$iv : null;
            if (irVariable2 == null) {
                return;
            }
            IrVariable loopVariable = irVariable2;
            IrExpression irExpression2 = loop.getCondition();
            IrCall irCall = irExpression2 instanceof IrCall ? (IrCall)irExpression2 : null;
            if (irCall == null) {
                return;
            }
            IrCall loopCondition = irCall;
            IrExpression irExpression3 = loopCondition.getDispatchReceiver();
            if (irExpression3 != null) {
                irExpression3.setType((IrType)receiverType);
            }
            IrExpression nextCall = loopVariable.getInitializer();
            if (!(nextCall instanceof IrCall)) break block13;
            ((IrCall)nextCall).setSymbol(next2.getSymbol());
            IrExpression irExpression4 = ((IrCall)nextCall).getDispatchReceiver();
            if (irExpression4 != null) {
                irExpression4.setType((IrType)receiverType);
            }
        }
    }

    private final LoopVariableInfo gatherLoopVariableInfo(List<IrStatement> statements) {
        boolean bl;
        IrStatement mainLoopVariable = null;
        int mainLoopVariableIndex = -1;
        Map loopVariableComponents = new LinkedHashMap();
        List loopVariableComponentIndices = new ArrayList();
        Iterator iterator2 = ((Iterable)statements).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            IrStatementOrigin origin2;
            IrMemberAccessExpression initializer;
            IrMemberAccessExpression irMemberAccessExpression;
            int i = n++;
            IrStatement stmt = (IrStatement)iterator2.next();
            if (!(stmt instanceof IrVariable)) continue;
            if (((IrVariable)stmt).getInitializer() != null) {
                IrExpression it;
                FindInitializerCallVisitor findInitializerCallVisitor;
                boolean bl2 = false;
                FindInitializerCallVisitor $this$gatherLoopVariableInfo_u24lambda_u2410_u24lambda_u249 = findInitializerCallVisitor = new FindInitializerCallVisitor((IrVariable)mainLoopVariable);
                boolean bl3 = false;
                IrVisitorsKt.acceptVoid(it, $this$gatherLoopVariableInfo_u24lambda_u2410_u24lambda_u249);
                irMemberAccessExpression = findInitializerCallVisitor.getInitializerCall();
            } else {
                irMemberAccessExpression = null;
            }
            IrMemberAccessExpression irMemberAccessExpression2 = initializer = irMemberAccessExpression;
            IrStatementOrigin irStatementOrigin = origin2 = irMemberAccessExpression2 != null ? irMemberAccessExpression2.getOrigin() : null;
            if (Intrinsics.areEqual((Object)origin2, (Object)IrStatementOrigin.Companion.getFOR_LOOP_NEXT())) {
                mainLoopVariable = stmt;
                mainLoopVariableIndex = i;
                continue;
            }
            if (!(origin2 instanceof IrStatementOrigin.COMPONENT_N)) continue;
            loopVariableComponents.put(((IrStatementOrigin.COMPONENT_N)origin2).getIndex(), stmt);
            loopVariableComponentIndices.add(i);
        }
        if (mainLoopVariable == null) {
            boolean bl4 = false;
            String string2 = "No 'next' statement in for-loop";
            throw new IllegalStateException(string2.toString());
        }
        boolean bl5 = bl = mainLoopVariableIndex >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        return new LoopVariableInfo((IrVariable)mainLoopVariable, mainLoopVariableIndex, loopVariableComponents, loopVariableComponentIndices);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lksp/org/jetbrains/kotlin/backend/common/lower/loops/RangeLoopTransformer$Companion;", "", "<init>", "()V", "STDLIB_ITERATOR_FUNCTION_FQ_NAME", "Lksp/org/jetbrains/kotlin/name/FqName;", "getSTDLIB_ITERATOR_FUNCTION_FQ_NAME", "()Lorg/jetbrains/kotlin/name/FqName;", "ir.backend.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FqName getSTDLIB_ITERATOR_FUNCTION_FQ_NAME() {
            return STDLIB_ITERATOR_FUNCTION_FQ_NAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0007H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lksp/org/jetbrains/kotlin/backend/common/lower/loops/RangeLoopTransformer$FindInitializerCallVisitor;", "Lksp/org/jetbrains/kotlin/ir/visitors/IrElementVisitorVoid;", "mainLoopVariable", "Lksp/org/jetbrains/kotlin/ir/declarations/IrVariable;", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrVariable;)V", "initializerCall", "Lksp/org/jetbrains/kotlin/ir/expressions/IrCall;", "getInitializerCall", "()Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "setInitializerCall", "(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)V", "visitElement", "", "element", "Lksp/org/jetbrains/kotlin/ir/IrElement;", "visitCall", "expression", "ir.backend.common"})
    private static final class FindInitializerCallVisitor
    implements IrElementVisitorVoid {
        @Nullable
        private final IrVariable mainLoopVariable;
        @Nullable
        private IrCall initializerCall;

        public FindInitializerCallVisitor(@Nullable IrVariable mainLoopVariable) {
            this.mainLoopVariable = mainLoopVariable;
        }

        @Nullable
        public final IrCall getInitializerCall() {
            return this.initializerCall;
        }

        public final void setInitializerCall(@Nullable IrCall irCall) {
            this.initializerCall = irCall;
        }

        @Override
        public void visitElement(@NotNull IrElement element2) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            IrVisitorsKt.acceptChildrenVoid(element2, this);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void visitCall(@NotNull IrCall expression) {
            block7: {
                block8: {
                    block6: {
                        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                        var3_2 = expression.getOrigin();
                        if (!Intrinsics.areEqual((Object)var3_2, (Object)IrStatementOrigin.Companion.getFOR_LOOP_NEXT())) break block6;
                        v0 = expression;
                        break block7;
                    }
                    if (!(var3_2 instanceof IrStatementOrigin.COMPONENT_N)) break block8;
                    if (this.mainLoopVariable == null) ** GOTO lbl-1000
                    var4_3 = expression.getDispatchReceiver();
                    v1 = var4_3 instanceof IrGetValue != false ? (IrGetValue)var4_3 : null;
                    if (Intrinsics.areEqual((Object)(v1 != null ? v1.getSymbol() : null), (Object)this.mainLoopVariable.getSymbol())) {
                        v0 = expression;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = null;
                    }
                    break block7;
                }
                v0 = null;
            }
            candidateCall = v0;
            if (candidateCall == null) {
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression);
            } else if (this.initializerCall == null) {
                this.initializerCall = candidateCall;
            } else {
                v2 = new StringBuilder().append("Multiple initializer calls found. First: ");
                v3 = this.initializerCall;
                Intrinsics.checkNotNull((Object)v3);
                throw new IllegalStateException(v2.append(RenderIrElementKt.render$default(v3, null, 1, null)).append("\nSecond: ").append(RenderIrElementKt.render$default(candidateCall, null, 1, null)).toString());
            }
        }

        @Override
        public void visitElement(@NotNull IrElement element2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitElement(this, element2, data);
        }

        @Override
        public void visitDeclaration(@NotNull IrDeclarationBase declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2, data);
        }

        @Override
        public void visitDeclaration(@NotNull IrDeclarationBase declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2);
        }

        @Override
        public void visitValueParameter(@NotNull IrValueParameter declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2, data);
        }

        @Override
        public void visitValueParameter(@NotNull IrValueParameter declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2);
        }

        @Override
        public void visitClass(@NotNull IrClass declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2, data);
        }

        @Override
        public void visitClass(@NotNull IrClass declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2);
        }

        @Override
        public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2, data);
        }

        @Override
        public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2);
        }

        @Override
        public void visitTypeParameter(@NotNull IrTypeParameter declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2, data);
        }

        @Override
        public void visitTypeParameter(@NotNull IrTypeParameter declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2);
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2, data);
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2);
        }

        @Override
        public void visitConstructor(@NotNull IrConstructor declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2, data);
        }

        @Override
        public void visitConstructor(@NotNull IrConstructor declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2);
        }

        @Override
        public void visitEnumEntry(@NotNull IrEnumEntry declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2, data);
        }

        @Override
        public void visitEnumEntry(@NotNull IrEnumEntry declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2);
        }

        @Override
        public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2, data);
        }

        @Override
        public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2);
        }

        @Override
        public void visitField(@NotNull IrField declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2, data);
        }

        @Override
        public void visitField(@NotNull IrField declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2);
        }

        @Override
        public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data);
        }

        @Override
        public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2);
        }

        @Override
        public void visitModuleFragment(@NotNull IrModuleFragment declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2, data);
        }

        @Override
        public void visitModuleFragment(@NotNull IrModuleFragment declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2);
        }

        @Override
        public void visitProperty(@NotNull IrProperty declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2, data);
        }

        @Override
        public void visitProperty(@NotNull IrProperty declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2);
        }

        @Override
        public void visitScript(@NotNull IrScript declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2, data);
        }

        @Override
        public void visitScript(@NotNull IrScript declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2);
        }

        @Override
        public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2, data);
        }

        @Override
        public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2);
        }

        @Override
        public void visitTypeAlias(@NotNull IrTypeAlias declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2, data);
        }

        @Override
        public void visitTypeAlias(@NotNull IrTypeAlias declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2);
        }

        @Override
        public void visitVariable(@NotNull IrVariable declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2, data);
        }

        @Override
        public void visitVariable(@NotNull IrVariable declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2);
        }

        @Override
        public void visitPackageFragment(@NotNull IrPackageFragment declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2, data);
        }

        @Override
        public void visitPackageFragment(@NotNull IrPackageFragment declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2);
        }

        @Override
        public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2, data);
        }

        @Override
        public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2);
        }

        @Override
        public void visitFile(@NotNull IrFile declaration2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2, data);
        }

        @Override
        public void visitFile(@NotNull IrFile declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2);
        }

        @Override
        public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data);
        }

        @Override
        public void visitExpression(@NotNull IrExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
        }

        @Override
        public void visitBody(@NotNull IrBody body2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data);
        }

        @Override
        public void visitBody(@NotNull IrBody body2) {
            IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
        }

        @Override
        public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data);
        }

        @Override
        public void visitExpressionBody(@NotNull IrExpressionBody body2) {
            IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
        }

        @Override
        public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data);
        }

        @Override
        public void visitBlockBody(@NotNull IrBlockBody body2) {
            IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
        }

        @Override
        public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data);
        }

        @Override
        public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
            IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
        }

        @Override
        public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data);
        }

        @Override
        public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
            IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
        }

        @Override
        public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data);
        }

        @Override
        public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
        }

        @Override
        public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data);
        }

        @Override
        public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
            IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
        }

        @Override
        public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data);
        }

        @Override
        public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
            IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
        }

        @Override
        public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data);
        }

        @Override
        public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
            IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
        }

        @Override
        public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data);
        }

        @Override
        public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
            IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
        }

        @Override
        public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data);
        }

        @Override
        public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
            IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
        }

        @Override
        public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data);
        }

        @Override
        public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
        }

        @Override
        public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data);
        }

        @Override
        public void visitBlock(@NotNull IrBlock expression2) {
            IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
        }

        @Override
        public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data);
        }

        @Override
        public void visitComposite(@NotNull IrComposite expression2) {
            IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
        }

        @Override
        public void visitReturnableBlock(@NotNull IrReturnableBlock expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitReturnableBlock(this, expression2, data);
        }

        @Override
        public void visitReturnableBlock(@NotNull IrReturnableBlock expression2) {
            IrElementVisitorVoid.DefaultImpls.visitReturnableBlock(this, expression2);
        }

        @Override
        public void visitInlinedFunctionBlock(@NotNull IrInlinedFunctionBlock inlinedBlock, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock, data);
        }

        @Override
        public void visitInlinedFunctionBlock(@NotNull IrInlinedFunctionBlock inlinedBlock) {
            IrElementVisitorVoid.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock);
        }

        @Override
        public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data);
        }

        @Override
        public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
            IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
        }

        @Override
        public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
        }

        @Override
        public void visitBreakContinue(@NotNull IrBreakContinue jump) {
            IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
        }

        @Override
        public void visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
        }

        @Override
        public void visitBreak(@NotNull IrBreak jump) {
            IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
        }

        @Override
        public void visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
        }

        @Override
        public void visitContinue(@NotNull IrContinue jump) {
            IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
        }

        @Override
        public void visitCall(@NotNull IrCall expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data);
        }

        @Override
        public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data);
        }

        @Override
        public void visitCallableReference(@NotNull IrCallableReference<?> expression2) {
            IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
        }

        @Override
        public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data);
        }

        @Override
        public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
            IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
        }

        @Override
        public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data);
        }

        @Override
        public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
            IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
        }

        @Override
        public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
        }

        @Override
        public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
        }

        @Override
        public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data);
        }

        @Override
        public void visitClassReference(@NotNull IrClassReference expression2) {
            IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
        }

        @Override
        public void visitConst(@NotNull IrConst expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data);
        }

        @Override
        public void visitConst(@NotNull IrConst expression2) {
            IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
        }

        @Override
        public void visitConstantValue(@NotNull IrConstantValue expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2, data);
        }

        @Override
        public void visitConstantValue(@NotNull IrConstantValue expression2) {
            IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2);
        }

        @Override
        public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2, data);
        }

        @Override
        public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2) {
            IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2);
        }

        @Override
        public void visitConstantObject(@NotNull IrConstantObject expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2, data);
        }

        @Override
        public void visitConstantObject(@NotNull IrConstantObject expression2) {
            IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2);
        }

        @Override
        public void visitConstantArray(@NotNull IrConstantArray expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2, data);
        }

        @Override
        public void visitConstantArray(@NotNull IrConstantArray expression2) {
            IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2);
        }

        @Override
        public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
        }

        @Override
        public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
            IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
        }

        @Override
        public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data);
        }

        @Override
        public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
        }

        @Override
        public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
        }

        @Override
        public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
        }

        @Override
        public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
        }

        @Override
        public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
        }

        @Override
        public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
        }

        @Override
        public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
            IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
        }

        @Override
        public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data);
        }

        @Override
        public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
        }

        @Override
        public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data);
        }

        @Override
        public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
        }

        @Override
        public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data);
        }

        @Override
        public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
        }

        @Override
        public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data);
        }

        @Override
        public void visitGetField(@NotNull IrGetField expression2) {
            IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
        }

        @Override
        public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data);
        }

        @Override
        public void visitSetField(@NotNull IrSetField expression2) {
            IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
        }

        @Override
        public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data);
        }

        @Override
        public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
        }

        @Override
        public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data);
        }

        @Override
        public void visitGetClass(@NotNull IrGetClass expression2) {
            IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
        }

        @Override
        public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
        }

        @Override
        public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
            IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
        }

        @Override
        public void visitLoop(@NotNull IrLoop loop, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop, data);
        }

        @Override
        public void visitLoop(@NotNull IrLoop loop) {
            IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop);
        }

        @Override
        public void visitWhileLoop(@NotNull IrWhileLoop loop, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop, data);
        }

        @Override
        public void visitWhileLoop(@NotNull IrWhileLoop loop) {
            IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop);
        }

        @Override
        public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop, data);
        }

        @Override
        public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop) {
            IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop);
        }

        @Override
        public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data);
        }

        @Override
        public void visitReturn(@NotNull IrReturn expression2) {
            IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
        }

        @Override
        public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data);
        }

        @Override
        public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
            IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
        }

        @Override
        public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data);
        }

        @Override
        public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
            IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
        }

        @Override
        public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data);
        }

        @Override
        public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
        }

        @Override
        public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data);
        }

        @Override
        public void visitThrow(@NotNull IrThrow expression2) {
            IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
        }

        @Override
        public void visitTry(@NotNull IrTry aTry, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
        }

        @Override
        public void visitTry(@NotNull IrTry aTry) {
            IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
        }

        @Override
        public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
        }

        @Override
        public void visitCatch(@NotNull IrCatch aCatch) {
            IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
        }

        @Override
        public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data);
        }

        @Override
        public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
            IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
        }

        @Override
        public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data);
        }

        @Override
        public void visitValueAccess(@NotNull IrValueAccessExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2);
        }

        @Override
        public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data);
        }

        @Override
        public void visitGetValue(@NotNull IrGetValue expression2) {
            IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
        }

        @Override
        public void visitSetValue(@NotNull IrSetValue expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data);
        }

        @Override
        public void visitSetValue(@NotNull IrSetValue expression2) {
            IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2);
        }

        @Override
        public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data);
        }

        @Override
        public void visitVararg(@NotNull IrVararg expression2) {
            IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
        }

        @Override
        public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
        }

        @Override
        public void visitSpreadElement(@NotNull IrSpreadElement spread) {
            IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
        }

        @Override
        public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data);
        }

        @Override
        public void visitWhen(@NotNull IrWhen expression2) {
            IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
        }

        @Override
        public void visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
        }

        @Override
        public void visitBranch(@NotNull IrBranch branch) {
            IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
        }

        @Override
        public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
        }

        @Override
        public void visitElseBranch(@NotNull IrElseBranch branch) {
            IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u00c6\u0003JC\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lksp/org/jetbrains/kotlin/backend/common/lower/loops/RangeLoopTransformer$LoopVariableInfo;", "", "mainLoopVariable", "Lksp/org/jetbrains/kotlin/ir/declarations/IrVariable;", "mainLoopVariableIndex", "", "loopVariableComponents", "", "loopVariableComponentIndices", "", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrVariable;ILjava/util/Map;Ljava/util/List;)V", "getMainLoopVariable", "()Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "getMainLoopVariableIndex", "()I", "getLoopVariableComponents", "()Ljava/util/Map;", "getLoopVariableComponentIndices", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "ir.backend.common"})
    private static final class LoopVariableInfo {
        @NotNull
        private final IrVariable mainLoopVariable;
        private final int mainLoopVariableIndex;
        @NotNull
        private final Map<Integer, IrVariable> loopVariableComponents;
        @NotNull
        private final List<Integer> loopVariableComponentIndices;

        public LoopVariableInfo(@NotNull IrVariable mainLoopVariable, int mainLoopVariableIndex, @NotNull Map<Integer, ? extends IrVariable> loopVariableComponents, @NotNull List<Integer> loopVariableComponentIndices) {
            Intrinsics.checkNotNullParameter((Object)mainLoopVariable, (String)"mainLoopVariable");
            Intrinsics.checkNotNullParameter(loopVariableComponents, (String)"loopVariableComponents");
            Intrinsics.checkNotNullParameter(loopVariableComponentIndices, (String)"loopVariableComponentIndices");
            this.mainLoopVariable = mainLoopVariable;
            this.mainLoopVariableIndex = mainLoopVariableIndex;
            this.loopVariableComponents = loopVariableComponents;
            this.loopVariableComponentIndices = loopVariableComponentIndices;
        }

        @NotNull
        public final IrVariable getMainLoopVariable() {
            return this.mainLoopVariable;
        }

        public final int getMainLoopVariableIndex() {
            return this.mainLoopVariableIndex;
        }

        @NotNull
        public final Map<Integer, IrVariable> getLoopVariableComponents() {
            return this.loopVariableComponents;
        }

        @NotNull
        public final List<Integer> getLoopVariableComponentIndices() {
            return this.loopVariableComponentIndices;
        }

        @NotNull
        public final IrVariable component1() {
            return this.mainLoopVariable;
        }

        public final int component2() {
            return this.mainLoopVariableIndex;
        }

        @NotNull
        public final Map<Integer, IrVariable> component3() {
            return this.loopVariableComponents;
        }

        @NotNull
        public final List<Integer> component4() {
            return this.loopVariableComponentIndices;
        }

        @NotNull
        public final LoopVariableInfo copy(@NotNull IrVariable mainLoopVariable, int mainLoopVariableIndex, @NotNull Map<Integer, ? extends IrVariable> loopVariableComponents, @NotNull List<Integer> loopVariableComponentIndices) {
            Intrinsics.checkNotNullParameter((Object)mainLoopVariable, (String)"mainLoopVariable");
            Intrinsics.checkNotNullParameter(loopVariableComponents, (String)"loopVariableComponents");
            Intrinsics.checkNotNullParameter(loopVariableComponentIndices, (String)"loopVariableComponentIndices");
            return new LoopVariableInfo(mainLoopVariable, mainLoopVariableIndex, loopVariableComponents, loopVariableComponentIndices);
        }

        public static /* synthetic */ LoopVariableInfo copy$default(LoopVariableInfo loopVariableInfo, IrVariable irVariable, int n, Map map, List list, int n2, Object object) {
            if ((n2 & 1) != 0) {
                irVariable = loopVariableInfo.mainLoopVariable;
            }
            if ((n2 & 2) != 0) {
                n = loopVariableInfo.mainLoopVariableIndex;
            }
            if ((n2 & 4) != 0) {
                map = loopVariableInfo.loopVariableComponents;
            }
            if ((n2 & 8) != 0) {
                list = loopVariableInfo.loopVariableComponentIndices;
            }
            return loopVariableInfo.copy(irVariable, n, map, list);
        }

        @NotNull
        public String toString() {
            return "LoopVariableInfo(mainLoopVariable=" + this.mainLoopVariable + ", mainLoopVariableIndex=" + this.mainLoopVariableIndex + ", loopVariableComponents=" + this.loopVariableComponents + ", loopVariableComponentIndices=" + this.loopVariableComponentIndices + ')';
        }

        public int hashCode() {
            int result2 = this.mainLoopVariable.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.mainLoopVariableIndex);
            result2 = result2 * 31 + ((Object)this.loopVariableComponents).hashCode();
            result2 = result2 * 31 + ((Object)this.loopVariableComponentIndices).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LoopVariableInfo)) {
                return false;
            }
            LoopVariableInfo loopVariableInfo = (LoopVariableInfo)other;
            if (!Intrinsics.areEqual((Object)this.mainLoopVariable, (Object)loopVariableInfo.mainLoopVariable)) {
                return false;
            }
            if (this.mainLoopVariableIndex != loopVariableInfo.mainLoopVariableIndex) {
                return false;
            }
            if (!Intrinsics.areEqual(this.loopVariableComponents, loopVariableInfo.loopVariableComponents)) {
                return false;
            }
            return Intrinsics.areEqual(this.loopVariableComponentIndices, loopVariableInfo.loopVariableComponentIndices);
        }
    }
}

