/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.editor.colors;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.editor.markup.TextAttributes;
import ksp.com.intellij.openapi.util.Comparing;
import ksp.com.intellij.openapi.util.JDOMExternalizerUtil;
import ksp.com.intellij.openapi.util.NlsSafe;
import ksp.com.intellij.openapi.util.NullableLazyValue;
import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.com.intellij.util.ObjectUtils;
import ksp.com.intellij.util.containers.JBIterable;
import ksp.org.jdom.Element;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.annotations.TestOnly;

public final class TextAttributesKey
implements Comparable<TextAttributesKey> {
    public static final TextAttributesKey[] EMPTY_ARRAY = new TextAttributesKey[0];
    private static final Logger LOG = Logger.getInstance(TextAttributesKey.class);
    private static final String TEMP_PREFIX = "TEMP::";
    private static final TextAttributes NULL_ATTRIBUTES = new TextAttributes();
    private static final ConcurrentMap<String, TextAttributesKey> ourRegistry = new ConcurrentHashMap<String, TextAttributesKey>();
    private static final NullableLazyValue<TextAttributeKeyDefaultsProvider> ourDefaultsProvider = NullableLazyValue.volatileLazyNullable(() -> ApplicationManager.getApplication().getService(TextAttributeKeyDefaultsProvider.class));
    @NotNull
    private final String myExternalName;
    private final TextAttributes myDefaultAttributes;
    private final TextAttributesKey myFallbackAttributeKey;
    private static final ThreadLocal<Set<String>> CALLED_RECURSIVELY = ThreadLocal.withInitial(() -> new HashSet());
    @Deprecated
    static final TextAttributesKey DUMMY_DEPRECATED_ATTRIBUTES = TextAttributesKey.createTextAttributesKey("__deprecated__");

    private TextAttributesKey(@NotNull String externalName, TextAttributes defaultAttributes, TextAttributesKey fallbackAttributeKey) {
        if (externalName == null) {
            TextAttributesKey.$$$reportNull$$$0(0);
        }
        this.myExternalName = externalName;
        this.myDefaultAttributes = defaultAttributes;
        this.myFallbackAttributeKey = fallbackAttributeKey;
        if (fallbackAttributeKey != null) {
            this.checkForCycle(fallbackAttributeKey);
        }
    }

    private void checkForCycle(@NotNull TextAttributesKey fallbackAttributeKey) {
        if (fallbackAttributeKey == null) {
            TextAttributesKey.$$$reportNull$$$0(1);
        }
        TextAttributesKey key = fallbackAttributeKey;
        while (key != null) {
            if (this.equals(key)) {
                throw new IllegalArgumentException("Can't use this fallback key: " + fallbackAttributeKey + ": Cycle detected: " + StringUtil.join(JBIterable.generate(this.myFallbackAttributeKey, o -> o == this ? null : o.myFallbackAttributeKey), "->"));
            }
            key = key.myFallbackAttributeKey;
        }
    }

    public TextAttributesKey(@NotNull Element element2) {
        if (element2 == null) {
            TextAttributesKey.$$$reportNull$$$0(2);
        }
        String name2 = JDOMExternalizerUtil.readField(element2, "myExternalName");
        Element myDefaultAttributesElement = JDOMExternalizerUtil.readOption(element2, "myDefaultAttributes");
        TextAttributes defaultAttributes = myDefaultAttributesElement == null ? null : new TextAttributes(myDefaultAttributesElement);
        this.myExternalName = Objects.requireNonNull(name2);
        this.myDefaultAttributes = defaultAttributes;
        this.myFallbackAttributeKey = null;
    }

    @NotNull
    public static TextAttributesKey find(@NotNull @NonNls String externalName) {
        if (externalName == null) {
            TextAttributesKey.$$$reportNull$$$0(3);
        }
        TextAttributesKey textAttributesKey = ourRegistry.computeIfAbsent(externalName, name2 -> new TextAttributesKey((String)name2, null, null));
        if (textAttributesKey == null) {
            TextAttributesKey.$$$reportNull$$$0(4);
        }
        return textAttributesKey;
    }

    @NlsSafe
    public String toString() {
        return this.myExternalName + (this.myFallbackAttributeKey == null && this.myDefaultAttributes == null ? "" : " (") + (this.myFallbackAttributeKey == null ? "" : "fallbackKey: " + this.myFallbackAttributeKey) + (this.myDefaultAttributes == null ? "" : "; defaultAttributes: " + this.myDefaultAttributes) + (this.myFallbackAttributeKey == null && this.myDefaultAttributes == null ? "" : ")");
    }

    @NotNull
    @NlsSafe
    public String getExternalName() {
        String string2 = this.myExternalName;
        if (string2 == null) {
            TextAttributesKey.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @Override
    public int compareTo(@NotNull TextAttributesKey key) {
        if (key == null) {
            TextAttributesKey.$$$reportNull$$$0(6);
        }
        return this.myExternalName.compareTo(key.myExternalName);
    }

    @NotNull
    public static TextAttributesKey createTextAttributesKey(@NonNls @NotNull String externalName) {
        if (externalName == null) {
            TextAttributesKey.$$$reportNull$$$0(7);
        }
        return TextAttributesKey.find(externalName);
    }

    public void writeExternal(Element element2) {
        JDOMExternalizerUtil.writeField(element2, "myExternalName", this.myExternalName);
        if (this.myDefaultAttributes != null) {
            Element option = JDOMExternalizerUtil.writeOption(element2, "myDefaultAttributes");
            this.myDefaultAttributes.writeExternal(option);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextAttributesKey that = (TextAttributesKey)o;
        return this.myExternalName.equals(that.myExternalName);
    }

    public int hashCode() {
        return this.myExternalName.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextAttributes getDefaultAttributes() {
        TextAttributeKeyDefaultsProvider provider2;
        TextAttributes defaultAttributes = this.myDefaultAttributes;
        if (defaultAttributes == null && (provider2 = ourDefaultsProvider.getValue()) != null) {
            Set<String> called = CALLED_RECURSIVELY.get();
            if (!called.add(this.myExternalName)) {
                return null;
            }
            try {
                TextAttributes textAttributes = ObjectUtils.notNull(provider2.getDefaultAttributes(this), NULL_ATTRIBUTES);
                return textAttributes;
            }
            finally {
                called.remove(this.myExternalName);
            }
        }
        return defaultAttributes;
    }

    @Deprecated
    @NotNull
    public static TextAttributesKey createTextAttributesKey(@NonNls @NotNull String externalName, TextAttributes defaultAttributes) {
        if (externalName == null) {
            TextAttributesKey.$$$reportNull$$$0(8);
        }
        return TextAttributesKey.getOrCreate(externalName, defaultAttributes, null);
    }

    @NotNull
    public static TextAttributesKey createTextAttributesKey(@NonNls @NotNull String externalName, TextAttributesKey fallbackAttributeKey) {
        if (externalName == null) {
            TextAttributesKey.$$$reportNull$$$0(9);
        }
        return TextAttributesKey.getOrCreate(externalName, null, fallbackAttributeKey);
    }

    @NotNull
    private static TextAttributesKey getOrCreate(@NotNull @NonNls String externalName, TextAttributes defaultAttributes, TextAttributesKey fallbackAttributeKey) {
        TextAttributesKey existing;
        if (externalName == null) {
            TextAttributesKey.$$$reportNull$$$0(10);
        }
        if ((existing = (TextAttributesKey)ourRegistry.get(externalName)) != null && (defaultAttributes == null || Comparing.equal(existing.myDefaultAttributes, defaultAttributes)) && (fallbackAttributeKey == null || Comparing.equal(existing.myFallbackAttributeKey, fallbackAttributeKey))) {
            TextAttributesKey textAttributesKey = existing;
            if (textAttributesKey == null) {
                TextAttributesKey.$$$reportNull$$$0(11);
            }
            return textAttributesKey;
        }
        TextAttributesKey textAttributesKey = ourRegistry.compute(externalName, (oldName, oldKey) -> TextAttributesKey.mergeKeys(oldName, oldKey, defaultAttributes, fallbackAttributeKey));
        if (textAttributesKey == null) {
            TextAttributesKey.$$$reportNull$$$0(12);
        }
        return textAttributesKey;
    }

    @NotNull
    private static TextAttributesKey mergeKeys(@NonNls @NotNull String externalName, @Nullable TextAttributesKey oldKey, TextAttributes defaultAttributes, TextAttributesKey fallbackAttributeKey) {
        if (externalName == null) {
            TextAttributesKey.$$$reportNull$$$0(13);
        }
        if (oldKey == null) {
            return new TextAttributesKey(externalName, defaultAttributes, fallbackAttributeKey);
        }
        if (oldKey.myFallbackAttributeKey != null && !oldKey.myFallbackAttributeKey.equals(fallbackAttributeKey)) {
            LOG.error(new IllegalStateException("TextAttributeKey(name:'" + externalName + "', fallbackAttributeKey:'" + fallbackAttributeKey + "')  was already registered with the other fallback attribute key: " + oldKey.myFallbackAttributeKey));
        }
        if (oldKey.myDefaultAttributes != null && !oldKey.myDefaultAttributes.equals(defaultAttributes)) {
            LOG.error(new IllegalStateException("TextAttributeKey(name:'" + externalName + "', defaultAttributes:'" + defaultAttributes + "')  was already registered with the other defaultAttributes: " + oldKey.myDefaultAttributes));
        }
        TextAttributes newDefaults = ObjectUtils.chooseNotNull(defaultAttributes, oldKey.myDefaultAttributes);
        TextAttributesKey newFallback = ObjectUtils.chooseNotNull(fallbackAttributeKey, oldKey.myFallbackAttributeKey);
        return new TextAttributesKey(externalName, newDefaults, newFallback);
    }

    @NotNull
    public static TextAttributesKey createTempTextAttributesKey(@NonNls @NotNull String externalName, TextAttributes defaultAttributes) {
        if (externalName == null) {
            TextAttributesKey.$$$reportNull$$$0(14);
        }
        return TextAttributesKey.createTextAttributesKey(TEMP_PREFIX + externalName, defaultAttributes);
    }

    @Nullable
    public TextAttributesKey getFallbackAttributeKey() {
        return this.myFallbackAttributeKey;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public void setFallbackAttributeKey(@Nullable TextAttributesKey fallbackAttributeKey) {
    }

    @TestOnly
    static void removeTextAttributesKey(@NonNls @NotNull String externalName) {
        if (externalName == null) {
            TextAttributesKey.$$$reportNull$$$0(15);
        }
        ourRegistry.remove(externalName);
    }

    public static boolean isTemp(@NotNull TextAttributesKey key) {
        if (key == null) {
            TextAttributesKey.$$$reportNull$$$0(16);
        }
        return key.getExternalName().startsWith(TEMP_PREFIX);
    }

    @ApiStatus.Experimental
    @ApiStatus.Internal
    @NotNull
    public static List<TextAttributesKey> getAllKeys() {
        return new ArrayList<TextAttributesKey>(ourRegistry.values());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 12: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fallbackAttributeKey";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/openapi/editor/colors/TextAttributesKey";
                break;
            }
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/openapi/editor/colors/TextAttributesKey";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkForCycle";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createTextAttributesKey";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "mergeKeys";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createTempTextAttributesKey";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeTextAttributesKey";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isTemp";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface TextAttributeKeyDefaultsProvider {
        @Nullable
        public TextAttributes getDefaultAttributes(@NotNull TextAttributesKey var1);
    }
}

