/*
 * Decompiled with CFR 0.152.
 */
package ksp.it.unimi.dsi.fastutil.longs;

import java.io.Serializable;
import java.util.NoSuchElementException;
import ksp.it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import ksp.it.unimi.dsi.fastutil.longs.LongComparator;
import ksp.it.unimi.dsi.fastutil.longs.LongIterators;
import ksp.it.unimi.dsi.fastutil.longs.LongSets;
import ksp.it.unimi.dsi.fastutil.longs.LongSortedSet;
import ksp.it.unimi.dsi.fastutil.longs.LongSpliterator;
import ksp.it.unimi.dsi.fastutil.longs.LongSpliterators;

public final class LongSortedSets {
    public static final EmptySet EMPTY_SET = new EmptySet();

    private LongSortedSets() {
    }

    public static LongSortedSet singleton(long element2) {
        return new Singleton(element2);
    }

    public static LongSortedSet singleton(long element2, LongComparator comparator) {
        return new Singleton(element2, comparator);
    }

    public static LongSortedSet singleton(Object element2) {
        return new Singleton((Long)element2);
    }

    public static LongSortedSet singleton(Object element2, LongComparator comparator) {
        return new Singleton((Long)element2, comparator);
    }

    public static LongSortedSet synchronize(LongSortedSet s2) {
        return new SynchronizedSortedSet(s2);
    }

    public static LongSortedSet synchronize(LongSortedSet s2, Object sync) {
        return new SynchronizedSortedSet(s2, sync);
    }

    public static LongSortedSet unmodifiable(LongSortedSet s2) {
        return new UnmodifiableSortedSet(s2);
    }

    public static class Singleton
    extends LongSets.Singleton
    implements LongSortedSet,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;
        final LongComparator comparator;

        protected Singleton(long element2, LongComparator comparator) {
            super(element2);
            this.comparator = comparator;
        }

        Singleton(long element2) {
            this(element2, null);
        }

        final int compare(long k1, long k2) {
            return this.comparator == null ? Long.compare(k1, k2) : this.comparator.compare(k1, k2);
        }

        @Override
        public LongBidirectionalIterator iterator(long from2) {
            LongBidirectionalIterator i = this.iterator();
            if (this.compare(this.element, from2) <= 0) {
                i.nextLong();
            }
            return i;
        }

        @Override
        public LongComparator comparator() {
            return this.comparator;
        }

        @Override
        public LongSpliterator spliterator() {
            return LongSpliterators.singleton(this.element, this.comparator);
        }

        @Override
        public LongSortedSet subSet(long from2, long to) {
            if (this.compare(from2, this.element) <= 0 && this.compare(this.element, to) < 0) {
                return this;
            }
            return EMPTY_SET;
        }

        @Override
        public LongSortedSet headSet(long to) {
            if (this.compare(this.element, to) < 0) {
                return this;
            }
            return EMPTY_SET;
        }

        @Override
        public LongSortedSet tailSet(long from2) {
            if (this.compare(from2, this.element) <= 0) {
                return this;
            }
            return EMPTY_SET;
        }

        @Override
        public long firstLong() {
            return this.element;
        }

        @Override
        public long lastLong() {
            return this.element;
        }

        @Override
        @Deprecated
        public LongSortedSet subSet(Long from2, Long to) {
            return this.subSet((long)from2, (long)to);
        }

        @Override
        @Deprecated
        public LongSortedSet headSet(Long to) {
            return this.headSet((long)to);
        }

        @Override
        @Deprecated
        public LongSortedSet tailSet(Long from2) {
            return this.tailSet((long)from2);
        }

        @Override
        @Deprecated
        public Long first() {
            return this.element;
        }

        @Override
        @Deprecated
        public Long last() {
            return this.element;
        }
    }

    public static class SynchronizedSortedSet
    extends LongSets.SynchronizedSet
    implements LongSortedSet,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final LongSortedSet sortedSet;

        protected SynchronizedSortedSet(LongSortedSet s2, Object sync) {
            super(s2, sync);
            this.sortedSet = s2;
        }

        protected SynchronizedSortedSet(LongSortedSet s2) {
            super(s2);
            this.sortedSet = s2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public LongComparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.comparator();
            }
        }

        @Override
        public LongSortedSet subSet(long from2, long to) {
            return new SynchronizedSortedSet(this.sortedSet.subSet(from2, to), this.sync);
        }

        @Override
        public LongSortedSet headSet(long to) {
            return new SynchronizedSortedSet(this.sortedSet.headSet(to), this.sync);
        }

        @Override
        public LongSortedSet tailSet(long from2) {
            return new SynchronizedSortedSet(this.sortedSet.tailSet(from2), this.sync);
        }

        @Override
        public LongBidirectionalIterator iterator() {
            return this.sortedSet.iterator();
        }

        @Override
        public LongBidirectionalIterator iterator(long from2) {
            return this.sortedSet.iterator(from2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long firstLong() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.firstLong();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long lastLong() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.lastLong();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Long first() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.first();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Long last() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.last();
            }
        }

        @Override
        @Deprecated
        public LongSortedSet subSet(Long from2, Long to) {
            return new SynchronizedSortedSet(this.sortedSet.subSet(from2, to), this.sync);
        }

        @Override
        @Deprecated
        public LongSortedSet headSet(Long to) {
            return new SynchronizedSortedSet(this.sortedSet.headSet(to), this.sync);
        }

        @Override
        @Deprecated
        public LongSortedSet tailSet(Long from2) {
            return new SynchronizedSortedSet(this.sortedSet.tailSet(from2), this.sync);
        }
    }

    public static class UnmodifiableSortedSet
    extends LongSets.UnmodifiableSet
    implements LongSortedSet,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final LongSortedSet sortedSet;

        protected UnmodifiableSortedSet(LongSortedSet s2) {
            super(s2);
            this.sortedSet = s2;
        }

        @Override
        public LongComparator comparator() {
            return this.sortedSet.comparator();
        }

        @Override
        public LongSortedSet subSet(long from2, long to) {
            return new UnmodifiableSortedSet(this.sortedSet.subSet(from2, to));
        }

        @Override
        public LongSortedSet headSet(long to) {
            return new UnmodifiableSortedSet(this.sortedSet.headSet(to));
        }

        @Override
        public LongSortedSet tailSet(long from2) {
            return new UnmodifiableSortedSet(this.sortedSet.tailSet(from2));
        }

        @Override
        public LongBidirectionalIterator iterator() {
            return LongIterators.unmodifiable(this.sortedSet.iterator());
        }

        @Override
        public LongBidirectionalIterator iterator(long from2) {
            return LongIterators.unmodifiable(this.sortedSet.iterator(from2));
        }

        @Override
        public long firstLong() {
            return this.sortedSet.firstLong();
        }

        @Override
        public long lastLong() {
            return this.sortedSet.lastLong();
        }

        @Override
        @Deprecated
        public Long first() {
            return this.sortedSet.first();
        }

        @Override
        @Deprecated
        public Long last() {
            return this.sortedSet.last();
        }

        @Override
        @Deprecated
        public LongSortedSet subSet(Long from2, Long to) {
            return new UnmodifiableSortedSet(this.sortedSet.subSet(from2, to));
        }

        @Override
        @Deprecated
        public LongSortedSet headSet(Long to) {
            return new UnmodifiableSortedSet(this.sortedSet.headSet(to));
        }

        @Override
        @Deprecated
        public LongSortedSet tailSet(Long from2) {
            return new UnmodifiableSortedSet(this.sortedSet.tailSet(from2));
        }
    }

    public static class EmptySet
    extends LongSets.EmptySet
    implements LongSortedSet,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptySet() {
        }

        @Override
        public LongBidirectionalIterator iterator(long from2) {
            return LongIterators.EMPTY_ITERATOR;
        }

        @Override
        public LongSortedSet subSet(long from2, long to) {
            return EMPTY_SET;
        }

        @Override
        public LongSortedSet headSet(long from2) {
            return EMPTY_SET;
        }

        @Override
        public LongSortedSet tailSet(long to) {
            return EMPTY_SET;
        }

        @Override
        public long firstLong() {
            throw new NoSuchElementException();
        }

        @Override
        public long lastLong() {
            throw new NoSuchElementException();
        }

        @Override
        public LongComparator comparator() {
            return null;
        }

        @Override
        @Deprecated
        public LongSortedSet subSet(Long from2, Long to) {
            return EMPTY_SET;
        }

        @Override
        @Deprecated
        public LongSortedSet headSet(Long from2) {
            return EMPTY_SET;
        }

        @Override
        @Deprecated
        public LongSortedSet tailSet(Long to) {
            return EMPTY_SET;
        }

        @Override
        @Deprecated
        public Long first() {
            throw new NoSuchElementException();
        }

        @Override
        @Deprecated
        public Long last() {
            throw new NoSuchElementException();
        }

        @Override
        public Object clone() {
            return EMPTY_SET;
        }

        private Object readResolve() {
            return EMPTY_SET;
        }
    }
}

