/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.concurrency;

import java.util.function.Function;
import kotlin.coroutines.CoroutineContext;
import ksp.com.intellij.concurrency.ThreadContext;
import ksp.com.intellij.openapi.application.AccessToken;
import ksp.org.jetbrains.annotations.Async;
import ksp.org.jetbrains.annotations.NotNull;

final class ContextFunction<T, R>
implements Function<T, R> {
    @NotNull
    private final CoroutineContext myParentContext;
    @NotNull
    private final Function<T, R> myFunction;

    @Async.Schedule
    ContextFunction(@NotNull CoroutineContext context2, @NotNull Function<T, R> function2) {
        if (context2 == null) {
            ContextFunction.$$$reportNull$$$0(0);
        }
        if (function2 == null) {
            ContextFunction.$$$reportNull$$$0(1);
        }
        this.myParentContext = context2;
        this.myFunction = function2;
    }

    @Override
    @Async.Execute
    public R apply(T arg) {
        try (AccessToken ignored = ThreadContext.installThreadContext(this.myParentContext, true);){
            R r = this.myFunction.apply(arg);
            return r;
        }
    }

    public String toString() {
        return this.myFunction.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "function";
                break;
            }
        }
        objectArray[1] = "ksp/com/intellij/util/concurrency/ContextFunction";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

