/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.psi.stubs.elements;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.stubs.IndexSink;
import ksp.com.intellij.psi.stubs.StubElement;
import ksp.com.intellij.psi.stubs.StubInputStream;
import ksp.com.intellij.psi.stubs.StubOutputStream;
import ksp.com.intellij.util.io.StringRef;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.psi.KtTypeAlias;
import ksp.org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinTypeAliasStub;
import ksp.org.jetbrains.kotlin.psi.stubs.StubUtils;
import ksp.org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import ksp.org.jetbrains.kotlin.psi.stubs.elements.StubIndexService;
import ksp.org.jetbrains.kotlin.psi.stubs.impl.KotlinTypeAliasStubImpl;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00032\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00122\f\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000bH\u0016J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\t"}, d2={"Lksp/org/jetbrains/kotlin/psi/stubs/elements/KtTypeAliasElementType;", "Lksp/org/jetbrains/kotlin/psi/stubs/elements/KtStubElementType;", "Lksp/org/jetbrains/kotlin/psi/stubs/KotlinTypeAliasStub;", "Lksp/org/jetbrains/kotlin/psi/KtTypeAlias;", "debugName", "", "<init>", "(Ljava/lang/String;)V", "createStub", "psi", "parentStub", "Lksp/com/intellij/psi/stubs/StubElement;", "serialize", "", "stub", "dataStream", "Lksp/com/intellij/psi/stubs/StubOutputStream;", "deserialize", "Lksp/com/intellij/psi/stubs/StubInputStream;", "indexStub", "sink", "Lksp/com/intellij/psi/stubs/IndexSink;"})
public final class KtTypeAliasElementType
extends KtStubElementType<KotlinTypeAliasStub, KtTypeAlias> {
    public KtTypeAliasElementType(@NotNull String debugName) {
        Intrinsics.checkNotNullParameter((Object)debugName, (String)"debugName");
        super(debugName, KtTypeAlias.class, KotlinTypeAliasStub.class);
    }

    @Override
    @NotNull
    public KotlinTypeAliasStub createStub(@NotNull KtTypeAlias psi, @NotNull StubElement<?> parentStub) {
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        Intrinsics.checkNotNullParameter(parentStub, (String)"parentStub");
        StringRef name2 = StringRef.fromString(psi.getName());
        FqName fqName = KtPsiUtilKt.safeFqNameForLazyResolve(psi);
        StringRef fqName2 = StringRef.fromString(fqName != null ? fqName.asString() : null);
        ClassId classId = StubUtils.createNestedClassId(parentStub, psi);
        boolean isTopLevel = psi.isTopLevel();
        return new KotlinTypeAliasStubImpl(parentStub, name2, fqName2, classId, isTopLevel);
    }

    @Override
    public void serialize(@NotNull KotlinTypeAliasStub stub, @NotNull StubOutputStream dataStream) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        dataStream.writeName(stub.getName());
        FqName fqName = stub.getFqName();
        dataStream.writeName(fqName != null ? fqName.asString() : null);
        StubUtils.serializeClassId(dataStream, stub.getClassId());
        dataStream.writeBoolean(stub.isTopLevel());
    }

    @Override
    @NotNull
    public KotlinTypeAliasStub deserialize(@NotNull StubInputStream dataStream, @Nullable StubElement<?> parentStub) {
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        StringRef name2 = dataStream.readName();
        StringRef fqName = dataStream.readName();
        ClassId classId = StubUtils.deserializeClassId(dataStream);
        boolean isTopLevel = dataStream.readBoolean();
        return new KotlinTypeAliasStubImpl(parentStub, name2, fqName, classId, isTopLevel);
    }

    @Override
    public void indexStub(@NotNull KotlinTypeAliasStub stub, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        StubIndexService.Companion.getInstance().indexTypeAlias(stub, sink);
    }
}

