/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.ir.util;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.ir.IrElement;
import ksp.org.jetbrains.kotlin.ir.IrElementBase;
import ksp.org.jetbrains.kotlin.ir.IrStatement;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFile;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBlock;
import ksp.org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import ksp.org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import ksp.org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import ksp.org.jetbrains.kotlin.ir.symbols.IrFileSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import ksp.org.jetbrains.kotlin.ir.types.IrType;
import ksp.org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import ksp.org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\t\u001a\u00020\n*\u00020\u0002\u001a\n\u0010\u000b\u001a\u00020\n*\u00020\u0002\u001a\u0014\u0010\u0016\u001a\u00020\n*\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0019\u001a\n\u0010\u001a\u001a\u00020\n*\u00020\u001b\u001a\n\u0010\u001c\u001a\u00020\n*\u00020\u001b\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\f\u001a\u00020\r*\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0011\"\u0017\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001d"}, d2={"inlineDeclaration", "Lksp/org/jetbrains/kotlin/ir/declarations/IrDeclaration;", "Lksp/org/jetbrains/kotlin/ir/expressions/IrInlinedFunctionBlock;", "getInlineDeclaration", "(Lorg/jetbrains/kotlin/ir/expressions/IrInlinedFunctionBlock;)Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "inlineFunction", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFunction;", "getInlineFunction", "(Lorg/jetbrains/kotlin/ir/expressions/IrInlinedFunctionBlock;)Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "isFunctionInlining", "", "isLambdaInlining", "innerInlinedBlockOrThis", "Lksp/org/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "getInnerInlinedBlockOrThis", "(Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;)Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "Lksp/org/jetbrains/kotlin/ir/expressions/IrReturnableBlock;", "(Lorg/jetbrains/kotlin/ir/expressions/IrReturnableBlock;)Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "sourceFileSymbol", "Lksp/org/jetbrains/kotlin/ir/symbols/IrFileSymbol;", "getSourceFileSymbol", "(Lorg/jetbrains/kotlin/ir/expressions/IrReturnableBlock;)Lorg/jetbrains/kotlin/ir/symbols/IrFileSymbol;", "isInlineParameter", "Lksp/org/jetbrains/kotlin/ir/declarations/IrValueParameter;", "type", "Lksp/org/jetbrains/kotlin/ir/types/IrType;", "isAdaptedFunctionReference", "Lksp/org/jetbrains/kotlin/ir/expressions/IrExpression;", "isLambdaBlock", "ir.tree"})
@SourceDebugExtension(value={"SMAP\nIrInlineUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrInlineUtils.kt\norg/jetbrains/kotlin/ir/util/IrInlineUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,55:1\n1#2:56\n*E\n"})
public final class IrInlineUtilsKt {
    @NotNull
    public static final IrDeclaration getInlineDeclaration(@NotNull IrInlinedFunctionBlock $this$inlineDeclaration) {
        IrDeclaration irDeclaration2;
        Intrinsics.checkNotNullParameter((Object)$this$inlineDeclaration, (String)"<this>");
        IrElement element2 = $this$inlineDeclaration.getInlinedElement();
        if (element2 instanceof IrFunction) {
            irDeclaration2 = (IrDeclaration)element2;
        } else if (element2 instanceof IrFunctionExpression) {
            irDeclaration2 = ((IrFunctionExpression)element2).getFunction();
        } else if (element2 instanceof IrFunctionReference) {
            irDeclaration2 = ((IrFunctionSymbol)((IrFunctionReference)element2).getSymbol()).getOwner();
        } else if (element2 instanceof IrPropertyReference) {
            irDeclaration2 = (IrDeclaration)((IrPropertySymbol)((IrPropertyReference)element2).getSymbol()).getOwner();
        } else {
            throw new AssertionError((Object)("Not supported ir element for inlining " + DumpIrTreeKt.dump$default(element2, null, 1, null)));
        }
        return irDeclaration2;
    }

    private static final IrFunction getInlineFunction(IrInlinedFunctionBlock $this$inlineFunction) {
        IrFunction irFunction;
        IrElement element2 = $this$inlineFunction.getInlinedElement();
        if (element2 instanceof IrFunction) {
            irFunction = (IrFunction)element2;
        } else if (element2 instanceof IrFunctionExpression) {
            irFunction = ((IrFunctionExpression)element2).getFunction();
        } else if (element2 instanceof IrFunctionReference) {
            IrFunction irFunction2;
            IrFunction it = irFunction2 = ((IrFunctionSymbol)((IrFunctionReference)element2).getSymbol()).getOwner();
            boolean bl = false;
            irFunction = it.isInline() ? irFunction2 : null;
        } else {
            irFunction = null;
        }
        return irFunction;
    }

    public static final boolean isFunctionInlining(@NotNull IrInlinedFunctionBlock $this$isFunctionInlining) {
        Intrinsics.checkNotNullParameter((Object)$this$isFunctionInlining, (String)"<this>");
        return $this$isFunctionInlining.getInlinedElement() instanceof IrFunction;
    }

    public static final boolean isLambdaInlining(@NotNull IrInlinedFunctionBlock $this$isLambdaInlining) {
        Intrinsics.checkNotNullParameter((Object)$this$isLambdaInlining, (String)"<this>");
        return !IrInlineUtilsKt.isFunctionInlining($this$isLambdaInlining);
    }

    @NotNull
    public static final IrContainerExpression getInnerInlinedBlockOrThis(@NotNull IrContainerExpression $this$innerInlinedBlockOrThis) {
        Intrinsics.checkNotNullParameter((Object)$this$innerInlinedBlockOrThis, (String)"<this>");
        Object object = $this$innerInlinedBlockOrThis instanceof IrReturnableBlock ? (IrReturnableBlock)$this$innerInlinedBlockOrThis : null;
        IrStatement irStatement = object != null && (object = object.getStatements()) != null ? (IrStatement)CollectionsKt.singleOrNull((List)object) : null;
        IrInlinedFunctionBlock irInlinedFunctionBlock = irStatement instanceof IrInlinedFunctionBlock ? (IrInlinedFunctionBlock)irStatement : null;
        return irInlinedFunctionBlock != null ? (IrContainerExpression)irInlinedFunctionBlock : $this$innerInlinedBlockOrThis;
    }

    @Nullable
    public static final IrFunction getInlineFunction(@NotNull IrReturnableBlock $this$inlineFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$inlineFunction, (String)"<this>");
        Object object = CollectionsKt.singleOrNull($this$inlineFunction.getStatements());
        IrInlinedFunctionBlock irInlinedFunctionBlock = object instanceof IrInlinedFunctionBlock ? (IrInlinedFunctionBlock)object : null;
        return irInlinedFunctionBlock != null ? IrInlineUtilsKt.getInlineFunction(irInlinedFunctionBlock) : null;
    }

    @Nullable
    public static final IrFileSymbol getSourceFileSymbol(@NotNull IrReturnableBlock $this$sourceFileSymbol) {
        Intrinsics.checkNotNullParameter((Object)$this$sourceFileSymbol, (String)"<this>");
        IrElementBase irElementBase = IrInlineUtilsKt.getInlineFunction($this$sourceFileSymbol);
        return irElementBase != null && (irElementBase = IrUtilsKt.getFileOrNull((IrDeclaration)((Object)irElementBase))) != null ? ((IrFile)irElementBase).getSymbol() : null;
    }

    public static final boolean isInlineParameter(@NotNull IrValueParameter $this$isInlineParameter, @NotNull IrType type2) {
        Intrinsics.checkNotNullParameter((Object)$this$isInlineParameter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        return $this$isInlineParameter.getIndex() >= 0 && !$this$isInlineParameter.isNoinline() && !ksp.org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable(type2) && (IrTypeUtilsKt.isFunction(type2) || IrTypeUtilsKt.isSuspendFunction(type2));
    }

    public static /* synthetic */ boolean isInlineParameter$default(IrValueParameter irValueParameter, IrType irType, int n, Object object) {
        if ((n & 1) != 0) {
            irType = irValueParameter.getType();
        }
        return IrInlineUtilsKt.isInlineParameter(irValueParameter, irType);
    }

    public static final boolean isAdaptedFunctionReference(@NotNull IrExpression $this$isAdaptedFunctionReference) {
        Intrinsics.checkNotNullParameter((Object)$this$isAdaptedFunctionReference, (String)"<this>");
        return $this$isAdaptedFunctionReference instanceof IrBlock && Intrinsics.areEqual((Object)((IrBlock)$this$isAdaptedFunctionReference).getOrigin(), (Object)IrStatementOrigin.Companion.getADAPTED_FUNCTION_REFERENCE());
    }

    public static final boolean isLambdaBlock(@NotNull IrExpression $this$isLambdaBlock) {
        Intrinsics.checkNotNullParameter((Object)$this$isLambdaBlock, (String)"<this>");
        return $this$isLambdaBlock instanceof IrBlock && Intrinsics.areEqual((Object)((IrBlock)$this$isLambdaBlock).getOrigin(), (Object)IrStatementOrigin.Companion.getLAMBDA());
    }
}

