/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.pom;

import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.platform.backend.navigation.NavigationRequest;
import ksp.com.intellij.platform.backend.navigation.NavigationRequests;
import ksp.com.intellij.util.IncorrectOperationException;
import ksp.com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import ksp.com.intellij.util.concurrency.annotations.RequiresReadLock;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.Nullable;

public interface Navigatable {
    public static final Navigatable[] EMPTY_NAVIGATABLE_ARRAY = new Navigatable[0];

    @ApiStatus.Experimental
    @RequiresReadLock
    @RequiresBackgroundThread
    @Nullable
    default public NavigationRequest navigationRequest() {
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        return NavigationRequests.getInstance().rawNavigationRequest(this);
    }

    default public void navigate(boolean requestFocus) {
        throw new IncorrectOperationException("Must not call `navigate(boolean)` if `canNavigate()` returns `false`, or `navigate(boolean)` should be overridden if `canNavigate()` can return `true`.");
    }

    default public boolean canNavigate() {
        return false;
    }

    default public boolean canNavigateToSource() {
        return false;
    }
}

