/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.descriptors.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.resolve.scopes.DescriptorKindExclude;
import ksp.org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import ksp.org.jetbrains.kotlin.resolve.scopes.MemberScopeImpl;
import ksp.org.jetbrains.kotlin.utils.Printer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0004J*\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lksp/org/jetbrains/kotlin/descriptors/impl/SubpackagesScope;", "Lksp/org/jetbrains/kotlin/resolve/scopes/MemberScopeImpl;", "moduleDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/ModuleDescriptor;", "fqName", "Lksp/org/jetbrains/kotlin/name/FqName;", "<init>", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/name/FqName;)V", "getPackage", "Lksp/org/jetbrains/kotlin/descriptors/PackageViewDescriptor;", "name", "Lksp/org/jetbrains/kotlin/name/Name;", "getContributedDescriptors", "", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "kindFilter", "Lksp/org/jetbrains/kotlin/resolve/scopes/DescriptorKindFilter;", "nameFilter", "Lkotlin/Function1;", "", "getClassifierNames", "", "printScopeStructure", "", "p", "Lksp/org/jetbrains/kotlin/utils/Printer;", "toString", "", "descriptors"})
public class SubpackagesScope
extends MemberScopeImpl {
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    @NotNull
    private final FqName fqName;

    public SubpackagesScope(@NotNull ModuleDescriptor moduleDescriptor, @NotNull FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        this.moduleDescriptor = moduleDescriptor;
        this.fqName = fqName;
    }

    @Nullable
    protected final PackageViewDescriptor getPackage(@NotNull Name name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if (name2.isSpecial()) {
            return null;
        }
        FqName fqName = this.fqName.child(name2);
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"child(...)");
        PackageViewDescriptor packageViewDescriptor = this.moduleDescriptor.getPackage(fqName);
        if (packageViewDescriptor.isEmpty()) {
            return null;
        }
        return packageViewDescriptor;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getContributedDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, Boolean> nameFilter) {
        Intrinsics.checkNotNullParameter((Object)kindFilter, (String)"kindFilter");
        Intrinsics.checkNotNullParameter(nameFilter, (String)"nameFilter");
        if (!kindFilter.acceptsKinds(DescriptorKindFilter.Companion.getPACKAGES_MASK())) {
            return CollectionsKt.emptyList();
        }
        if (this.fqName.isRoot() && kindFilter.getExcludes().contains(DescriptorKindExclude.TopLevelPackages.INSTANCE)) {
            return CollectionsKt.emptyList();
        }
        Collection<FqName> subFqNames = this.moduleDescriptor.getSubPackagesOf(this.fqName, nameFilter);
        ArrayList result2 = new ArrayList(subFqNames.size());
        for (FqName subFqName : subFqNames) {
            Name shortName2;
            Intrinsics.checkNotNullExpressionValue((Object)subFqName.shortName(), (String)"shortName(...)");
            if (!((Boolean)nameFilter.invoke((Object)shortName2)).booleanValue()) continue;
            ksp.org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(result2, this.getPackage(shortName2));
        }
        return result2;
    }

    @Override
    @NotNull
    public Set<Name> getClassifierNames() {
        return SetsKt.emptySet();
    }

    @Override
    public void printScopeStructure(@NotNull Printer p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Object[] objectArray = new Object[]{this.getClass().getSimpleName(), " {"};
        p.println(objectArray);
        p.pushIndent();
        p.popIndent();
        objectArray = new Object[]{"}"};
        p.println(objectArray);
    }

    @NotNull
    public String toString() {
        return "subpackages of " + this.fqName + " from " + this.moduleDescriptor;
    }
}

