/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.incremental.storage;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.incremental.storage.InMemoryStorageInterface;
import ksp.org.jetbrains.kotlin.incremental.storage.PersistentStorage;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B\u001b\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0018\u0010 \u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001e\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010!J\u001e\u0010\"\u001a\u00020#2\u0006\u0010\u001e\u001a\u00028\u00002\u0006\u0010$\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010%J\u0015\u0010&\u001a\u00020#2\u0006\u0010\u001e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010'J\b\u0010(\u001a\u00020#H\u0016J\b\u0010)\u001a\u00020#H\u0016J\b\u0010*\u001a\u00020#H\u0016J\b\u0010+\u001a\u00020#H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR \u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006,"}, d2={"Lksp/org/jetbrains/kotlin/incremental/storage/InMemoryStorage;", "KEY", "VALUE", "Lksp/org/jetbrains/kotlin/incremental/storage/InMemoryStorageInterface;", "storage", "Lksp/org/jetbrains/kotlin/incremental/storage/PersistentStorage;", "<init>", "(Lorg/jetbrains/kotlin/incremental/storage/PersistentStorage;)V", "storageFile", "Ljava/io/File;", "getStorageFile", "()Ljava/io/File;", "addedEntries", "Ljava/util/LinkedHashMap;", "getAddedEntries", "()Ljava/util/LinkedHashMap;", "modifiedEntries", "getModifiedEntries", "appendedEntries", "getAppendedEntries", "removedKeys", "Ljava/util/LinkedHashSet;", "getRemovedKeys", "()Ljava/util/LinkedHashSet;", "keys", "", "getKeys", "()Ljava/util/Set;", "contains", "", "key", "(Ljava/lang/Object;)Z", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "set", "", "value", "(Ljava/lang/Object;Ljava/lang/Object;)V", "remove", "(Ljava/lang/Object;)V", "applyChanges", "clearChanges", "flush", "close", "kotlin-build-common"})
@SourceDebugExtension(value={"SMAP\nInMemoryStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InMemoryStorage.kt\norg/jetbrains/kotlin/incremental/storage/InMemoryStorage\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,179:1\n216#2,2:180\n216#2,2:182\n1863#3,2:184\n*S KotlinDebug\n*F\n+ 1 InMemoryStorage.kt\norg/jetbrains/kotlin/incremental/storage/InMemoryStorage\n*L\n107#1:180,2\n110#1:182,2\n114#1:184,2\n*E\n"})
public class InMemoryStorage<KEY, VALUE>
implements InMemoryStorageInterface<KEY, VALUE> {
    @NotNull
    private final PersistentStorage<KEY, VALUE> storage;
    @NotNull
    private final File storageFile;
    @NotNull
    private final LinkedHashMap<KEY, VALUE> addedEntries;
    @NotNull
    private final LinkedHashMap<KEY, VALUE> modifiedEntries;
    @NotNull
    private final LinkedHashMap<KEY, VALUE> appendedEntries;
    @NotNull
    private final LinkedHashSet<KEY> removedKeys;

    public InMemoryStorage(@NotNull PersistentStorage<KEY, VALUE> storage) {
        Intrinsics.checkNotNullParameter(storage, (String)"storage");
        this.storage = storage;
        this.storageFile = this.storage.getStorageFile();
        this.addedEntries = new LinkedHashMap();
        this.modifiedEntries = new LinkedHashMap();
        this.appendedEntries = new LinkedHashMap();
        this.removedKeys = new LinkedHashSet();
    }

    @Override
    @NotNull
    public File getStorageFile() {
        return this.storageFile;
    }

    @NotNull
    protected final LinkedHashMap<KEY, VALUE> getAddedEntries() {
        return this.addedEntries;
    }

    @NotNull
    protected final LinkedHashMap<KEY, VALUE> getModifiedEntries() {
        return this.modifiedEntries;
    }

    @NotNull
    protected final LinkedHashMap<KEY, VALUE> getAppendedEntries() {
        return this.appendedEntries;
    }

    @NotNull
    protected final LinkedHashSet<KEY> getRemovedKeys() {
        return this.removedKeys;
    }

    @Override
    @NotNull
    public synchronized Set<KEY> getKeys() {
        Set<KEY> set = this.storage.getKeys();
        Set<KEY> set2 = this.addedEntries.keySet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-keys>(...)");
        return SetsKt.minus((Set)SetsKt.plus(set, (Iterable)set2), (Iterable)this.removedKeys);
    }

    @Override
    public synchronized boolean contains(KEY key) {
        KEY KEY = key;
        return ((Map)this.addedEntries).containsKey(KEY) ? true : (((Map)this.modifiedEntries).containsKey(KEY) ? true : (((Map)this.appendedEntries).containsKey(KEY) ? true : (this.removedKeys.contains(KEY) ? false : this.storage.contains(key))));
    }

    @Override
    @Nullable
    public synchronized VALUE get(KEY key) {
        Object object = this.addedEntries.get(key);
        if (object == null && (object = this.modifiedEntries.get(key)) == null) {
            KEY KEY = key;
            object = this.removedKeys.contains(KEY) ? null : this.storage.get(key);
        }
        return object;
    }

    @Override
    public synchronized void set(KEY key, VALUE value2) {
        KEY KEY = key;
        if (((Map)this.addedEntries).containsKey(KEY)) {
            ((Map)this.addedEntries).put(key, value2);
        } else if (((Map)this.modifiedEntries).containsKey(KEY)) {
            ((Map)this.modifiedEntries).put(key, value2);
        } else if (((Map)this.appendedEntries).containsKey(KEY)) {
            this.appendedEntries.remove(key);
            ((Map)this.modifiedEntries).put(key, value2);
        } else if (this.removedKeys.contains(KEY)) {
            this.removedKeys.remove(key);
            ((Map)this.modifiedEntries).put(key, value2);
        } else if (this.storage.contains(KEY)) {
            ((Map)this.modifiedEntries).put(key, value2);
        } else {
            ((Map)this.addedEntries).put(key, value2);
        }
    }

    @Override
    public synchronized void remove(KEY key) {
        block1: {
            KEY KEY;
            block3: {
                block2: {
                    block0: {
                        KEY = key;
                        if (!((Map)this.addedEntries).containsKey(KEY)) break block0;
                        this.addedEntries.remove(key);
                        break block1;
                    }
                    if (!((Map)this.modifiedEntries).containsKey(KEY)) break block2;
                    this.modifiedEntries.remove(key);
                    this.removedKeys.add(key);
                    break block1;
                }
                if (!((Map)this.appendedEntries).containsKey(KEY)) break block3;
                this.appendedEntries.remove(key);
                this.removedKeys.add(key);
                break block1;
            }
            if (this.removedKeys.contains(KEY) || !this.storage.contains(KEY)) break block1;
            this.removedKeys.add(key);
        }
    }

    @Override
    public synchronized void applyChanges() {
        Map.Entry it;
        Map.Entry element$iv;
        Object $this$forEach$iv = this.addedEntries;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            it = element$iv = iterator2.next();
            boolean bl = false;
            this.storage.set(it.getKey(), it.getValue());
        }
        $this$forEach$iv = this.modifiedEntries;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            it = element$iv = iterator2.next();
            boolean bl = false;
            this.storage.set(it.getKey(), it.getValue());
        }
        $this$forEach$iv = this.removedKeys;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            it = element$iv = iterator2.next();
            boolean bl = false;
            this.storage.remove(it);
        }
        this.clearChanges();
    }

    @Override
    public synchronized void clearChanges() {
        this.addedEntries.clear();
        this.modifiedEntries.clear();
        this.appendedEntries.clear();
        this.removedKeys.clear();
    }

    @Override
    public synchronized void flush() {
        this.applyChanges();
        this.storage.flush();
    }

    @Override
    public synchronized void close() {
        this.applyChanges();
        this.storage.close();
    }
}

