/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import ksp.org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirEnumClassSimpleChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirRegularClass;", "<init>", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirEnumClassSimpleChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirEnumClassSimpleChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirEnumClassSimpleChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,39:1\n60#2:40\n37#3:41\n1#4:42\n*S KotlinDebug\n*F\n+ 1 FirEnumClassSimpleChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirEnumClassSimpleChecker\n*L\n23#1:40\n23#1:41\n*E\n"})
public final class FirEnumClassSimpleChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirEnumClassSimpleChecker INSTANCE = new FirEnumClassSimpleChecker();

    private FirEnumClassSimpleChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirRegularClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirClass $this$isEnumClass$iv = declaration2;
        boolean $i$f$isEnumClass = false;
        ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
        boolean $i$f$isEnumClass2 = false;
        if (!($this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS)) {
            return;
        }
        FirTypeRef firTypeRef = FirHelpersKt.findNonInterfaceSupertype(declaration2, context2);
        if (firTypeRef != null) {
            FirTypeRef firTypeRef2;
            FirTypeRef firTypeRef3;
            FirTypeRef it = firTypeRef3 = firTypeRef;
            boolean bl = false;
            FirTypeRef firTypeRef4 = firTypeRef2 = !Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId(TypeExpansionUtilsKt.fullyExpandedType$default(FirTypeUtilsKt.getConeType(it), context2.getSession(), null, 2, null)), (Object)StandardClassIds.INSTANCE.getEnum()) ? firTypeRef3 : null;
            if (firTypeRef2 != null) {
                it = firTypeRef2;
                boolean bl2 = false;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it.getSource(), FirErrors.INSTANCE.getCLASS_IN_SUPERTYPE_FOR_ENUM(), (DiagnosticContext)context2, null, 8, null);
            }
        }
        if (!((Collection)declaration2.getTypeParameters()).isEmpty()) {
            FirTypeParameterRef firTypeParameterRef = (FirTypeParameterRef)CollectionsKt.firstOrNull(declaration2.getTypeParameters());
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)(firTypeParameterRef != null ? firTypeParameterRef.getSource() : null), FirErrors.INSTANCE.getTYPE_PARAMETERS_IN_ENUM(), (DiagnosticContext)context2, null, 8, null);
        }
    }
}

