/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.analysis.api.fir;

import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KDeclarationContainer;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.util.LowMemoryWatcher;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.analysis.api.KaSession;
import ksp.org.jetbrains.kotlin.analysis.api.fir.KaFirSession;
import ksp.org.jetbrains.kotlin.analysis.api.fir.KtFirAnalysisSessionProviderKt;
import ksp.org.jetbrains.kotlin.analysis.api.impl.base.sessions.KaBaseSessionProvider;
import ksp.org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeToken;
import ksp.org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.api.LLFirResolveSession;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.api.LowLevelFirApiFacadeKt;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSessionInvalidationListener;
import ksp.org.jetbrains.kotlin.analysis.project.structure.KtDanglingFileModule;
import ksp.org.jetbrains.kotlin.analysis.project.structure.KtModule;
import ksp.org.jetbrains.kotlin.analysis.project.structure.KtModuleKt;
import ksp.org.jetbrains.kotlin.analysis.project.structure.ProjectStructureProvider;
import ksp.org.jetbrains.kotlin.psi.KtElement;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\bH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\bH\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lksp/org/jetbrains/kotlin/analysis/api/fir/KaFirSessionProvider;", "Lksp/org/jetbrains/kotlin/analysis/api/impl/base/sessions/KaBaseSessionProvider;", "project", "Lksp/com/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Ljava/util/concurrent/ConcurrentMap;", "Lksp/org/jetbrains/kotlin/analysis/project/structure/KtModule;", "Lksp/org/jetbrains/kotlin/analysis/api/KaSession;", "getAnalysisSession", "useSiteKtElement", "Lksp/org/jetbrains/kotlin/psi/KtElement;", "getAnalysisSessionByUseSiteKtModule", "useSiteKtModule", "createAnalysisSession", "Lksp/org/jetbrains/kotlin/analysis/api/fir/KaFirSession;", "clearCaches", "", "SessionInvalidationListener", "analysis-api-fir"})
public final class KaFirSessionProvider
extends KaBaseSessionProvider {
    @NotNull
    private final ConcurrentMap<KtModule, KaSession> cache;

    public KaFirSessionProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentSoftValueMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap, (String)"createConcurrentSoftValueMap(...)");
        this.cache = concurrentMap;
        LowMemoryWatcher.register(this::clearCaches, project);
    }

    @Override
    @NotNull
    public KaSession getAnalysisSession(@NotNull KtElement useSiteKtElement) {
        Intrinsics.checkNotNullParameter((Object)useSiteKtElement, (String)"useSiteKtElement");
        KtModule module2 = ProjectStructureProvider.Companion.getModule(this.getProject(), useSiteKtElement, null);
        return this.getAnalysisSessionByUseSiteKtModule(module2);
    }

    @Override
    @NotNull
    public KaSession getAnalysisSessionByUseSiteKtModule(@NotNull KtModule useSiteKtModule) {
        Intrinsics.checkNotNullParameter((Object)useSiteKtModule, (String)"useSiteKtModule");
        if (useSiteKtModule instanceof KtDanglingFileModule && !KtModuleKt.isStable((KtDanglingFileModule)useSiteKtModule)) {
            return this.createAnalysisSession(useSiteKtModule);
        }
        KClass<? extends KaLifetimeToken> identifier = this.getTokenFactory().getIdentifier();
        KtFirAnalysisSessionProviderKt.access$flushPendingChanges(identifier, this.getProject());
        KaSession kaSession = this.cache.computeIfAbsent(useSiteKtModule, arg_0 -> KaFirSessionProvider.getAnalysisSessionByUseSiteKtModule$lambda$0((Function1)new Function1<KtModule, KaFirSession>((Object)this){

            public final KaFirSession invoke(KtModule p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return KaFirSessionProvider.access$createAnalysisSession((KaFirSessionProvider)this.receiver, p0);
            }

            public final String getSignature() {
                return "createAnalysisSession(Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;)Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;";
            }

            public final String getName() {
                return "createAnalysisSession";
            }

            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(KaFirSessionProvider.class);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)kaSession, (String)"computeIfAbsent(...)");
        return kaSession;
    }

    private final KaFirSession createAnalysisSession(KtModule useSiteKtModule) {
        LLFirResolveSession firResolveSession = LowLevelFirApiFacadeKt.getFirResolveSession(useSiteKtModule, this.getProject());
        KaLifetimeToken validityToken = this.getTokenFactory().create(this.getProject(), firResolveSession.getUseSiteFirSession().createValidityTracker());
        return KaFirSession.Companion.createAnalysisSessionByFirResolveSession$analysis_api_fir(firResolveSession, validityToken);
    }

    @Override
    public void clearCaches() {
        this.cache.clear();
    }

    private static final KaSession getAnalysisSessionByUseSiteKtModule$lambda$0(Function1 $tmp0, Object p0) {
        return (KaSession)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ KaFirSession access$createAnalysisSession(KaFirSessionProvider $this, KtModule useSiteKtModule) {
        return $this.createAnalysisSession(useSiteKtModule);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\b\u0010\u0011\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lksp/org/jetbrains/kotlin/analysis/api/fir/KaFirSessionProvider$SessionInvalidationListener;", "Lksp/org/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionInvalidationListener;", "project", "Lksp/com/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "analysisSessionProvider", "Lksp/org/jetbrains/kotlin/analysis/api/fir/KaFirSessionProvider;", "getAnalysisSessionProvider", "()Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSessionProvider;", "afterInvalidation", "", "modules", "", "Lksp/org/jetbrains/kotlin/analysis/project/structure/KtModule;", "afterGlobalInvalidation", "analysis-api-fir"})
    @SourceDebugExtension(value={"SMAP\nKtFirAnalysisSessionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtFirAnalysisSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/fir/KaFirSessionProvider$SessionInvalidationListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n1863#2,2:102\n*S KotlinDebug\n*F\n+ 1 KtFirAnalysisSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/fir/KaFirSessionProvider$SessionInvalidationListener\n*L\n77#1:102,2\n*E\n"})
    public static final class SessionInvalidationListener
    implements LLFirSessionInvalidationListener {
        @NotNull
        private final Project project;

        public SessionInvalidationListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        private final KaFirSessionProvider getAnalysisSessionProvider() {
            KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(this.project);
            KaFirSessionProvider kaFirSessionProvider = kaSessionProvider instanceof KaFirSessionProvider ? (KaFirSessionProvider)kaSessionProvider : null;
            if (kaFirSessionProvider == null) {
                throw new IllegalStateException(("Expected the analysis session provider to be a `" + Reflection.getOrCreateKotlinClass(KaFirSessionProvider.class).getSimpleName() + "`.").toString());
            }
            return kaFirSessionProvider;
        }

        @Override
        public void afterInvalidation(@NotNull Set<? extends KtModule> modules) {
            Intrinsics.checkNotNullParameter(modules, (String)"modules");
            Iterable $this$forEach$iv = modules;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtModule it = (KtModule)element$iv;
                boolean bl = false;
                this.getAnalysisSessionProvider().cache.remove(it);
            }
        }

        @Override
        public void afterGlobalInvalidation() {
            this.getAnalysisSessionProvider().clearCaches();
        }
    }
}

