/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.resolve.diagnostics;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.builtins.FunctionTypesKt;
import ksp.org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import ksp.org.jetbrains.kotlin.builtins.StandardNames;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.MemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import ksp.org.jetbrains.kotlin.js.common.IdentifierPolicyKt;
import ksp.org.jetbrains.kotlin.js.naming.NameSuggestion;
import ksp.org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import ksp.org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import ksp.org.jetbrains.kotlin.name.SpecialNames;
import ksp.org.jetbrains.kotlin.psi.KtAnnotationEntry;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtElement;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtNamedDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtParameter;
import ksp.org.jetbrains.kotlin.psi.KtValueArgument;
import ksp.org.jetbrains.kotlin.psi.KtValueArgumentList;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.BindingTrace;
import ksp.org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import ksp.org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.inline.InlineOnlyKt;
import ksp.org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import ksp.org.jetbrains.kotlin.types.DynamicTypesKt;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.TypeProjection;
import ksp.org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J$\u0010\u000f\u001a\u00020\u0003*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014H\u0002J$\u0010\u0015\u001a\u00020\u0003*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014H\u0002J \u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\f\u0010\u001a\u001a\u00020\u001b*\u00020\fH\u0002J\f\u0010\u001c\u001a\u00020\u001d*\u00020\nH\u0002J\u000e\u0010\u001e\u001a\u0004\u0018\u00010\u001d*\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lksp/org/jetbrains/kotlin/js/resolve/diagnostics/JsExportDeclarationChecker;", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "includeUnsignedNumbers", "", "allowCompanionInInterface", "<init>", "(ZZ)V", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "isExportableReturn", "Lksp/org/jetbrains/kotlin/types/KotlinType;", "bindingContext", "Lksp/org/jetbrains/kotlin/resolve/BindingContext;", "currentlyProcessed", "", "isExportable", "validateDeclarationOnConsumableName", "declarationDescriptor", "trace", "Lksp/org/jetbrains/kotlin/resolve/BindingTrace;", "getKotlinOrJsName", "", "getIdentifier", "Lksp/com/intellij/psi/PsiElement;", "getJsNameArgument", "js.frontend"})
public final class JsExportDeclarationChecker
implements DeclarationChecker {
    private final boolean includeUnsignedNumbers;
    private final boolean allowCompanionInInterface;

    public JsExportDeclarationChecker(boolean includeUnsignedNumbers, boolean allowCompanionInInterface) {
        this.includeUnsignedNumbers = includeUnsignedNumbers;
        this.allowCompanionInInterface = allowCompanionInInterface;
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context2) {
        boolean hasJsName;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        BindingTrace trace = context2.getTrace();
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        BindingContext bindingContext2 = bindingContext;
        if (!AnnotationsUtils.isExportedObject(descriptor, bindingContext2)) {
            return;
        }
        if (!(descriptor instanceof MemberDescriptor)) {
            return;
        }
        boolean bl = hasJsName = AnnotationsUtils.getJsNameAnnotation(descriptor) != null;
        if (((MemberDescriptor)descriptor).isExpect()) {
            JsExportDeclarationChecker.check$reportWrongExportedDeclaration(trace, declaration2, "expect");
        }
        this.validateDeclarationOnConsumableName(declaration2, descriptor, trace);
        MemberDescriptor memberDescriptor = (MemberDescriptor)descriptor;
        if (memberDescriptor instanceof FunctionDescriptor) {
            for (TypeParameterDescriptor typeParameter : ((FunctionDescriptor)descriptor).getTypeParameters()) {
                Intrinsics.checkNotNull((Object)typeParameter);
                JsExportDeclarationChecker.check$checkTypeParameter(this, bindingContext2, trace, typeParameter);
            }
            if (InlineOnlyKt.isInlineWithReified((MemberDescriptor)descriptor)) {
                JsExportDeclarationChecker.check$reportWrongExportedDeclaration(trace, declaration2, "inline function with reified type parameters");
                return;
            }
            if (((FunctionDescriptor)descriptor).isSuspend()) {
                JsExportDeclarationChecker.check$reportWrongExportedDeclaration(trace, declaration2, "suspend function");
                return;
            }
            if (descriptor instanceof ConstructorDescriptor && !((ConstructorDescriptor)descriptor).isPrimary() && !hasJsName) {
                JsExportDeclarationChecker.check$reportWrongExportedDeclaration(trace, declaration2, "secondary constructor without @JsName");
            }
            if (!(descriptor instanceof PropertyAccessorDescriptor)) {
                for (ValueParameterDescriptor parameter2 : ((FunctionDescriptor)descriptor).getValueParameters()) {
                    Intrinsics.checkNotNull((Object)parameter2);
                    JsExportDeclarationChecker.check$checkValueParameter(this, bindingContext2, trace, parameter2);
                }
                KotlinType kotlinType = ((FunctionDescriptor)descriptor).getReturnType();
                if (kotlinType != null) {
                    KotlinType returnType2 = kotlinType;
                    boolean bl2 = false;
                    if (!JsExportDeclarationChecker.isExportableReturn$default(this, returnType2, bindingContext2, null, 2, null)) {
                        trace.report(ErrorsJs.NON_EXPORTABLE_TYPE.on(declaration2, "return", returnType2));
                    }
                }
            }
        } else if (memberDescriptor instanceof PropertyDescriptor) {
            if (declaration2 instanceof KtParameter) {
                return;
            }
            if (DescriptorUtilsKt.isExtensionProperty(descriptor)) {
                JsExportDeclarationChecker.check$reportWrongExportedDeclaration(trace, declaration2, "extension property");
                return;
            }
            KotlinType kotlinType = ((PropertyDescriptor)descriptor).getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            if (!JsExportDeclarationChecker.isExportable$default(this, kotlinType, bindingContext2, null, 2, null)) {
                trace.report(ErrorsJs.NON_EXPORTABLE_TYPE.on(declaration2, "property", ((PropertyDescriptor)descriptor).getType()));
            }
        } else if (memberDescriptor instanceof ClassDescriptor) {
            String wrongDeclaration;
            for (TypeParameterDescriptor typeParameter : ((ClassDescriptor)descriptor).getDeclaredTypeParameters()) {
                Intrinsics.checkNotNull((Object)typeParameter);
                JsExportDeclarationChecker.check$checkTypeParameter(this, bindingContext2, trace, typeParameter);
            }
            switch (WhenMappings.$EnumSwitchMapping$0[((ClassDescriptor)descriptor).getKind().ordinal()]) {
                case 1: {
                    String string2 = "annotation class";
                    break;
                }
                case 2: {
                    String string2;
                    if (DescriptorUtilsKt.isInsideInterface(descriptor)) {
                        string2 = "nested class inside exported interface";
                        break;
                    }
                    if (InlineClassesUtilsKt.isInlineClass(descriptor)) {
                        string2 = (((ClassDescriptor)descriptor).isInline() ? "inline " : "") + (((ClassDescriptor)descriptor).isValue() ? "value " : "") + "class";
                        break;
                    }
                    string2 = null;
                    break;
                }
                default: {
                    String string2 = DescriptorUtilsKt.isInsideInterface(descriptor) && (!this.allowCompanionInInterface || !((ClassDescriptor)descriptor).isCompanionObject()) ? (((ClassDescriptor)descriptor).isCompanionObject() ? "companion object" : "nested/inner declaration") + " inside exported interface" : (wrongDeclaration = null);
                }
            }
            if (this.allowCompanionInInterface && ((ClassDescriptor)descriptor).isCompanionObject() && DescriptorUtilsKt.isInsideInterface(descriptor) && !Intrinsics.areEqual((Object)((ClassDescriptor)descriptor).getName(), (Object)SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT)) {
                trace.report(ErrorsJs.NAMED_COMPANION_IN_EXPORTED_INTERFACE.on((KtElement)((PsiElement)declaration2)));
            }
            if (wrongDeclaration != null) {
                JsExportDeclarationChecker.check$reportWrongExportedDeclaration(trace, declaration2, wrongDeclaration);
                return;
            }
            if (((ClassDescriptor)descriptor).getKind() == ClassKind.ENUM_ENTRY) {
                return;
            }
        }
    }

    private final boolean isExportableReturn(KotlinType $this$isExportableReturn, BindingContext bindingContext, Set<KotlinType> currentlyProcessed) {
        return TypeUtilsKt.isUnit($this$isExportableReturn) || this.isExportable($this$isExportableReturn, bindingContext, currentlyProcessed);
    }

    static /* synthetic */ boolean isExportableReturn$default(JsExportDeclarationChecker jsExportDeclarationChecker, KotlinType kotlinType, BindingContext bindingContext, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = new LinkedHashSet();
        }
        return jsExportDeclarationChecker.isExportableReturn(kotlinType, bindingContext, set);
    }

    private final boolean isExportable(KotlinType $this$isExportable, BindingContext bindingContext, Set<KotlinType> currentlyProcessed) {
        boolean isPrimitiveExportableType;
        if (!currentlyProcessed.add($this$isExportable)) {
            return true;
        }
        currentlyProcessed.add($this$isExportable);
        if (FunctionTypesKt.isFunctionType($this$isExportable)) {
            int n = CollectionsKt.getLastIndex($this$isExportable.getArguments());
            for (int i = 0; i < n; ++i) {
                KotlinType kotlinType = $this$isExportable.getArguments().get(i).getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
                if (this.isExportable(kotlinType, bindingContext, currentlyProcessed)) continue;
                currentlyProcessed.remove($this$isExportable);
                return false;
            }
            currentlyProcessed.remove($this$isExportable);
            KotlinType kotlinType = ((TypeProjection)CollectionsKt.last($this$isExportable.getArguments())).getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            return this.isExportableReturn(kotlinType, bindingContext, currentlyProcessed);
        }
        for (TypeProjection argument : $this$isExportable.getArguments()) {
            KotlinType kotlinType = argument.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            if (this.isExportable(kotlinType, bindingContext, currentlyProcessed)) continue;
            currentlyProcessed.remove($this$isExportable);
            return false;
        }
        currentlyProcessed.remove($this$isExportable);
        KotlinType nonNullable = TypeUtilsKt.makeNotNullable($this$isExportable);
        boolean bl = isPrimitiveExportableType = TypeUtilsKt.isAnyOrNullableAny(nonNullable) || TypeUtilsKt.isTypeParameter(nonNullable) || DynamicTypesKt.isDynamic(nonNullable) || TypeUtilsKt.isBoolean(nonNullable) || KotlinBuiltIns.isThrowableOrNullableThrowable(nonNullable) || KotlinBuiltIns.isString(nonNullable) || TypeUtilsKt.isPrimitiveNumberOrNullableType(nonNullable) && !TypeUtilsKt.isLong(nonNullable) || TypeUtilsKt.isNothingOrNullableNothing(nonNullable) || this.includeUnsignedNumbers && KotlinBuiltIns.isUnsignedNumber(nonNullable) || KotlinBuiltIns.isArray($this$isExportable) || KotlinBuiltIns.isPrimitiveArray($this$isExportable) || KotlinBuiltIns.isConstructedFromGivenClass($this$isExportable, StandardNames.FqNames.list) || KotlinBuiltIns.isConstructedFromGivenClass($this$isExportable, StandardNames.FqNames.mutableList) || KotlinBuiltIns.isConstructedFromGivenClass($this$isExportable, StandardNames.FqNames.set) || KotlinBuiltIns.isConstructedFromGivenClass($this$isExportable, StandardNames.FqNames.mutableSet) || KotlinBuiltIns.isConstructedFromGivenClass($this$isExportable, StandardNames.FqNames.map) || KotlinBuiltIns.isConstructedFromGivenClass($this$isExportable, StandardNames.FqNames.mutableMap);
        if (isPrimitiveExportableType) {
            return true;
        }
        ClassifierDescriptor descriptor = $this$isExportable.getConstructor().getDeclarationDescriptor();
        if (!(descriptor instanceof MemberDescriptor)) {
            return false;
        }
        if (KotlinBuiltIns.isEnum($this$isExportable)) {
            return true;
        }
        return DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)((Object)descriptor)) || AnnotationsUtils.isExportedObject(descriptor, bindingContext);
    }

    static /* synthetic */ boolean isExportable$default(JsExportDeclarationChecker jsExportDeclarationChecker, KotlinType kotlinType, BindingContext bindingContext, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = new LinkedHashSet();
        }
        return jsExportDeclarationChecker.isExportable(kotlinType, bindingContext, set);
    }

    private final void validateDeclarationOnConsumableName(KtDeclaration declaration2, DeclarationDescriptor declarationDescriptor, BindingTrace trace) {
        if (!DescriptorUtilKt.isTopLevelInPackage(declarationDescriptor) || declarationDescriptor.getName().isSpecial()) {
            return;
        }
        String name2 = this.getKotlinOrJsName(declarationDescriptor);
        if (IdentifierPolicyKt.getSPECIAL_KEYWORDS().contains(name2) || !IdentifierPolicyKt.getRESERVED_KEYWORDS().contains(name2) && Intrinsics.areEqual((Object)NameSuggestion.Companion.sanitizeName(name2), (Object)name2)) {
            return;
        }
        PsiElement psiElement = this.getJsNameArgument(declarationDescriptor);
        if (psiElement == null) {
            psiElement = this.getIdentifier(declaration2);
        }
        PsiElement reportTarget = psiElement;
        trace.report(ErrorsJs.NON_CONSUMABLE_EXPORTED_IDENTIFIER.on(reportTarget, name2));
    }

    private final String getKotlinOrJsName(DeclarationDescriptor $this$getKotlinOrJsName) {
        String string2 = AnnotationsUtils.getJsName($this$getKotlinOrJsName);
        if (string2 == null) {
            String string3 = $this$getKotlinOrJsName.getName().getIdentifier();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getIdentifier(...)");
        }
        return string2;
    }

    private final PsiElement getIdentifier(KtDeclaration $this$getIdentifier) {
        Intrinsics.checkNotNull((Object)$this$getIdentifier, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedDeclaration");
        PsiElement psiElement = ((KtNamedDeclaration)$this$getIdentifier).getNameIdentifier();
        Intrinsics.checkNotNull((Object)psiElement);
        return psiElement;
    }

    private final PsiElement getJsNameArgument(DeclarationDescriptor $this$getJsNameArgument) {
        AnnotationDescriptor annotationDescriptor = AnnotationsUtils.getJsNameAnnotation($this$getJsNameArgument);
        if (annotationDescriptor == null) {
            return null;
        }
        AnnotationDescriptor jsNameAnnotation = annotationDescriptor;
        PsiElement psiElement = PsiSourceElementKt.getPsi(jsNameAnnotation.getSource());
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtAnnotationEntry");
        Object object = ((KtAnnotationEntry)psiElement).getValueArgumentList();
        return object != null && (object = ((KtValueArgumentList)object).getArguments()) != null ? (KtValueArgument)CollectionsKt.first((List)object) : null;
    }

    private static final void check$checkTypeParameter(JsExportDeclarationChecker this$0, BindingContext bindingContext, BindingTrace trace, TypeParameterDescriptor descriptor) {
        for (KotlinType upperBound : descriptor.getUpperBounds()) {
            PsiElement typeParameterDeclaration;
            Intrinsics.checkNotNull((Object)upperBound);
            if (JsExportDeclarationChecker.isExportable$default(this$0, upperBound, bindingContext, null, 2, null)) continue;
            Intrinsics.checkNotNull((Object)DescriptorToSourceUtils.descriptorToDeclaration(descriptor));
            trace.report(ErrorsJs.NON_EXPORTABLE_TYPE.on(typeParameterDeclaration, "upper bound", upperBound));
        }
    }

    private static final void check$checkValueParameter(JsExportDeclarationChecker this$0, BindingContext bindingContext, BindingTrace trace, ValueParameterDescriptor descriptor) {
        KotlinType kotlinType = descriptor.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        if (!JsExportDeclarationChecker.isExportable$default(this$0, kotlinType, bindingContext, null, 2, null)) {
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(descriptor);
            Intrinsics.checkNotNull((Object)psiElement);
            PsiElement valueParameterDeclaration = psiElement;
            trace.report(ErrorsJs.NON_EXPORTABLE_TYPE.on(valueParameterDeclaration, "parameter", descriptor.getType()));
        }
    }

    private static final void check$reportWrongExportedDeclaration(BindingTrace trace, KtDeclaration $declaration, String kind) {
        trace.report(ErrorsJs.WRONG_EXPORTED_DECLARATION.on((KtExpression)((PsiElement)$declaration), kind));
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClassKind.values().length];
            try {
                nArray[ClassKind.ANNOTATION_CLASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.CLASS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

