/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.session;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.config.AnalysisFlags;
import ksp.org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.resolve.providers.FirSymbolNamesProvider;
import ksp.org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import ksp.org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderInternals;
import ksp.org.jetbrains.kotlin.fir.resolve.providers.impl.FirBuiltinSymbolProvider;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J*\u0010\u0010\u001a\u00020\u00112\u0010\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J&\u0010\u0019\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J&\u0010\u001b\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001e\u001a\u00020\u0016H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lksp/org/jetbrains/kotlin/fir/session/FirJvmActualizingBuiltinSymbolProvider;", "Lksp/org/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "refinedSourceSymbolProviders", "", "builtinSymbolProvider", "Lksp/org/jetbrains/kotlin/fir/resolve/providers/impl/FirBuiltinSymbolProvider;", "<init>", "(Ljava/util/List;Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirBuiltinSymbolProvider;)V", "getClassLikeSymbolByClassId", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "classId", "Lksp/org/jetbrains/kotlin/name/ClassId;", "symbolNamesProvider", "Lksp/org/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "getSymbolNamesProvider", "()Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "getTopLevelCallableSymbolsTo", "", "destination", "", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "packageFqName", "Lksp/org/jetbrains/kotlin/name/FqName;", "name", "Lksp/org/jetbrains/kotlin/name/Name;", "getTopLevelFunctionSymbolsTo", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "getTopLevelPropertySymbolsTo", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "getPackage", "fqName", "entrypoint"})
public final class FirJvmActualizingBuiltinSymbolProvider
extends FirSymbolProvider {
    @NotNull
    private final List<FirSymbolProvider> refinedSourceSymbolProviders;
    @NotNull
    private final FirBuiltinSymbolProvider builtinSymbolProvider;
    @NotNull
    private final FirSymbolNamesProvider symbolNamesProvider;

    public FirJvmActualizingBuiltinSymbolProvider(@NotNull List<? extends FirSymbolProvider> refinedSourceSymbolProviders, @NotNull FirBuiltinSymbolProvider builtinSymbolProvider) {
        Intrinsics.checkNotNullParameter(refinedSourceSymbolProviders, (String)"refinedSourceSymbolProviders");
        Intrinsics.checkNotNullParameter((Object)builtinSymbolProvider, (String)"builtinSymbolProvider");
        super(builtinSymbolProvider.getSession());
        this.refinedSourceSymbolProviders = refinedSourceSymbolProviders;
        this.builtinSymbolProvider = builtinSymbolProvider;
        if (!FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.getSession()).getFlag(AnalysisFlags.getStdlibCompilation()).booleanValue()) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.symbolNamesProvider = this.builtinSymbolProvider.getSymbolNamesProvider();
    }

    @Nullable
    public FirRegularClassSymbol getClassLikeSymbolByClassId(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        for (FirSymbolProvider symbolProvider : this.refinedSourceSymbolProviders) {
            FirClassLikeSymbol<?> classSymbol;
            if (symbolProvider.getClassLikeSymbolByClassId(classId) == null || !FirHelpersKt.hasAnnotationOrInsideAnnotatedClass((FirBasedSymbol)classSymbol, StandardClassIds.Annotations.INSTANCE.getActualizeByJvmBuiltinProvider(), symbolProvider.getSession())) continue;
            return this.builtinSymbolProvider.getClassLikeSymbolByClassId(classId);
        }
        return null;
    }

    @Override
    @NotNull
    public FirSymbolNamesProvider getSymbolNamesProvider() {
        return this.symbolNamesProvider;
    }

    @Override
    @FirSymbolProviderInternals
    public void getTopLevelCallableSymbolsTo(@NotNull List<FirCallableSymbol<?>> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
    }

    @Override
    @FirSymbolProviderInternals
    public void getTopLevelFunctionSymbolsTo(@NotNull List<FirNamedFunctionSymbol> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
    }

    @Override
    @FirSymbolProviderInternals
    public void getTopLevelPropertySymbolsTo(@NotNull List<FirPropertySymbol> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
    }

    @Override
    @Nullable
    public FqName getPackage(@NotNull FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        return this.builtinSymbolProvider.getPackage(fqName);
    }
}

