/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.descriptors.Modality;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.ClassMembersKt;
import ksp.org.jetbrains.kotlin.fir.FirElement;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirModifier;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirConstructor;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J4\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0012"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmExternalDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "<init>", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkInternal", "reportSource", "Lksp/org/jetbrains/kotlin/KtSourceElement;", "modality", "Lksp/org/jetbrains/kotlin/descriptors/Modality;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmExternalDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmExternalDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmExternalDeclarationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 4 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n*L\n1#1,85:1\n11#2:86\n45#2:87\n11#2:90\n43#2:91\n72#3:88\n34#4:89\n*S KotlinDebug\n*F\n+ 1 FirJvmExternalDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmExternalDeclarationChecker\n*L\n45#1:86\n49#1:87\n71#1:90\n80#1:91\n69#1:88\n69#1:89\n*E\n"})
public final class FirJvmExternalDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJvmExternalDeclarationChecker INSTANCE = new FirJvmExternalDeclarationChecker();

    private FirJvmExternalDeclarationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (declaration2 instanceof FirPropertyAccessor) {
            return;
        }
        this.checkInternal(declaration2, null, null, context2, reporter);
    }

    private final void checkInternal(FirDeclaration declaration2, KtSourceElement reportSource, Modality modality, CheckerContext context2, DiagnosticReporter reporter) {
        FirRegularClassSymbol containingClassSymbol;
        FirMemberDeclaration it;
        if (!(declaration2 instanceof FirMemberDeclaration)) {
            return;
        }
        if (declaration2 instanceof FirProperty) {
            FirPropertyAccessor firPropertyAccessor = ((FirProperty)declaration2).getGetter();
            if (firPropertyAccessor != null) {
                it = firPropertyAccessor;
                boolean bl = false;
                FirMemberDeclaration $this$modality$iv = (FirMemberDeclaration)declaration2;
                boolean $i$f$getModality = false;
                INSTANCE.checkInternal(it, ((FirProperty)declaration2).getSource(), $this$modality$iv.getStatus().getModality(), context2, reporter);
            }
        }
        FirMemberDeclaration $this$isExternal$iv = (FirMemberDeclaration)declaration2;
        boolean $i$f$isExternal = false;
        if (!$this$isExternal$iv.getStatus().isExternal()) {
            return;
        }
        KtSourceElement ktSourceElement = ((FirMemberDeclaration)declaration2).getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement source = ktSourceElement;
        if (source.getKind() instanceof KtFakeSourceElementKind) {
            return;
        }
        if (!(declaration2 instanceof FirFunction)) {
            FirModifier<?> externalModifier;
            it = (FirMemberDeclaration)declaration2;
            String target = it instanceof FirProperty ? "property" : (it instanceof FirRegularClass ? "class" : "non-function declaration");
            FirElement firElement = declaration2;
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.EXTERNAL_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"EXTERNAL_KEYWORD");
            FirModifier<?> firModifier = externalModifier = FirKeywordUtilsKt.getModifier(firElement, ktModifierKeywordToken);
            if (firModifier != null) {
                FirModifier<?> it2 = firModifier;
                boolean bl = false;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it2.getSource(), FirErrors.INSTANCE.getWRONG_MODIFIER_TARGET(), (Object)it2.getToken(), (Object)target, (DiagnosticContext)context2, null, 32, null);
            }
            return;
        }
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag((FirCallableSymbol)((FirFunction)declaration2).getSymbol());
        FirRegularClassSymbol firRegularClassSymbol = containingClassSymbol = coneClassLikeLookupTag != null ? LookupTagUtilsKt.toFirRegularClassSymbol(coneClassLikeLookupTag, context2.getSession()) : null;
        if (containingClassSymbol != null) {
            FirClassSymbol $this$isInterface$iv = containingClassSymbol;
            boolean $i$f$isInterface = false;
            ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
            boolean $i$f$isInterface2 = false;
            boolean bl = $this$isInterface$iv$iv == ClassKind.INTERFACE;
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirFunction)declaration2).getSource(), FirJvmErrors.INSTANCE.getEXTERNAL_DECLARATION_IN_INTERFACE(), (DiagnosticContext)context2, null, 8, null);
            } else {
                Modality modality2 = modality;
                if (modality2 == null) {
                    FirMemberDeclaration $this$modality$iv = (FirMemberDeclaration)declaration2;
                    boolean $i$f$getModality = false;
                    modality2 = $this$modality$iv.getStatus().getModality();
                }
                if (modality2 == Modality.ABSTRACT) {
                    KtSourceElement ktSourceElement2 = reportSource;
                    if (ktSourceElement2 == null) {
                        ktSourceElement2 = ((FirFunction)declaration2).getSource();
                    }
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)ktSourceElement2, FirJvmErrors.INSTANCE.getEXTERNAL_DECLARATION_CANNOT_BE_ABSTRACT(), (DiagnosticContext)context2, null, 8, null);
                }
            }
        }
        if (!(declaration2 instanceof FirConstructor) && ((FirFunction)declaration2).getBody() != null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirFunction)declaration2).getSource(), FirJvmErrors.INSTANCE.getEXTERNAL_DECLARATION_CANNOT_HAVE_BODY(), (DiagnosticContext)context2, null, 8, null);
        }
        FirMemberDeclaration $this$isInline$iv = (FirMemberDeclaration)declaration2;
        boolean $i$f$isInline = false;
        if ($this$isInline$iv.getStatus().isInline()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirFunction)declaration2).getSource(), FirJvmErrors.INSTANCE.getEXTERNAL_DECLARATION_CANNOT_BE_INLINED(), (DiagnosticContext)context2, null, 8, null);
        }
    }
}

