/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.codegen;

import java.util.Collections;
import java.util.List;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.codegen.AnnotationCodegen;
import ksp.org.jetbrains.kotlin.codegen.AsmUtil;
import ksp.org.jetbrains.kotlin.codegen.ClassBuilder;
import ksp.org.jetbrains.kotlin.codegen.ClassBuilderRecordKt;
import ksp.org.jetbrains.kotlin.codegen.CodegenUtilKt;
import ksp.org.jetbrains.kotlin.codegen.DescriptorAsmUtil;
import ksp.org.jetbrains.kotlin.codegen.ExceptionLogger;
import ksp.org.jetbrains.kotlin.codegen.ExpressionCodegen;
import ksp.org.jetbrains.kotlin.codegen.FunctionCodegen;
import ksp.org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import ksp.org.jetbrains.kotlin.codegen.ImplementationBodyCodegen;
import ksp.org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import ksp.org.jetbrains.kotlin.codegen.MemberCodegen;
import ksp.org.jetbrains.kotlin.codegen.OwnerKind;
import ksp.org.jetbrains.kotlin.codegen.StackValue;
import ksp.org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import ksp.org.jetbrains.kotlin.codegen.context.CodegenContextUtil;
import ksp.org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import ksp.org.jetbrains.kotlin.codegen.context.MultifileClassFacadeContext;
import ksp.org.jetbrains.kotlin.codegen.context.MultifileClassPartContext;
import ksp.org.jetbrains.kotlin.codegen.serialization.JvmSerializationBindings;
import ksp.org.jetbrains.kotlin.codegen.state.GenerationState;
import ksp.org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import ksp.org.jetbrains.kotlin.descriptors.FieldDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.VariableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import ksp.org.jetbrains.kotlin.descriptors.annotations.Annotations;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.fileClasses.JvmFileClassUtilsKt;
import ksp.org.jetbrains.kotlin.load.java.DescriptorsJvmAbiUtil;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import ksp.org.jetbrains.kotlin.psi.KtElement;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtParameter;
import ksp.org.jetbrains.kotlin.psi.KtProperty;
import ksp.org.jetbrains.kotlin.psi.KtPropertyAccessor;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.DescriptorFactory;
import ksp.org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import ksp.org.jetbrains.kotlin.resolve.DescriptorUtils;
import ksp.org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.util.UnderscoreUtilKt;
import ksp.org.jetbrains.kotlin.resolve.constants.ConstantValue;
import ksp.org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import ksp.org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import ksp.org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import ksp.org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodGenericSignature;
import ksp.org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import ksp.org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedPropertyDescriptor;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.error.ErrorTypeKind;
import ksp.org.jetbrains.kotlin.types.error.ErrorUtils;
import ksp.org.jetbrains.org.objectweb.asm.FieldVisitor;
import ksp.org.jetbrains.org.objectweb.asm.MethodVisitor;
import ksp.org.jetbrains.org.objectweb.asm.Type;
import ksp.org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import ksp.org.jetbrains.org.objectweb.asm.commons.Method;

public class PropertyCodegen {
    private final GenerationState state;
    private final ClassBuilder v;
    private final FunctionCodegen functionCodegen;
    private final KotlinTypeMapper typeMapper;
    private final BindingContext bindingContext;
    private final FieldOwnerContext context;
    private final MemberCodegen<?> memberCodegen;
    private final OwnerKind kind;

    public PropertyCodegen(@NotNull FieldOwnerContext context2, @NotNull ClassBuilder v, @NotNull FunctionCodegen functionCodegen, @NotNull MemberCodegen<?> memberCodegen) {
        if (context2 == null) {
            PropertyCodegen.$$$reportNull$$$0(0);
        }
        if (v == null) {
            PropertyCodegen.$$$reportNull$$$0(1);
        }
        if (functionCodegen == null) {
            PropertyCodegen.$$$reportNull$$$0(2);
        }
        if (memberCodegen == null) {
            PropertyCodegen.$$$reportNull$$$0(3);
        }
        this.state = functionCodegen.state;
        this.v = v;
        this.functionCodegen = functionCodegen;
        this.typeMapper = this.state.getTypeMapper();
        this.bindingContext = this.state.getBindingContext();
        this.context = context2;
        this.memberCodegen = memberCodegen;
        this.kind = context2.getContextKind();
    }

    public void gen(@NotNull KtProperty property) {
        VariableDescriptor variableDescriptor;
        if (property == null) {
            PropertyCodegen.$$$reportNull$$$0(4);
        }
        if (!((variableDescriptor = this.bindingContext.get(BindingContext.VARIABLE, property)) instanceof PropertyDescriptor)) {
            throw ExceptionLogger.logDescriptorNotFound("Property " + property.getName() + " should have a property descriptor: " + variableDescriptor, property);
        }
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)variableDescriptor;
        this.gen(property, propertyDescriptor, property.getGetter(), property.getSetter());
    }

    public void genDestructuringDeclaration(@NotNull KtDestructuringDeclarationEntry entry) {
        VariableDescriptor variableDescriptor;
        if (entry == null) {
            PropertyCodegen.$$$reportNull$$$0(5);
        }
        if (!((variableDescriptor = this.bindingContext.get(BindingContext.VARIABLE, entry)) instanceof PropertyDescriptor)) {
            throw ExceptionLogger.logDescriptorNotFound("Destructuring declaration entry" + entry.getName() + " should have a property descriptor: " + variableDescriptor, entry);
        }
        if (!UnderscoreUtilKt.isSingleUnderscore(entry)) {
            this.genDestructuringDeclaration((PropertyDescriptor)variableDescriptor);
        }
    }

    public void generateInPackageFacade(@NotNull DeserializedPropertyDescriptor deserializedProperty) {
        if (deserializedProperty == null) {
            PropertyCodegen.$$$reportNull$$$0(6);
        }
        assert (this.context instanceof MultifileClassFacadeContext) : "should be called only for generating facade: " + this.context;
        this.genBackingFieldAndAnnotations(deserializedProperty);
        if (!JvmCodegenUtil.isConstOrHasJvmFieldAnnotation(deserializedProperty)) {
            this.generateGetter(deserializedProperty, null);
            this.generateSetter(deserializedProperty, null);
        }
    }

    private void gen(@NotNull KtProperty declaration2, @NotNull PropertyDescriptor descriptor, @Nullable KtPropertyAccessor getter2, @Nullable KtPropertyAccessor setter2) {
        boolean isDefaultGetterAndSetter;
        if (declaration2 == null) {
            PropertyCodegen.$$$reportNull$$$0(7);
        }
        if (descriptor == null) {
            PropertyCodegen.$$$reportNull$$$0(8);
        }
        assert (this.kind == OwnerKind.PACKAGE || this.kind == OwnerKind.IMPLEMENTATION || this.kind == OwnerKind.DEFAULT_IMPLS || this.kind == OwnerKind.ERASED_INLINE_CLASS) : "Generating property with a wrong kind (" + (Object)((Object)this.kind) + "): " + descriptor;
        this.genBackingFieldAndAnnotations(descriptor);
        boolean bl = isDefaultGetterAndSetter = PropertyCodegen.isDefaultAccessor(getter2) && PropertyCodegen.isDefaultAccessor(setter2);
        if (this.isAccessorNeeded(descriptor, getter2, isDefaultGetterAndSetter)) {
            this.generateGetter(descriptor, getter2);
        }
        if (this.isAccessorNeeded(descriptor, setter2, isDefaultGetterAndSetter)) {
            this.generateSetter(descriptor, setter2);
        }
    }

    private static boolean isDefaultAccessor(@Nullable KtPropertyAccessor accessor) {
        return accessor == null || !accessor.hasBody();
    }

    private void genDestructuringDeclaration(@NotNull PropertyDescriptor descriptor) {
        if (descriptor == null) {
            PropertyCodegen.$$$reportNull$$$0(9);
        }
        assert (this.kind == OwnerKind.PACKAGE || this.kind == OwnerKind.IMPLEMENTATION || this.kind == OwnerKind.DEFAULT_IMPLS) : "Generating property with a wrong kind (" + (Object)((Object)this.kind) + "): " + descriptor;
        this.genBackingFieldAndAnnotations(descriptor);
        this.generateGetter(descriptor, null);
        this.generateSetter(descriptor, null);
    }

    private void genBackingFieldAndAnnotations(@NotNull PropertyDescriptor descriptor) {
        if (descriptor == null) {
            PropertyCodegen.$$$reportNull$$$0(10);
        }
        boolean isBackingFieldOwner = descriptor.isConst() && !DescriptorVisibilities.isPrivate(descriptor.getVisibility()) ? !(this.context instanceof MultifileClassPartContext) : CodegenContextUtil.isImplementationOwner(this.context, descriptor);
        this.generateBackingField(descriptor, isBackingFieldOwner);
        this.generateSyntheticMethodIfNeeded(descriptor, isBackingFieldOwner);
    }

    private boolean isAccessorNeeded(@NotNull PropertyDescriptor descriptor, @Nullable KtPropertyAccessor accessor, boolean isDefaultGetterAndSetter) {
        if (descriptor == null) {
            PropertyCodegen.$$$reportNull$$$0(11);
        }
        return PropertyCodegen.isAccessorNeeded(descriptor, accessor, isDefaultGetterAndSetter, this.kind);
    }

    public static boolean isReferenceablePropertyWithGetter(@NotNull PropertyDescriptor descriptor) {
        PsiElement psiElement;
        KtDeclaration ktDeclaration;
        if (descriptor == null) {
            PropertyCodegen.$$$reportNull$$$0(12);
        }
        KtDeclaration ktDeclaration2 = ktDeclaration = (psiElement = DescriptorToSourceUtils.descriptorToDeclaration(descriptor)) instanceof KtDeclaration ? (KtDeclaration)psiElement : null;
        if (ktDeclaration instanceof KtProperty) {
            KtProperty ktProperty = (KtProperty)ktDeclaration;
            boolean isDefaultGetterAndSetter = PropertyCodegen.isDefaultAccessor(ktProperty.getGetter()) && PropertyCodegen.isDefaultAccessor(ktProperty.getSetter());
            return PropertyCodegen.isAccessorNeeded(descriptor, ktProperty.getGetter(), isDefaultGetterAndSetter, OwnerKind.IMPLEMENTATION);
        }
        if (ktDeclaration instanceof KtParameter) {
            return PropertyCodegen.isAccessorNeeded(descriptor, null, true, OwnerKind.IMPLEMENTATION);
        }
        return PropertyCodegen.isAccessorNeeded(descriptor, null, false, OwnerKind.IMPLEMENTATION);
    }

    private static boolean isAccessorNeeded(@NotNull PropertyDescriptor descriptor, @Nullable KtPropertyAccessor accessor, boolean isDefaultGetterAndSetter, OwnerKind kind) {
        if (descriptor == null) {
            PropertyCodegen.$$$reportNull$$$0(13);
        }
        if (JvmCodegenUtil.isConstOrHasJvmFieldAnnotation(descriptor)) {
            return false;
        }
        boolean isDefaultAccessor = PropertyCodegen.isDefaultAccessor(accessor);
        if (kind == OwnerKind.DEFAULT_IMPLS && isDefaultAccessor) {
            return false;
        }
        if (descriptor.isDelegated() || descriptor.getExtensionReceiverParameter() != null) {
            return true;
        }
        if (DescriptorUtils.isCompanionObject(descriptor.getContainingDeclaration())) {
            return !DescriptorVisibilities.isPrivate(descriptor.getVisibility()) || !isDefaultGetterAndSetter;
        }
        if (JvmFileClassUtilsKt.isTopLevelInJvmMultifileClass(descriptor)) {
            return true;
        }
        if (DescriptorVisibilities.isPrivate(descriptor.getVisibility())) {
            return !isDefaultAccessor;
        }
        if (accessor != null && accessor.isSetter() && DescriptorVisibilities.isPrivate(descriptor.getSetter().getVisibility())) {
            return !isDefaultAccessor;
        }
        return !InlineClassesUtilsKt.isUnderlyingPropertyOfInlineClass(descriptor) || descriptor.getVisibility().isPublicAPI();
    }

    private static boolean areAccessorsNeededForPrimaryConstructorProperty(@NotNull PropertyDescriptor descriptor, @NotNull OwnerKind kind) {
        if (descriptor == null) {
            PropertyCodegen.$$$reportNull$$$0(14);
        }
        if (kind == null) {
            PropertyCodegen.$$$reportNull$$$0(15);
        }
        if (JvmAnnotationUtilKt.hasJvmFieldAnnotation(descriptor)) {
            return false;
        }
        if (kind == OwnerKind.ERASED_INLINE_CLASS) {
            return false;
        }
        DescriptorVisibility visibility = descriptor.getVisibility();
        if (InlineClassesUtilsKt.isInlineClass(descriptor.getContainingDeclaration())) {
            return visibility.isPublicAPI();
        }
        return !DescriptorVisibilities.isPrivate(visibility);
    }

    public void generatePrimaryConstructorProperty(@NotNull PropertyDescriptor descriptor) {
        if (descriptor == null) {
            PropertyCodegen.$$$reportNull$$$0(16);
        }
        this.genBackingFieldAndAnnotations(descriptor);
        if (PropertyCodegen.areAccessorsNeededForPrimaryConstructorProperty(descriptor, this.context.getContextKind())) {
            this.generateGetter(descriptor, null);
            this.generateSetter(descriptor, null);
        }
    }

    public void generateConstructorPropertyAsMethodForAnnotationClass(@NotNull KtParameter parameter2, @NotNull PropertyDescriptor descriptor, @Nullable FunctionDescriptor expectedAnnotationConstructor) {
        if (parameter2 == null) {
            PropertyCodegen.$$$reportNull$$$0(17);
        }
        if (descriptor == null) {
            PropertyCodegen.$$$reportNull$$$0(18);
        }
        JvmMethodGenericSignature signature = this.typeMapper.mapAnnotationParameterSignature(descriptor);
        Method asmMethod = signature.getAsmMethod();
        MethodVisitor mv2 = this.v.newMethod(JvmDeclarationOriginKt.OtherOrigin(parameter2, descriptor), 1025, asmMethod.getName(), asmMethod.getDescriptor(), signature.getGenericsSignature(), null);
        PropertyGetterDescriptor getter2 = descriptor.getGetter();
        assert (getter2 != null) : "Annotation property should have a getter: " + descriptor;
        this.v.getSerializationBindings().put(JvmSerializationBindings.METHOD_FOR_FUNCTION, getter2, asmMethod);
        AnnotationCodegen.forMethod(mv2, this.memberCodegen, this.state).genAnnotations(getter2, asmMethod.getReturnType(), null);
        KtExpression defaultValue = this.loadAnnotationArgumentDefaultValue(parameter2, descriptor, expectedAnnotationConstructor);
        if (defaultValue != null) {
            ConstantValue<?> constant = ExpressionCodegen.getCompileTimeConstant(defaultValue, this.bindingContext, true, this.state.getConfig().getShouldInlineConstVals());
            assert (!this.state.getClassBuilderMode().generateBodies || constant != null) : "Default value for annotation parameter should be compile time value: " + defaultValue.getText();
            if (constant != null) {
                AnnotationCodegen annotationCodegen2 = AnnotationCodegen.forAnnotationDefaultValue(mv2, this.memberCodegen, this.state);
                annotationCodegen2.generateAnnotationDefaultValue(constant, descriptor.getType());
            }
        }
        mv2.visitEnd();
    }

    private KtExpression loadAnnotationArgumentDefaultValue(@NotNull KtParameter ktParameter, @NotNull PropertyDescriptor descriptor, @Nullable FunctionDescriptor expectedAnnotationConstructor) {
        KtExpression value2;
        if (ktParameter == null) {
            PropertyCodegen.$$$reportNull$$$0(19);
        }
        if (descriptor == null) {
            PropertyCodegen.$$$reportNull$$$0(20);
        }
        if ((value2 = ktParameter.getDefaultValue()) != null) {
            return value2;
        }
        if (expectedAnnotationConstructor != null) {
            ValueParameterDescriptor expectedParameter = (ValueParameterDescriptor)CollectionsKt.single(expectedAnnotationConstructor.getValueParameters(), parameter2 -> parameter2.getName().equals(descriptor.getName()));
            PsiElement element2 = DescriptorToSourceUtils.descriptorToDeclaration(expectedParameter);
            if (!(element2 instanceof KtParameter)) {
                this.state.getDiagnostics().report(Errors.EXPECTED_FUNCTION_SOURCE_WITH_DEFAULT_ARGUMENTS_NOT_FOUND.on(ktParameter));
                return null;
            }
            return ((KtParameter)element2).getDefaultValue();
        }
        return null;
    }

    private void generateBackingField(@NotNull PropertyDescriptor descriptor, boolean isBackingFieldOwner) {
        Object defaultValue;
        if (descriptor == null) {
            PropertyCodegen.$$$reportNull$$$0(21);
        }
        if (JvmCodegenUtil.isJvmInterface(descriptor.getContainingDeclaration()) || this.kind == OwnerKind.DEFAULT_IMPLS || this.kind == OwnerKind.ERASED_INLINE_CLASS) {
            return;
        }
        if (descriptor.isDelegated()) {
            defaultValue = null;
        } else if (Boolean.TRUE.equals(this.bindingContext.get(BindingContext.BACKING_FIELD_REQUIRED, descriptor))) {
            ConstantValue<?> initializer;
            defaultValue = this.shouldWriteFieldInitializer(descriptor) ? ((initializer = descriptor.getCompileTimeInitializer()) == null ? null : initializer.getValue()) : null;
        } else {
            return;
        }
        this.generateBackingField(descriptor, descriptor.isDelegated(), defaultValue, isBackingFieldOwner);
    }

    private void generateSyntheticMethodIfNeeded(@NotNull PropertyDescriptor descriptor, boolean isBackingFieldOwner) {
        Annotations annotations2;
        if (descriptor == null) {
            PropertyCodegen.$$$reportNull$$$0(22);
        }
        if ((annotations2 = descriptor.getAnnotations()).isEmpty()) {
            return;
        }
        Method signature = this.typeMapper.mapSyntheticMethodForPropertyAnnotations(descriptor);
        if (this.kind != OwnerKind.DEFAULT_IMPLS && CodegenContextUtil.isImplementationOwner(this.context, descriptor)) {
            this.v.getSerializationBindings().put(JvmSerializationBindings.SYNTHETIC_METHOD_FOR_PROPERTY, descriptor, signature);
        }
        if (isBackingFieldOwner && (!DescriptorUtils.isInterface(this.context.getContextDescriptor()) || FunctionCodegen.processInterfaceMethod(descriptor, this.kind, false, true, this.state.getJvmDefaultMode()))) {
            this.memberCodegen.generateSyntheticAnnotationsMethod(descriptor, signature, annotations2);
        }
    }

    private void generateBackingField(@NotNull PropertyDescriptor propertyDescriptor, boolean isDelegate, @Nullable Object defaultValue, boolean isBackingFieldOwner) {
        if (propertyDescriptor == null) {
            PropertyCodegen.$$$reportNull$$$0(23);
        }
        FieldDescriptor annotatedField = isDelegate ? propertyDescriptor.getDelegateField() : propertyDescriptor.getBackingField();
        int modifiers2 = DescriptorAsmUtil.getDeprecatedAccessFlag(propertyDescriptor);
        for (AnnotationCodegen.JvmFlagAnnotation flagAnnotation : AnnotationCodegen.FIELD_FLAGS) {
            modifiers2 |= flagAnnotation.getJvmFlag(annotatedField);
        }
        if (this.kind == OwnerKind.PACKAGE) {
            modifiers2 |= 8;
        }
        if (!(propertyDescriptor.isLateInit() || propertyDescriptor.isVar() && !isDelegate)) {
            modifiers2 |= 0x10;
        }
        if (JvmAnnotationUtilKt.hasJvmSyntheticAnnotation(propertyDescriptor)) {
            modifiers2 |= 0x1000;
        }
        KotlinType kotlinType = isDelegate ? PropertyCodegen.getDelegateTypeForProperty(propertyDescriptor, this.bindingContext) : propertyDescriptor.getType();
        Type type2 = this.typeMapper.mapType(kotlinType);
        ClassBuilder builder2 = this.v;
        FieldOwnerContext backingFieldContext = this.context;
        List<String> additionalVisibleAnnotations = Collections.emptyList();
        if (DescriptorAsmUtil.isInstancePropertyWithStaticBackingField(propertyDescriptor)) {
            modifiers2 |= 8;
            if (DescriptorsJvmAbiUtil.isPropertyWithBackingFieldInOuterClass(propertyDescriptor)) {
                ImplementationBodyCodegen codegen2 = (ImplementationBodyCodegen)this.memberCodegen.getParentCodegen();
                builder2 = codegen2.v;
                backingFieldContext = codegen2.context;
                if (DescriptorVisibilities.isPrivate(((ClassDescriptor)propertyDescriptor.getContainingDeclaration()).getVisibility())) {
                    modifiers2 |= 0x20000;
                    additionalVisibleAnnotations = Collections.singletonList(CodegenUtilKt.JAVA_LANG_DEPRECATED);
                }
            }
        }
        modifiers2 |= DescriptorAsmUtil.getVisibilityForBackingField(propertyDescriptor, isDelegate);
        if (DescriptorAsmUtil.isPropertyWithBackingFieldCopyInOuterClass(propertyDescriptor)) {
            ImplementationBodyCodegen parentBodyCodegen = (ImplementationBodyCodegen)this.memberCodegen.getParentCodegen();
            parentBodyCodegen.addCompanionObjectPropertyToCopy(propertyDescriptor, defaultValue);
        }
        String name2 = backingFieldContext.getFieldName(propertyDescriptor, isDelegate);
        this.v.getSerializationBindings().put(JvmSerializationBindings.FIELD_FOR_PROPERTY, propertyDescriptor, new Pair((Object)type2, (Object)name2));
        if (isBackingFieldOwner) {
            String signature = isDelegate ? null : this.typeMapper.mapFieldSignature(kotlinType, propertyDescriptor);
            FieldVisitor fv = builder2.newField(JvmDeclarationOriginKt.OtherOrigin(propertyDescriptor), modifiers2, name2, type2.getDescriptor(), signature, defaultValue);
            if (annotatedField != null) {
                boolean skipNullabilityAnnotations = (modifiers2 & 0x1000) != 0 || propertyDescriptor.isLateInit();
                AnnotationCodegen.forField(fv, this.memberCodegen, this.state, skipNullabilityAnnotations).genAnnotations(annotatedField, type2, propertyDescriptor.getType(), null, additionalVisibleAnnotations);
            }
            if (propertyDescriptor.getContainingDeclaration() instanceof ClassDescriptor && JvmAnnotationUtilKt.isJvmRecord((ClassDescriptor)propertyDescriptor.getContainingDeclaration())) {
                ClassBuilderRecordKt.addRecordComponent(builder2, name2, type2.getDescriptor(), signature);
            }
        }
    }

    @NotNull
    public static KotlinType getDelegateTypeForProperty(@NotNull PropertyDescriptor propertyDescriptor, @NotNull BindingContext bindingContext) {
        KtExpression delegateExpression;
        if (propertyDescriptor == null) {
            PropertyCodegen.$$$reportNull$$$0(24);
        }
        if (bindingContext == null) {
            PropertyCodegen.$$$reportNull$$$0(25);
        }
        ResolvedCall<FunctionDescriptor> provideDelegateResolvedCall = bindingContext.get(BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL, propertyDescriptor);
        KtProperty property = (KtProperty)DescriptorToSourceUtils.descriptorToDeclaration(propertyDescriptor);
        KtExpression ktExpression = delegateExpression = property != null ? property.getDelegateExpression() : null;
        KotlinType delegateType = provideDelegateResolvedCall != null ? provideDelegateResolvedCall.getResultingDescriptor().getReturnType() : (delegateExpression != null ? bindingContext.getType(delegateExpression) : null);
        if (delegateType == null) {
            delegateType = ErrorUtils.createErrorType(ErrorTypeKind.TYPE_FOR_DELEGATION, delegateExpression.getText());
        }
        KotlinType kotlinType = delegateType;
        if (kotlinType == null) {
            PropertyCodegen.$$$reportNull$$$0(26);
        }
        return kotlinType;
    }

    private boolean shouldWriteFieldInitializer(@NotNull PropertyDescriptor descriptor) {
        if (descriptor == null) {
            PropertyCodegen.$$$reportNull$$$0(27);
        }
        if (!descriptor.isConst() && this.state.getLanguageVersionSettings().supportsFeature(LanguageFeature.NoConstantValueAttributeForNonConstVals)) {
            return false;
        }
        if (!descriptor.isVar()) {
            Type type2 = this.typeMapper.mapType(descriptor);
            return AsmUtil.isPrimitive(type2) || "java.lang.String".equals(type2.getClassName());
        }
        return false;
    }

    private void generateGetter(@NotNull PropertyDescriptor descriptor, @Nullable KtPropertyAccessor getter2) {
        if (descriptor == null) {
            PropertyCodegen.$$$reportNull$$$0(28);
        }
        this.generateAccessor(getter2, descriptor.getGetter() != null ? descriptor.getGetter() : DescriptorFactory.createDefaultGetter(descriptor, Annotations.Companion.getEMPTY()));
    }

    private void generateSetter(@NotNull PropertyDescriptor descriptor, @Nullable KtPropertyAccessor setter2) {
        if (descriptor == null) {
            PropertyCodegen.$$$reportNull$$$0(29);
        }
        if (!descriptor.isVar()) {
            return;
        }
        this.generateAccessor(setter2, descriptor.getSetter() != null ? descriptor.getSetter() : DescriptorFactory.createDefaultSetter(descriptor, Annotations.Companion.getEMPTY(), Annotations.Companion.getEMPTY()));
    }

    private void generateAccessor(@Nullable KtPropertyAccessor accessor, @NotNull PropertyAccessorDescriptor descriptor) {
        if (descriptor == null) {
            PropertyCodegen.$$$reportNull$$$0(30);
        }
        if (this.context instanceof MultifileClassFacadeContext && (DescriptorVisibilities.isPrivate(descriptor.getVisibility()) || DescriptorAsmUtil.getVisibilityAccessFlag(descriptor) == 2)) {
            return;
        }
        FunctionGenerationStrategy.CodegenBased strategy = accessor == null || !accessor.hasBody() ? (descriptor.getCorrespondingProperty().isDelegated() ? new DelegatedPropertyAccessorStrategy(this.state, descriptor) : new DefaultPropertyAccessorStrategy(this.state, descriptor)) : new FunctionGenerationStrategy.FunctionDefault(this.state, accessor);
        this.functionCodegen.generateMethod(JvmDeclarationOriginKt.OtherOrigin(descriptor), descriptor, strategy);
    }

    public static StackValue invokeDelegatedPropertyConventionMethod(@NotNull ExpressionCodegen codegen2, @NotNull ResolvedCall<FunctionDescriptor> resolvedCall2, @NotNull StackValue receiver, @NotNull PropertyDescriptor propertyDescriptor) {
        if (codegen2 == null) {
            PropertyCodegen.$$$reportNull$$$0(31);
        }
        if (resolvedCall2 == null) {
            PropertyCodegen.$$$reportNull$$$0(32);
        }
        if (receiver == null) {
            PropertyCodegen.$$$reportNull$$$0(33);
        }
        if (propertyDescriptor == null) {
            PropertyCodegen.$$$reportNull$$$0(34);
        }
        codegen2.tempVariables.put(resolvedCall2.getCall().getValueArguments().get(1).asElement(), PropertyCodegen.getDelegatedPropertyMetadata(propertyDescriptor, codegen2.getBindingContext()));
        return codegen2.invokeFunction(resolvedCall2, receiver);
    }

    public static boolean isDelegatedPropertyWithOptimizedMetadata(@NotNull VariableDescriptorWithAccessors descriptor, @NotNull BindingContext bindingContext) {
        if (descriptor == null) {
            PropertyCodegen.$$$reportNull$$$0(35);
        }
        if (bindingContext == null) {
            PropertyCodegen.$$$reportNull$$$0(36);
        }
        return Boolean.TRUE == bindingContext.get(CodegenBinding.DELEGATED_PROPERTY_WITH_OPTIMIZED_METADATA, descriptor);
    }

    @NotNull
    public static StackValue getOptimizedDelegatedPropertyMetadataValue() {
        StackValue stackValue = StackValue.constant(null, AsmTypes.K_PROPERTY_TYPE);
        if (stackValue == null) {
            PropertyCodegen.$$$reportNull$$$0(37);
        }
        return stackValue;
    }

    @NotNull
    public static StackValue getDelegatedPropertyMetadata(@NotNull VariableDescriptorWithAccessors descriptor, @NotNull BindingContext bindingContext) {
        int index;
        if (descriptor == null) {
            PropertyCodegen.$$$reportNull$$$0(38);
        }
        if (bindingContext == null) {
            PropertyCodegen.$$$reportNull$$$0(39);
        }
        if (PropertyCodegen.isDelegatedPropertyWithOptimizedMetadata(descriptor, bindingContext)) {
            return PropertyCodegen.getOptimizedDelegatedPropertyMetadataValue();
        }
        Type owner = bindingContext.get(CodegenBinding.DELEGATED_PROPERTY_METADATA_OWNER, descriptor);
        assert (owner != null) : "Delegated property owner not found: " + descriptor;
        List<VariableDescriptorWithAccessors> allDelegatedProperties = bindingContext.get(CodegenBinding.DELEGATED_PROPERTIES_WITH_METADATA, owner);
        int n = index = allDelegatedProperties == null ? -1 : allDelegatedProperties.indexOf(descriptor);
        if (index < 0) {
            throw new AssertionError((Object)("Delegated property not found in " + owner + ": " + descriptor));
        }
        StackValue.Field array = StackValue.field(Type.getType("[" + AsmTypes.K_PROPERTY_TYPE), owner, "$$delegatedProperties", true, StackValue.none());
        StackValue stackValue = StackValue.arrayElement(AsmTypes.K_PROPERTY_TYPE, null, array, StackValue.constant(index));
        if (stackValue == null) {
            PropertyCodegen.$$$reportNull$$$0(40);
        }
        return stackValue;
    }

    public void genDelegate(@NotNull PropertyDescriptor delegate, @NotNull PropertyDescriptor delegateTo, @NotNull StackValue field) {
        PropertySetterDescriptor setter2;
        if (delegate == null) {
            PropertyCodegen.$$$reportNull$$$0(41);
        }
        if (delegateTo == null) {
            PropertyCodegen.$$$reportNull$$$0(42);
        }
        if (field == null) {
            PropertyCodegen.$$$reportNull$$$0(43);
        }
        ClassDescriptor toClass = (ClassDescriptor)delegateTo.getContainingDeclaration();
        PropertyGetterDescriptor getter2 = delegate.getGetter();
        if (getter2 != null) {
            this.functionCodegen.genDelegate(getter2, delegateTo.getGetter().getOriginal(), toClass, field);
        }
        if ((setter2 = delegate.getSetter()) != null) {
            this.functionCodegen.genDelegate(setter2, delegateTo.getSetter().getOriginal(), toClass, field);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 26: 
            case 37: 
            case 40: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 26: 
            case 37: 
            case 40: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionCodegen";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberCodegen";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deserializedProperty";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ktParameter";
                break;
            }
            case 23: 
            case 24: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyDescriptor";
                break;
            }
            case 25: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingContext";
                break;
            }
            case 26: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/org/jetbrains/kotlin/codegen/PropertyCodegen";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codegen";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedCall";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegateTo";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/org/jetbrains/kotlin/codegen/PropertyCodegen";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegateTypeForProperty";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptimizedDelegatedPropertyMetadataValue";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegatedPropertyMetadata";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "gen";
                break;
            }
            case 5: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "genDestructuringDeclaration";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateInPackageFacade";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "genBackingFieldAndAnnotations";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isAccessorNeeded";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceablePropertyWithGetter";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "areAccessorsNeededForPrimaryConstructorProperty";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "generatePrimaryConstructorProperty";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "generateConstructorPropertyAsMethodForAnnotationClass";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "loadAnnotationArgumentDefaultValue";
                break;
            }
            case 21: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "generateBackingField";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "generateSyntheticMethodIfNeeded";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getDelegateTypeForProperty";
                break;
            }
            case 26: 
            case 37: 
            case 40: {
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "shouldWriteFieldInitializer";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "generateGetter";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "generateSetter";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "generateAccessor";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "invokeDelegatedPropertyConventionMethod";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isDelegatedPropertyWithOptimizedMetadata";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getDelegatedPropertyMetadata";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "genDelegate";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 26: 
            case 37: 
            case 40: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DelegatedPropertyAccessorStrategy
    extends FunctionGenerationStrategy.CodegenBased {
        private final PropertyAccessorDescriptor propertyAccessorDescriptor;

        public DelegatedPropertyAccessorStrategy(@NotNull GenerationState state, @NotNull PropertyAccessorDescriptor descriptor) {
            if (state == null) {
                DelegatedPropertyAccessorStrategy.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                DelegatedPropertyAccessorStrategy.$$$reportNull$$$0(1);
            }
            super(state);
            this.propertyAccessorDescriptor = descriptor;
        }

        @Override
        public void doGenerateBody(@NotNull ExpressionCodegen codegen2, @NotNull JvmMethodSignature signature) {
            if (codegen2 == null) {
                DelegatedPropertyAccessorStrategy.$$$reportNull$$$0(2);
            }
            if (signature == null) {
                DelegatedPropertyAccessorStrategy.$$$reportNull$$$0(3);
            }
            InstructionAdapter v = codegen2.v;
            BindingContext bindingContext = this.state.getBindingContext();
            ResolvedCall<FunctionDescriptor> resolvedCall2 = bindingContext.get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, this.propertyAccessorDescriptor);
            assert (resolvedCall2 != null) : "Resolve call should be recorded for delegate call " + signature.toString();
            PropertyDescriptor propertyDescriptor = this.propertyAccessorDescriptor.getCorrespondingProperty();
            StackValue.Property property = codegen2.intermediateValueForProperty(propertyDescriptor, true, null, StackValue.LOCAL_0);
            StackValue.Property delegate = property.getDelegateOrNull();
            assert (delegate != null) : "No delegate for delegated property: " + propertyDescriptor;
            StackValue lastValue = PropertyCodegen.invokeDelegatedPropertyConventionMethod(codegen2, resolvedCall2, delegate, propertyDescriptor);
            Type asmType = signature.getReturnType();
            KotlinType kotlinReturnType = this.propertyAccessorDescriptor.getOriginal().getReturnType();
            lastValue.put(asmType, kotlinReturnType, v);
            v.areturn(asmType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "codegen";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "signature";
                    break;
                }
            }
            objectArray2[1] = "ksp/org/jetbrains/kotlin/codegen/PropertyCodegen$DelegatedPropertyAccessorStrategy";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doGenerateBody";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DefaultPropertyAccessorStrategy
    extends FunctionGenerationStrategy.CodegenBased {
        private final PropertyAccessorDescriptor propertyAccessorDescriptor;

        public DefaultPropertyAccessorStrategy(@NotNull GenerationState state, @NotNull PropertyAccessorDescriptor descriptor) {
            if (state == null) {
                DefaultPropertyAccessorStrategy.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                DefaultPropertyAccessorStrategy.$$$reportNull$$$0(1);
            }
            super(state);
            this.propertyAccessorDescriptor = descriptor;
        }

        @Override
        public void doGenerateBody(@NotNull ExpressionCodegen codegen2, @NotNull JvmMethodSignature signature) {
            if (codegen2 == null) {
                DefaultPropertyAccessorStrategy.$$$reportNull$$$0(2);
            }
            if (signature == null) {
                DefaultPropertyAccessorStrategy.$$$reportNull$$$0(3);
            }
            InstructionAdapter v = codegen2.v;
            PropertyDescriptor propertyDescriptor = this.propertyAccessorDescriptor.getCorrespondingProperty();
            StackValue.Property property = codegen2.intermediateValueForProperty(propertyDescriptor, true, null, StackValue.LOCAL_0);
            PsiElement ktProperty = DescriptorToSourceUtils.descriptorToDeclaration(propertyDescriptor);
            if (ktProperty instanceof KtProperty || ktProperty instanceof KtParameter) {
                codegen2.markLineNumber((KtElement)ktProperty, false);
            }
            if (this.propertyAccessorDescriptor instanceof PropertyGetterDescriptor) {
                Type type2 = signature.getReturnType();
                property.put(type2, v);
                v.areturn(type2);
            } else if (this.propertyAccessorDescriptor instanceof PropertySetterDescriptor) {
                List<ValueParameterDescriptor> valueParameters = this.propertyAccessorDescriptor.getValueParameters();
                assert (valueParameters.size() == 1) : "Property setter should have only one value parameter but has " + this.propertyAccessorDescriptor;
                int parameterIndex = codegen2.lookupLocalIndex(valueParameters.get(0));
                assert (parameterIndex >= 0) : "Local index for setter parameter should be positive or zero: " + this.propertyAccessorDescriptor;
                Type type3 = codegen2.typeMapper.mapType(propertyDescriptor);
                property.store(StackValue.local(parameterIndex, type3), codegen2.v);
                v.visitInsn(177);
            } else {
                throw new IllegalStateException("Unknown property accessor: " + this.propertyAccessorDescriptor);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "codegen";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "signature";
                    break;
                }
            }
            objectArray2[1] = "ksp/org/jetbrains/kotlin/codegen/PropertyCodegen$DefaultPropertyAccessorStrategy";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doGenerateBody";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

